/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.net.InetAddress;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentFactory;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.NoSuchApplicationException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessFactory;
import org.eclipse.hyades.internal.execution.local.control.ProcessListener;
import org.eclipse.hyades.loaders.util.HyadesResourceExtensions;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.navigator.LogNavigator;
import org.eclipse.hyades.log.ui.internal.util.GLAFilterHelper;
import org.eclipse.hyades.log.ui.internal.util.TraceMergeUIDialog;
import org.eclipse.hyades.log.ui.internal.wizards.ImportLogWizard;
import org.eclipse.hyades.log.ui.internal.wizards.ImportLogWizardPage;
import org.eclipse.hyades.log.ui.internal.wizards.LocalGLALogger;
import org.eclipse.hyades.log.ui.internal.wizards.LocalLogParserLoader;
import org.eclipse.hyades.log.ui.internal.wizards.LogFileElement;
import org.eclipse.hyades.log.ui.internal.wizards.LogParserItem;
import org.eclipse.hyades.log.ui.internal.wizards.ParserField;
import org.eclipse.hyades.log.ui.internal.wizards.ParserParameter;
import org.eclipse.hyades.logging.adapter.model.internal.adapter.util.AdapterResourceFactoryImpl;
import org.eclipse.hyades.logging.parsers.Parser;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.plugin.HierarchyPlugin;
import org.eclipse.hyades.models.hierarchy.util.IHyadesExtendedResource;
import org.eclipse.hyades.models.hierarchy.util.IHyadesResourceExtension;
import org.eclipse.hyades.models.hierarchy.util.PerfUtil;
import org.eclipse.hyades.security.util.TString;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceAssociationManager;
import org.eclipse.hyades.trace.ui.internal.piclient.XMLTraceDataProcessor;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.extension.IAssociationMappingRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.Workbench;

public class ImportLogWizard
extends Wizard
implements IImportWizard,
Runnable {
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    protected LogParserItem _parser;
    protected LogNavigator fViewer;
    protected Shell fShell;
    protected String errorMessage = null;
    protected String logParserId;
    protected String reasonAction = null;
    private LogParserItem currentSelectedParser;
    private boolean bAppend = false;
    private final String CANCEL = "cancel";
    private ImportLogWizardPage wizardPage;
    private boolean shouldOpenLogView = false;
    private String detailMsg = null;
    private StatusListener monitorThread = null;
    private TRCAgent displayAgent;
    private LogImportJobListener jobListener = new LogImportJobListener();
    private ArrayList jobPool = null;

    public ImportLogWizard() {
        IDialogSettings workbenchSettings = LogUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("org.eclipse.hyades.log.ui.internal.wizards.ImportLogFile");
        if (section == null) {
            section = workbenchSettings.addNewSection("org.eclipse.hyades.log.ui.internal.wizards.ImportLogFile");
        }
        this.setDialogSettings(section);
        this.fShell = Workbench.getInstance().getActiveWorkbenchWindow().getShell();
    }

    public LogParserItem getSelectedParser() {
        return this._parser;
    }

    public List getLogFileElements() {
        return this.wizardPage.getLogFileElements();
    }

    public void addPages() {
        super.addPages();
        this.setWindowTitle(LogUIPlugin.getResourceString("IMPORT_LOG_FILE_WIZARD_TITLE"));
        this.wizardPage = new ImportLogWizardPage();
        this.addPage((IWizardPage)this.wizardPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.workbench = workbench;
        this.selection = currentSelection;
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        if (!this.performPageFinish()) {
            return false;
        }
        this.errorMessage = null;
        BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ImportLogWizard importLogWizard = this;
        synchronized (importLogWizard) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    block4: {
                        try {
                            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            boolean shouldSwitch = HyadesUIPlugin.getInstance().openPerspectiveSwitchDialog(window.getShell(), "org.eclipse.hyades.trace.internal.ui.tracePerspective", UIPlugin.getDefault().getPreferenceStore(), "switch_to_perspective", LogUIPlugin.getResourceString("CONFIRM_PERSP_SWITCH_MSG"));
                            if (shouldSwitch) {
                                UIPlugin.getActivePage();
                            }
                            if ("org.eclipse.hyades.trace.internal.ui.tracePerspective".equals(window.getActivePage().getPerspective().getId())) {
                                ImportLogWizard.this.fViewer = (LogNavigator)UIPlugin.getActivePage().showView("org.eclipse.hyades.log.ui.internal.navigator.LogNavigator");
                                ImportLogWizard.this.shouldOpenLogView = true;
                                break block4;
                            }
                            ImportLogWizard.this.shouldOpenLogView = false;
                        }
                        catch (Exception e) {
                            HyadesUIPlugin.logError((Throwable)e);
                        }
                    }
                }
            });
        }
        List elements = this.getLogFileElements();
        if (elements.size() > 0) {
            this.jobPool = new ArrayList(elements.size());
        }
        IStatus status = null;
        String errMsg = "";
        int i = 0;
        while (i < elements.size()) {
            status = this.importLog((LogFileElement)elements.get(i));
            if (status.getSeverity() == 4 || status.getChildren().length > 0 && status.getChildren()[0].getSeverity() == 4) {
                Hashtable input = this.getUserInput((LogFileElement)elements.get(i), false);
                String param = (String)input.get("file_path");
                if (param == null) {
                    param = ((LogFileElement)elements.get(i)).getParser().getName();
                }
                errMsg = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_GENERIC_ERR_MSG", new String[]{param});
                ErrorDialog.openError((Shell)this.getShell(), (String)LogUIPlugin.getResourceString("LOGGING_MESSAGE"), (String)errMsg, (IStatus)status);
            }
            ++i;
        }
        LogImportJob job = null;
        int nrOfLocalImports = this.getLocalImportsCount();
        if (nrOfLocalImports > 0) {
            this.monitorThread = new StatusListener(nrOfLocalImports);
        }
        int i2 = 0;
        while (i2 < this.jobPool.size()) {
            job = (LogImportJob)((Object)this.jobPool.get(i2));
            if (job instanceof LocalLogImportJob) {
                ++nrOfLocalImports;
            }
            if (job != null) {
                job.schedule();
            }
            ++i2;
        }
        if (this.monitorThread != null) {
            this.monitorThread.start();
        }
        final TRCAgent refreshAgent = this.displayAgent;
        ImportLogWizard importLogWizard2 = this;
        synchronized (importLogWizard2) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (ImportLogWizard.this.shouldOpenLogView) {
                        ((TreeViewer)ImportLogWizard.this.fViewer.getViewer()).setExpandedState((Object)ImportLogWizard.this.fViewer.getContentProvider().getLogFolder(), true);
                        ImportLogWizard.this.fViewer.getViewer().setSelection((ISelection)new StructuredSelection((Object)refreshAgent.getAgentProxy()));
                        ImportLogWizard.this.openLogView(refreshAgent);
                    }
                }
            });
        }
    }

    private void refreshView(final Object object) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                event.setSource(object);
                event.setType(64);
                UIPlugin.getDefault().notifyProfileEventListener(event);
            }
        });
    }

    protected boolean performPageFinish() {
        return this.wizardPage.finish();
    }

    private String getParserCommand(LogFileElement element, Hashtable input) {
        String cmd = element.getParser().getParserClass().concat(" ");
        Locale defaultLocale = Locale.getDefault();
        String localeProperty = defaultLocale.getLanguage().trim();
        if (localeProperty.length() > 0) {
            input.put("client_locale_language", localeProperty);
            localeProperty = defaultLocale.getCountry().trim();
            if (localeProperty.length() > 0) {
                input.put("client_locale_country", localeProperty);
            }
            if ((localeProperty = defaultLocale.getVariant().trim()).length() > 0) {
                input.put("client_locale_variant", localeProperty);
            }
        }
        Enumeration enumeration = input.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            String value = input.get(key).toString();
            cmd = cmd.concat("\"").concat(key.toString()).concat("=");
            cmd = value.endsWith("\\") || value.endsWith("/") ? cmd.concat(value.substring(0, value.length() - 1)).concat("\" ") : cmd.concat(value).concat("\" ");
        }
        return cmd.trim();
    }

    private Hashtable getUserInput(LogFileElement element, boolean parserParam) {
        Hashtable<String, Object> table = new Hashtable<String, Object>();
        ArrayList fields = element.getParser().getFields();
        int i = fields.size();
        List values = element.getValues();
        i = 0;
        while (i < fields.size()) {
            ParserField field = (ParserField)fields.get(i);
            table.put(field.getId(), values.get(i));
            ++i;
        }
        if (parserParam) {
            ArrayList params = element.getParser().getParserParameters();
            int j = 0;
            while (j < params.size()) {
                ParserParameter param = (ParserParameter)params.get(j);
                table.put(param.getName(), param.getValue());
                ++j;
            }
        }
        return table;
    }

    private TRCAgent createAgent(TRCProcessProxy process, LogFileElement element, TRCAgentProxy mergeAgentProxy) {
        String timestamp;
        TRCAgentProxy agent = null;
        final String name = this.getAgentName(element);
        String type = "Logging";
        if (mergeAgentProxy != null) {
            if (this.bAppend) {
                return mergeAgentProxy.getAgent();
            }
            ((IHyadesExtendedResource)mergeAgentProxy.getAgent().eResource()).delete();
            mergeAgentProxy.setAgent(null);
            mergeAgentProxy.getProcessProxy().eResource().setModified(true);
            mergeAgentProxy.setProcessProxy(null);
        } else {
            EList agents = process.getAgentProxies();
            Object[] agentProxys = agents.toArray();
            int i = 0;
            while (i < agents.size()) {
                agent = (TRCAgentProxy)agentProxys[i];
                if (agent.getName().equals(name)) {
                    this.errorMessage = null;
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            String msg = LogUIPlugin.getResourceString("STR_EXISTING_DATA_DESC_1");
                            msg = TString.change((String)msg, (String)"%1", (String)name);
                            TraceMergeUIDialog dialog = new TraceMergeUIDialog(ImportLogWizard.this.getShell(), msg);
                            int ret = dialog.open();
                            if (ret == 1) {
                                ImportLogWizard.this.errorMessage = "cancel";
                            }
                            if (ret == 2) {
                                ImportLogWizard.this.bAppend = true;
                            }
                            if (ret == 3) {
                                ImportLogWizard.this.bAppend = false;
                            }
                        }
                    });
                    if (this.errorMessage == "cancel") {
                        return null;
                    }
                    if (this.bAppend) {
                        return agent.getAgent();
                    }
                    ((IHyadesExtendedResource)agent.getAgent().eResource()).delete();
                    agent.setAgent(null);
                    agent.getProcessProxy().eResource().setModified(true);
                    agent.setProcessProxy(null);
                }
                ++i;
            }
        }
        Date currentDate = new Date();
        String rID = timestamp = DateFormat.getDateTimeInstance(0, 0).format(currentDate);
        rID = HyadesUtil.change((String)rID, (String)" ", (String)"");
        rID = HyadesUtil.change((String)rID, (String)":", (String)"");
        rID = rID + "-" + currentDate.getTime();
        String agentName = process.getNode().getMonitor().getName() + "_" + process.getNode().getName() + "_" + process.getPid() + "_" + rID + "_" + element.getParser().getDescription();
        agentName = HyadesUtil.change((String)agentName, (String)" ", (String)"");
        String pPath = process.eResource().getURI().toString();
        Path path = new Path(pPath);
        if (path.segmentCount() > 1) {
            pPath = path.removeLastSegments(1).toString();
        }
        String fileName = agentName + this.getAgentNamePostfix(element);
        IPath filePath = new Path(pPath).append(fileName);
        URI uri = URI.createURI((String)filePath.toString());
        Resource agDoc = Resource.Factory.Registry.INSTANCE.getFactory(uri).createResource(uri);
        agDoc.setModified(true);
        EList agExt = agDoc.getContents();
        UIPlugin.getDefault().getResourceSet().getResources().add((Object)agDoc);
        HierarchyFactory factory = UIPlugin.getDefault().getPerftraceFactory();
        agent = factory.createTRCAgentProxy();
        agent.setName(name);
        agent.setType(type);
        agent.setProcessProxy(process);
        process.getAgentProxies().add((Object)agent);
        TRCAgent ag = factory.createTRCAgent();
        ag.setAgentProxy(agent);
        ag.setType(type);
        agExt.add((Object)ag);
        return ag;
    }

    private String getAgentName(LogFileElement element) {
        String fPath = (String)this.getUserInput(element, false).get("file_path");
        String name = element.getParser().getName() + (fPath != null ? " " + fPath : "");
        return name;
    }

    private String getAgentNamePostfix(LogFileElement element) {
        String res = null;
        Preferences store = HierarchyPlugin.getPlugin().getPluginPreferences();
        if (element.isUseLargeLogSupport() && store.contains("largeResourceSupportCurrentDBType")) {
            String activeDBType = store.getString("largeResourceSupportCurrentDBType");
            Iterator iter = HyadesResourceExtensions.getInstance().entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                if (!(entry.getKey() instanceof String)) continue;
                IHyadesResourceExtension hyadesResourceFactory = (IHyadesResourceExtension)entry.getValue();
                String postfix = (String)entry.getKey();
                if (!postfix.endsWith(".trcadb") || !hyadesResourceFactory.getStoreType(postfix).equals(activeDBType)) continue;
                return postfix;
            }
        }
        if (res == null) {
            res = ".trcaxmi";
        }
        return res;
    }

    private TRCProcessProxy createProcess(IContainer container, TRCNode node, LogFileElement element) {
        int pID = 0;
        String logPath = "";
        Hashtable elems = this.getUserInput(element, false);
        Iterator iterator = elems.keySet().iterator();
        if (iterator.hasNext()) {
            logPath = logPath + elems.get(iterator.next()).toString();
        }
        while (iterator.hasNext()) {
            logPath = logPath + " " + elems.get(iterator.next()).toString();
        }
        TRCProcessProxy process = null;
        EList processes = node.getProcessProxies();
        Iterator i = processes.iterator();
        int counter = 0;
        while (i.hasNext()) {
            process = (TRCProcessProxy)i.next();
            ++counter;
            if (process.getName() == null || !process.getName().equals(logPath)) continue;
            process.eResource().setModified(true);
            return process;
        }
        TRCMonitor monitor = node.getMonitor();
        String rID = new Date().toString();
        rID = HyadesUtil.change((String)rID, (String)" ", (String)"");
        rID = HyadesUtil.change((String)rID, (String)":", (String)"");
        String processName = node.getMonitor().getName() + "_" + node.getName() + "_" + counter + "_" + pID;
        String fileName = processName + "." + "trcpxmi";
        IPath path = container.getFullPath().append(fileName);
        URI uri = URI.createURI((String)("platform:/resource" + path.toString()));
        Resource pDoc = Resource.Factory.Registry.INSTANCE.getFactory(uri).createResource(uri);
        pDoc.setModified(true);
        EList pExt = pDoc.getContents();
        UIPlugin.getDefault().getResourceSet().getResources().add((Object)pDoc);
        HierarchyFactory factory = UIPlugin.getDefault().getPerftraceFactory();
        process = factory.createTRCProcessProxy();
        process.setPid(pID);
        process.setRuntimeId(String.valueOf(pID));
        process.setName(logPath);
        process.setLaunchMode(0);
        process.setNode(node);
        pExt.add((Object)process);
        TRCProcessProxy fProcess = process;
        this.refreshView(fProcess);
        return process;
    }

    private void initializeValues() {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.hyades.logging.parsers", "logParser");
        int idx = 0;
        while (idx < config.length) {
            block7: {
                IConfigurationElement elem = config[idx];
                if (this.logParserId.trim().equals(elem.getAttribute("id").trim())) {
                    this._parser = new LogParserItem(elem.getAttribute("id"), elem.getAttribute("name"), elem.getAttribute("ui_name"), elem.getAttribute("description"));
                    this._parser.setConfigurationElement(elem);
                    this._parser.setClass(elem.getAttribute("class"));
                    this._parser.setUIType(elem.getAttribute("ui_type"));
                    String iconPath = elem.getAttribute("icon");
                    if (iconPath != null && iconPath.length() > 0) {
                        URL pluginURL = Platform.getBundle((String)elem.getDeclaringExtension().getNamespace()).getEntry("/");
                        try {
                            URL url = new URL(pluginURL, iconPath);
                            ImageDescriptor image = ImageDescriptor.createFromURL((URL)url);
                            this._parser.setImageDescriptor(image);
                        }
                        catch (Exception exc) {
                            Status status = new Status(4, LogUIPlugin.getPluginId(), 2, "exception.malformedURL", (Throwable)exc);
                            LogUIPlugin.getDefault().getLog().log((IStatus)status);
                            break block7;
                        }
                    }
                    IConfigurationElement[] felems = elem.getChildren("field");
                    int i = 0;
                    while (i < felems.length) {
                        IConfigurationElement felem = felems[i];
                        ParserField pfield = new ParserField(felem.getAttribute("id"), felem.getAttribute("name"));
                        pfield.setConfigurationElement(felem);
                        pfield.setDefaultValue(felem.getAttribute("defaultValue"));
                        pfield.setContextId(felem.getAttribute("helpContextId"));
                        pfield.setTooltip(felem.getAttribute("tooltip"));
                        pfield.setFilters(felem.getAttribute("browseType"));
                        pfield.useBrowse(felem.getAttribute("useBrowse").equals("true"));
                        pfield.setUiType(felem.getAttribute("ui_type"));
                        pfield.setListener(felem.getAttribute("listener"));
                        this._parser.addEntry(pfield);
                        ++i;
                    }
                    IConfigurationElement[] fparameters = elem.getChildren("parserParameter");
                    int i2 = 0;
                    while (i2 < fparameters.length) {
                        IConfigurationElement fparameter = fparameters[i2];
                        ParserParameter para = new ParserParameter(fparameter.getAttribute("name"), fparameter.getAttribute("value"));
                        this._parser.addParameter(para);
                        ++i2;
                    }
                }
            }
            ++idx;
        }
    }

    private void openLogView(TRCAgent agent) {
        IAssociationMappingRegistry registry = TraceAssociationManager.getTraceViewMappingRegistry();
        IAssociationMapping mapping = registry.getAssociationMapping("analyzerExtensions");
        if (mapping == null) {
            return;
        }
        IAssociationDescriptor[] array = mapping.getAssociationDescriptors(agent.getType());
        if (array.length > 0) {
            IAssociationDescriptor desc = array[0];
            try {
                IAction action = (IAction)desc.createImplementationClassInstance();
                if (action != null) {
                    action.run();
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        IWorkbenchPage page = UIPlugin.getActivePage();
        try {
            this.fViewer = (LogNavigator)page.showView("org.eclipse.hyades.log.ui.internal.navigator.LogNavigator");
            StructuredViewer viewer = this.fViewer.getViewer();
            if (viewer != null) {
                viewer.refresh();
            }
        }
        catch (Exception e) {
            HyadesUIPlugin.logError((Throwable)e);
        }
    }

    protected IStatus importLog(LogFileElement element) {
        TRCProcessProxy process;
        TRCAgent agent;
        Node node;
        boolean localHost = true;
        Object parser = null;
        PerfUtil p = new PerfUtil("LogImportWizard.run " + this.getUserInput(element, false).get("file_path"), true);
        this.bAppend = true;
        if (element.getMergedAgent() != null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    TraceMergeUIDialog dialog = new TraceMergeUIDialog(ImportLogWizard.this.getShell(), LogUIPlugin.getResourceString("STR_EXISTING_DATA_DESC_2"));
                    int ret = dialog.open();
                    if (ret == 1) {
                        return;
                    }
                    if (ret == 2) {
                        ImportLogWizard.this.bAppend = true;
                    }
                    if (ret == 3) {
                        ImportLogWizard.this.bAppend = false;
                    }
                }
            });
        }
        String project = element.getProject();
        String monitor = element.getMonitor();
        String host = element.getHost();
        try {
            node = NodeFactory.createNode((String)host);
            Node lnode = NodeFactory.createNode((String)"localhost");
            localHost = node.getName().equals(lnode.getName());
        }
        catch (Exception e) {
            this.reasonAction = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_HOST_REASON");
            this.reasonAction = HyadesUtil.change((String)this.reasonAction, (String)"%1", (String)host);
            Status result = new Status(4, LogUIPlugin.getPluginId(), 0, this.reasonAction, (Throwable)e);
            return result;
        }
        TRCAgent tRCAgent = agent = element.getMergedAgent() != null ? element.getMergedAgent().getAgent() : null;
        if (agent == null) {
            TRCNode trcNode;
            IContainer container = PDCoreUtil.createContainer((IPath)new Path(project));
            TRCMonitor trcMonitor = PDCoreUtil.createMonitor((IContainer)container, (String)monitor);
            IContainer fContainer = container;
            this.refreshView(fContainer);
            String portNb = UIPlugin.getDefault().getPreferenceStore().getString("localhost_port");
            TRCNode fNode = trcNode = PDCoreUtil.createNode((TRCMonitor)trcMonitor, (String)node.getName(), (String)portNb);
            TRCMonitor fMonitor = trcMonitor;
            this.refreshView(fMonitor);
            process = this.createProcess(container, trcNode, element);
            this.refreshView(fNode);
            try {
                this.displayAgent = agent = this.createAgent(process, element, null);
            }
            catch (Exception e) {
                this.errorMessage = LogUIPlugin.getResourceString("AgentCreationError");
                LogUIPlugin.log(e);
                return new Status(4, LogUIPlugin.getPluginId(), 0, this.errorMessage, (Throwable)e);
            }
            if (this.errorMessage != null && this.errorMessage.startsWith("cancel")) {
                return new Status(8, LogUIPlugin.getPluginId(), 0, "", null);
            }
            TRCProcessProxy fProcess = process;
            this.refreshView(fProcess);
        } else {
            process = agent.getAgentProxy().getProcessProxy();
            if (!this.bAppend) {
                agent = this.createAgent(process, element, element.getMergedAgent());
            }
        }
        TRCAgent trcAgent = agent;
        TRCProcessProxy trcProcess = process;
        trcAgent.getAgentProxy().setActive(true);
        if (this.fViewer != null) {
            this.fViewer.getViewer().refresh((Object)trcAgent.getAgentProxy());
        }
        try {
            if (localHost) {
                this.importFromLocalHost(element, trcAgent);
            } else {
                this.importFromRemoteHost(element, trcProcess, trcAgent);
            }
        }
        catch (OperationCanceledException e) {
            return new Status(8, LogUIPlugin.getPluginId(), 0, "", (Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
            MultiStatus result = null;
            if (this.errorMessage == null) {
                this.errorMessage = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_RAC_ERROR_");
            }
            if (this.reasonAction != null) {
                if (this.detailMsg != null) {
                    result = new MultiStatus(LogUIPlugin.getPluginId(), 0, this.reasonAction, (Throwable)e);
                    result.add((IStatus)new Status(4, LogUIPlugin.getPluginId(), 0, this.detailMsg, (Throwable)e));
                } else {
                    result = new Status(4, LogUIPlugin.getPluginId(), 0, this.reasonAction, (Throwable)e);
                }
            } else {
                result = this.detailMsg != null ? new Status(4, LogUIPlugin.getPluginId(), 0, this.detailMsg, (Throwable)e) : (e.getLocalizedMessage() != null ? new Status(4, LogUIPlugin.getPluginId(), 0, e.getLocalizedMessage(), (Throwable)e) : new Status(4, LogUIPlugin.getPluginId(), 0, e.toString(), (Throwable)e));
            }
            trcAgent.getAgentProxy().setActive(false);
            if (this.fViewer != null) {
                this.fViewer.getViewer().refresh((Object)trcAgent.getAgentProxy());
            }
            return result;
        }
        p.stopAndPrintStatus();
        return new Status(0, LogUIPlugin.getPluginId(), 0, "", null);
    }

    protected void importFromLocalHost(LogFileElement element, TRCAgent trcAgent) throws Exception {
        XMLLoader xmlLoader = new XMLLoader(trcAgent);
        Hashtable input = this.getUserInput(element, true);
        Parser parser = element.getParser().getParserInstance();
        if (element.getFilter() != null && element.getFilter().getQuery() != null) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("adapter", new AdapterResourceFactoryImpl());
            String nameSpace = "org.eclipse.hyades.logging.adapter.config";
            if (element.getParser() != null && element.getParser().getNamespace() != null && element.getParser().getNamespace().length() > 0) {
                nameSpace = element.getParser().getNamespace();
            }
            GLAFilterHelper.addFilterToAdapter(null, (ResourceSet)resourceSet, input, element.getFilter().getQuery(), nameSpace);
        }
        LocalLogParserLoader parserLoader = new LocalLogParserLoader(parser, input);
        parserLoader.setXMLLoader(xmlLoader);
        LocalLogImportJob job = new LocalLogImportJob(LogUIPlugin.getResourceString("IMPORT_LOG_FILE_PROGRESS_DESC"), element, parser, xmlLoader, parserLoader, trcAgent);
        job.addJobChangeListener((IJobChangeListener)this.jobListener);
        this.jobPool.add(job);
    }

    protected void importFromRemoteHost(LogFileElement element, TRCProcessProxy trcProcess, TRCAgent trcAgent) throws Exception {
        Node node = PDCoreUtil.profileConnect((String)element.getHost(), (String)String.valueOf(10002));
        if (node == null) {
            return;
        }
        Hashtable userInput = this.getUserInput(element, true);
        if (element.getFilter() != null && element.getFilter().getQuery() != null) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("adapter", new AdapterResourceFactoryImpl());
            String nameSpace = "org.eclipse.hyades.logging.adapter.config";
            if (element.getParser() != null && element.getParser().getNamespace() != null && element.getParser().getNamespace().length() > 0) {
                nameSpace = element.getParser().getNamespace();
            }
            String tempAdapterPath = GLAFilterHelper.addFilterToAdapter(node, (ResourceSet)resourceSet, userInput, element.getFilter().getQuery(), nameSpace);
            element.setTempAdapterPath(tempAdapterPath);
        }
        Process process = ProcessFactory.createProcess((Node)node, (String)"RemoteLogParserLoader", (String)this.getParserCommand(element, userInput));
        process.addProcessListener((ProcessListener)new ProcessListenerImpl(trcProcess, trcAgent.getAgentProxy()));
        Agent agent = AgentFactory.createAgent((Process)process, (String)"Remote Log Loader IRemoteEntity", (String)"Logging");
        TRCAgentProxy aproxy = trcAgent.getAgentProxy();
        agent.setAutoAttach(true);
        Agent errorAgent = AgentFactory.createAgent((Process)process, (String)"Remote Log Loader Error IRemoteEntity", (String)"Logging");
        errorAgent.setAutoAttach(true);
        Agent statusAgent = AgentFactory.createAgent((Process)process, (String)"Remote Log Loader Status IRemoteEntity", (String)"Logging");
        statusAgent.setAutoAttach(true);
        RemoteLogImportJob job = new RemoteLogImportJob(LogUIPlugin.getResourceString("IMPORT_LOG_FILE_PROGRESS_DESC"), element, node, process, errorAgent, trcAgent);
        agent.addAgentListener((AgentListener)new LogAgentListener(job, aproxy, trcProcess));
        ErrorAgentListener errorListener = new ErrorAgentListener();
        errorAgent.addAgentListener((AgentListener)errorListener);
        job.setErrorListener(errorListener);
        statusAgent.addAgentListener((AgentListener)job);
        job.addJobChangeListener((IJobChangeListener)this.jobListener);
        this.jobPool.add(job);
    }

    private int getLocalImportsCount() {
        List elements = this.getLogFileElements();
        int count = 0;
        LogImportJob job = null;
        if (this.jobPool.size() == 0) {
            return 0;
        }
        int i = 0;
        while (i < this.jobPool.size()) {
            job = (LogImportJob)((Object)this.jobPool.get(i));
            if (job != null && job instanceof LocalLogImportJob) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    class StatusListener
    extends Thread {
        private int s;
        private LocalLogImportJob[] jobs;

        public StatusListener(int s) {
            this.s = s;
            this.initialize();
        }

        private void initialize() {
            this.jobs = new LocalLogImportJob[this.s];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            int[] status = null;
            int timeout = 120000;
            long[] startTime = new long[this.s];
            Object parser = null;
            Object agent = null;
            boolean[] tasksBegan = new boolean[this.s];
            int[] unitsWorked = new int[this.s];
            int k = 0;
            while (k < this.s) {
                tasksBegan[k] = false;
                ++k;
            }
            LocalLogImportJob element = null;
            boolean end = false;
            while (!end) {
                int i = 0;
                while (i < this.s) {
                    LocalLogImportJob[] localLogImportJobArray = this.jobs;
                    // MONITORENTER : this.jobs
                    element = this.jobs[i];
                    if (element != null && !element.hasFinished()) {
                        if (startTime[i] == 0L) {
                            startTime[i] = System.currentTimeMillis();
                        }
                        try {
                            status = element.getProgressStatus();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (!tasksBegan[i] && status[0] > 0) {
                            element.getMonitor().beginTask(element.getTaskName(), status[0]);
                            tasksBegan[i] = true;
                        }
                        if (status[0] != 0 && status[1] != 0 && status[0] <= status[1]) {
                            element.setFinished(true);
                            element.getMonitor().done();
                        }
                        if (element.getMonitor().isCanceled()) {
                            element.setStatus((IStatus)new Status(8, LogUIPlugin.getPluginId(), 0, "", null));
                            element.stop();
                            element.setFinished(true);
                            element.getMonitor().done();
                        }
                        if (status[1] > 0) {
                            element.getMonitor().worked(status[1] - unitsWorked[i]);
                            int percent = status[1] * 100 / status[0];
                            element.getMonitor().subTask(" " + percent + "%");
                            unitsWorked[i] = status[1];
                        } else {
                            element.getMonitor().subTask(element.getTaskName());
                        }
                    }
                    end = true;
                    boolean jobStatus = false;
                    int j = 0;
                    while (j < this.s) {
                        boolean bl = jobStatus = this.jobs[j] != null ? this.jobs[j].hasFinished() : false;
                        if (jobStatus) {
                            this.jobs[j].getMonitor().done();
                        }
                        end = end && jobStatus;
                        ++j;
                    }
                    // MONITOREXIT : localLogImportJobArray
                    ++i;
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }

        public synchronized LocalLogImportJob[] getJobs() {
            return this.jobs;
        }

        public synchronized void register(LocalLogImportJob job) {
            Object element = null;
            int s = this.jobs.length;
            int j = 0;
            while (j < s) {
                if (this.jobs[j] == null) {
                    this.jobs[j] = job;
                    break;
                }
                ++j;
            }
        }

        public synchronized boolean hasRegistered(LocalLogImportJob job) {
            Object element = null;
            int s = this.jobs.length;
            int j = 0;
            while (j < s) {
                if (this.jobs[j] == job) {
                    return true;
                }
                ++j;
            }
            return false;
        }
    }

    class LogImportJobListener
    extends JobChangeAdapter {
        LogImportJobListener() {
        }

        public void done(IJobChangeEvent event) {
            if (event.getResult().getSeverity() == 8) {
                ((LogImportJob)event.getJob()).stop();
            }
            ((LogImportJob)event.getJob()).setFinished(true);
            ((LogImportJob)event.getJob()).getTRCAgent().getAgentProxy().setActive(false);
            IJobChangeEvent fEvent = event;
            Display.getDefault().asyncExec(new Runnable(this, fEvent){
                private final /* synthetic */ IJobChangeEvent val$fEvent;
                private final /* synthetic */ LogImportJobListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$fEvent = val$fEvent;
                }

                public void run() {
                    if (LogImportJobListener.access$1200((LogImportJobListener)this.this$1).fViewer != null) {
                        LogImportJobListener.access$1200((LogImportJobListener)this.this$1).fViewer.getViewer().refresh((Object)((LogImportJob)this.val$fEvent.getJob()).getTRCAgent().getAgentProxy());
                    }
                }
            });
            if (((LogImportJob)event.getJob()).getTRCAgent() == ImportLogWizard.this.displayAgent) {
                ImportLogWizard.this.refreshView(((LogImportJob)event.getJob()).getTRCAgent().getAgentProxy());
            }
        }

        static /* synthetic */ ImportLogWizard access$1200(LogImportJobListener x0) {
            return x0.ImportLogWizard.this;
        }
    }

    abstract class LogImportJob
    extends Job {
        protected LogFileElement element = null;
        protected TRCAgent trcAgent = null;
        protected boolean hasFinished = false;
        protected int[] status = new int[2];
        protected IProgressMonitor mon = null;
        protected String statusString = null;
        protected IStatus jobStatus = null;

        LogImportJob(String name) {
            super(name);
        }

        abstract int[] getProgressStatus();

        IStatus getStatus() {
            return this.jobStatus;
        }

        public void setStatus(IStatus newStatus) {
            this.jobStatus = newStatus;
        }

        abstract void setFinished(boolean var1);

        abstract boolean hasFinished();

        abstract IStatus stop();

        abstract TRCAgent getTRCAgent();
    }

    class RemoteLogImportJob
    extends LogImportJob
    implements AgentListener {
        private Node node = null;
        private Process process = null;
        private Agent agent = null;
        private boolean monitoringFinished = false;
        private long startTime = 0L;
        private int timeout = 2000;
        private int importTimeOut = 25000;
        private List errorMessages = null;
        private ErrorAgentListener errorListener = null;
        private boolean isLogAgentActive = false;
        private boolean logAgentActiveEventReceived = false;
        private final int MAX_NR_OF_ERRORS_DISPLAYED = 100;

        RemoteLogImportJob(String name, LogFileElement element, Node node, Process process, Agent agent, TRCAgent trcAgent) {
            super(name);
            this.element = element;
            this.node = node;
            this.process = process;
            this.trcAgent = trcAgent;
        }

        Process getProcess() {
            return this.process;
        }

        TRCAgent getTRCAgent() {
            return this.trcAgent;
        }

        IProgressMonitor getMonitor() {
            return this.mon;
        }

        boolean hasFinished() {
            return this.hasFinished;
        }

        boolean isMonitoring() {
            return !this.monitoringFinished;
        }

        void setMonitoringFinished(boolean newValue) {
            this.monitoringFinished = newValue;
        }

        void setFinished(boolean newValue) {
            this.hasFinished = newValue;
        }

        int[] getProgressStatus() {
            this.parseStatusString();
            return this.status;
        }

        String getTaskName() {
            return ImportLogWizard.this.getAgentName(this.element);
        }

        void setErrorListener(ErrorAgentListener listener) {
            this.errorListener = listener;
        }

        List getErrorMessages() {
            return this.errorMessages;
        }

        boolean isLogAgentActive() {
            return this.isLogAgentActive;
        }

        void setLogAgentActive(boolean newValue) {
            this.isLogAgentActive = newValue;
            if (newValue) {
                this.logAgentActiveEventReceived = true;
            }
        }

        IStatus stop() {
            try {
                if (this.process != null && this.process.isActive()) {
                    Node node = this.process.getNode();
                    node.killProcess(this.process);
                }
            }
            catch (NotConnectedException exc1) {
                exc1.printStackTrace();
            }
            catch (InactiveProcessException exc2) {
                exc2.printStackTrace();
            }
            ProfileEvent pEvent = UIPlugin.getDefault().getProfileEvent();
            pEvent.setSource((Object)this.process);
            pEvent.setType(16);
            ProfileEvent fpEvent = pEvent;
            Display.getDefault().asyncExec(new Runnable(this, fpEvent){
                private final /* synthetic */ ProfileEvent val$fpEvent;
                private final /* synthetic */ RemoteLogImportJob this$1;
                {
                    this.this$1 = this$1;
                    this.val$fpEvent = val$fpEvent;
                }

                public void run() {
                    UIPlugin.getDefault().notifyProfileEventListener(this.val$fpEvent);
                }
            });
            return new Status(0, LogUIPlugin.getPluginId(), 0, "", null);
        }

        private void parseStatusString() {
            if (this.statusString == null) {
                return;
            }
            if (this.statusString.startsWith("total=") && this.statusString.indexOf("processed") > 0) {
                int startProcessed;
                int endProcessed;
                if (this.status[0] == 0) {
                    int stopTotal = this.statusString.indexOf(" ");
                    this.status[0] = new Integer(this.statusString.substring(6, stopTotal));
                }
                if ((endProcessed = this.statusString.indexOf(" ", startProcessed = this.statusString.indexOf("processed"))) < 0) {
                    endProcessed = this.statusString.length();
                }
                this.status[1] = new Integer(this.statusString.substring(startProcessed + 10, endProcessed));
            } else if (this.statusString.startsWith("glalog=")) {
                String errString;
                if (this.errorMessages == null) {
                    this.errorMessages = new ArrayList();
                }
                if (!this.errorMessages.contains(errString = this.statusString.substring(7))) {
                    this.errorMessages.add(errString);
                }
            }
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.mon = monitor;
            IStatus status = this.runOnRemoteHost(monitor);
            String tempAdapterPath = this.element.getTempAdapterPath();
            if (tempAdapterPath != null && tempAdapterPath.length() > 0) {
                GLAFilterHelper.deleteTempAdapter(this.node, tempAdapterPath);
            }
            return status;
        }

        protected IStatus runOnRemoteHost(IProgressMonitor monitor) {
            try {
                this.process.launch();
            }
            catch (NoSuchApplicationException n) {
                String parserClass = this.element.getParser().getId().trim();
                if (!parserClass.equals("com.ibm.etools.logging.parsers.WASActivityLogParser")) {
                    ImportLogWizard.this.errorMessage = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_RAC_ERROR_");
                    ImportLogWizard.this.reasonAction = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_RAC_REASON_OLD_RAC");
                    MultiStatus status = new MultiStatus(LogUIPlugin.getPluginId(), 0, ImportLogWizard.this.errorMessage, (Throwable)n);
                    status.add((IStatus)new Status(4, LogUIPlugin.getPluginId(), 0, ImportLogWizard.this.reasonAction, (Throwable)n));
                    return status;
                }
                Hashtable userInput = ImportLogWizard.this.getUserInput(this.element, true);
                String was_home = (String)userInput.get("was_home");
                String activityPath = (String)userInput.get("file_path");
                this.process = ProcessFactory.createProcess((Node)this.node, (String)"ActivityLogParser", (String)"com.ibm.etools.logging.was.WASActivityLogParser".concat(" \"").concat(activityPath).concat("\" \"").concat(was_home).concat("\""));
                this.process.addProcessListener((ProcessListener)new ProcessListenerImpl(this.trcAgent.getAgentProxy().getProcessProxy(), this.trcAgent.getAgentProxy()));
                Agent preV5ProcessAgent = AgentFactory.createAgent((Process)this.process, (String)"WAS Activity Log Agent", (String)"Logging");
                preV5ProcessAgent.setAutoAttach(true);
                preV5ProcessAgent.addAgentListener((AgentListener)new LogAgentListener(this, this.trcAgent.getAgentProxy(), this.trcAgent.getAgentProxy().getProcessProxy()));
                Agent preV5ErrorAgent = AgentFactory.createAgent((Process)this.process, (String)"WAS Activity Log Error Agent", (String)"Logging");
                preV5ErrorAgent.setAutoAttach(true);
                ErrorAgentListener errorAgentListener = new ErrorAgentListener();
                preV5ErrorAgent.addAgentListener((AgentListener)errorAgentListener);
                this.setErrorListener(errorAgentListener);
                this.agent = preV5ErrorAgent;
                try {
                    this.process.launch();
                }
                catch (Exception e) {
                    ImportLogWizard.this.errorMessage = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_RAC_ERROR_");
                    ImportLogWizard.this.reasonAction = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_RAC_REASON_UNKNOWN");
                    LogUIPlugin.log(e);
                    MultiStatus status = new MultiStatus(LogUIPlugin.getPluginId(), 0, ImportLogWizard.this.errorMessage, (Throwable)e);
                    status.add((IStatus)new Status(4, LogUIPlugin.getPluginId(), 0, ImportLogWizard.this.reasonAction, (Throwable)e));
                    return status;
                }
            }
            catch (Exception e) {
                ImportLogWizard.this.errorMessage = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_RAC_ERROR_");
                ImportLogWizard.this.reasonAction = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_RAC_REASON_UNKNOWN");
                LogUIPlugin.log(e);
                MultiStatus status = new MultiStatus(LogUIPlugin.getPluginId(), 0, ImportLogWizard.this.errorMessage, (Throwable)e);
                status.add((IStatus)new Status(4, LogUIPlugin.getPluginId(), 0, ImportLogWizard.this.reasonAction, (Throwable)e));
                return status;
            }
            return this.monitorProgress(monitor);
        }

        private IStatus monitorProgress(IProgressMonitor monitor) {
            boolean taskBegan = false;
            int workedUnits = 0;
            while (this.isActive()) {
                try {
                    this.status = this.getProgressStatus();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!taskBegan && this.status[0] > 0) {
                    monitor.beginTask(this.getTaskName(), this.status[0]);
                    taskBegan = true;
                }
                if (this.status[0] != 0 && this.status[1] != 0 && this.status[0] <= this.status[1]) {
                    this.setFinished(true);
                    monitor.done();
                }
                if (monitor.isCanceled()) {
                    this.stop();
                    this.setFinished(true);
                    this.setStatus((IStatus)new Status(8, LogUIPlugin.getPluginId(), 0, "", null));
                    monitor.done();
                }
                if (this.status[1] > 0) {
                    monitor.worked(this.status[1] - workedUnits);
                    int percent = this.status[1] * 100 / this.status[0];
                    monitor.subTask(this.getTaskName() + " " + percent + "%");
                    workedUnits = this.status[1];
                } else {
                    monitor.subTask(this.getTaskName());
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.hasErrors()) {
                this.generateErrorMessage();
            }
            if (this.jobStatus == null) {
                this.jobStatus = new Status(0, LogUIPlugin.getPluginId(), 0, "", null);
            }
            monitor.done();
            return this.jobStatus;
        }

        private boolean hasErrors() {
            return this.errorListener != null && this.errorListener.getErrorMessage() != null || this.errorMessages != null && !this.errorMessages.isEmpty();
        }

        private boolean isActive() {
            if (!this.monitoringFinished) {
                if (!this.isLogAgentActive && !this.logAgentActiveEventReceived) {
                    if (!this.timeOut(this.importTimeOut)) {
                        return true;
                    }
                    String errMsg = LogUIPlugin.getResourceString("AgentControllerInvalidConfigError");
                    Status status = new Status(4, LogUIPlugin.getPluginId(), 0, errMsg, null);
                    this.setStatus((IStatus)status);
                    return false;
                }
                if (!this.hasFinished || this.errorListener.isActive()) {
                    return true;
                }
                return !this.timeOut(this.timeout);
            }
            if (!this.hasFinished || this.errorListener.isActive()) {
                return true;
            }
            return !this.timeOut(this.timeout);
        }

        private boolean timeOut(int delta) {
            long currentTime;
            if (this.startTime == 0L) {
                this.startTime = System.currentTimeMillis();
            }
            return (currentTime = System.currentTimeMillis()) - this.startTime > (long)delta;
        }

        void resetTimeOut() {
            this.startTime = 0L;
        }

        public void agentActive(Agent agent) {
            try {
                DataProcessor dataProcessor = new DataProcessor(this){
                    private final /* synthetic */ RemoteLogImportJob this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void incommingData(byte[] buffer, int length, InetAddress peer) {
                        this.this$1.statusString = new String(buffer, 0, length);
                        RemoteLogImportJob.access$1100(this.this$1);
                    }

                    public void incommingData(char[] buffer, int length, InetAddress peer) {
                    }

                    public void invalidDataType(byte[] data, int length, InetAddress peer) {
                    }

                    public void waitingForData() {
                    }
                };
                agent.startMonitoring(dataProcessor);
            }
            catch (Exception e) {}
        }

        public void agentInactive(Agent agent) {
            this.setFinished(true);
            this.setMonitoringFinished(true);
        }

        private void generateErrorMessage() {
            if (this.errorMessages != null && this.errorMessages.size() > 0) {
                String mainErrMsg = (String)this.errorMessages.get(0);
                MultiStatus status = null;
                if (this.errorListener != null && this.errorListener.getErrorMessage() != null && this.errorListener.getErrorMessage().trim().length() > 0) {
                    mainErrMsg = this.errorListener.getErrorMessage();
                    StringTokenizer stringTokenizer = new StringTokenizer(mainErrMsg, "\r\n");
                    while (stringTokenizer.hasMoreTokens()) {
                        String token = stringTokenizer.nextToken();
                        if (token.length() <= 0) continue;
                        if (status == null) {
                            status = new MultiStatus(LogUIPlugin.getPluginId(), 0, token, null);
                            continue;
                        }
                        status.add((IStatus)new Status(4, LogUIPlugin.getPluginId(), 0, token, null));
                    }
                    if (status == null) {
                        status = new MultiStatus(LogUIPlugin.getPluginId(), 0, mainErrMsg, null);
                    }
                }
                StringBuffer errMsg = new StringBuffer();
                String NL = System.getProperties().getProperty("line.separator");
                int min = Math.min(100, this.errorMessages.size());
                int i = 0;
                while (i < min) {
                    errMsg.append(this.errorMessages.get(i));
                    status.add((IStatus)new Status(4, LogUIPlugin.getPluginId(), 0, this.errorMessages.get(i).toString(), null));
                    ++i;
                }
                this.setStatus((IStatus)status);
            } else if (this.errorListener != null && this.errorListener.getErrorMessage() != null && this.errorListener.getErrorMessage().trim().length() > 0) {
                Status status = null;
                StringTokenizer stringTokenizer = new StringTokenizer(this.errorListener.getErrorMessage(), "\r\n");
                if (stringTokenizer.countTokens() > 1) {
                    while (stringTokenizer.hasMoreTokens()) {
                        String token = stringTokenizer.nextToken();
                        if (token.length() <= 0) continue;
                        if (status == null) {
                            status = new MultiStatus(LogUIPlugin.getPluginId(), 0, token, null);
                            continue;
                        }
                        ((MultiStatus)status).add((IStatus)new Status(4, LogUIPlugin.getPluginId(), 0, token, null));
                    }
                }
                if (status == null) {
                    status = new Status(4, LogUIPlugin.getPluginId(), 0, this.errorListener.getErrorMessage(), null);
                }
                this.setStatus((IStatus)status);
            }
        }

        public void error(Agent agent, String errorId, String message) {
        }

        public void handleCommand(Agent agent, CommandElement command) {
        }

        static /* synthetic */ void access$1100(RemoteLogImportJob x0) {
            x0.parseStatusString();
        }
    }

    class LocalLogImportJob
    extends LogImportJob {
        private Parser parser = null;
        private XMLLoader xmlLoader = null;
        private LocalLogParserLoader parserLoader;

        LocalLogImportJob(String name, LogFileElement element, Parser parser, XMLLoader xmlLoader, LocalLogParserLoader parserLoader, TRCAgent trcAgent) {
            super(name);
            this.element = element;
            this.parser = parser;
            this.xmlLoader = xmlLoader;
            this.parserLoader = parserLoader;
            this.trcAgent = trcAgent;
        }

        Parser getParser() {
            return this.parser;
        }

        TRCAgent getTRCAgent() {
            return this.trcAgent;
        }

        IProgressMonitor getMonitor() {
            return this.mon;
        }

        boolean hasFinished() {
            return this.hasFinished;
        }

        void setFinished(boolean newValue) {
            this.hasFinished = newValue;
        }

        int[] getProgressStatus() {
            this.parseStatusString();
            return this.status;
        }

        String getTaskName() {
            return ImportLogWizard.this.getAgentName(this.element);
        }

        IStatus stop() {
            try {
                this.parser.stop();
            }
            catch (Exception e) {
                return new Status(4, LogUIPlugin.getPluginId(), 0, LogUIPlugin.getResourceString("IMPORT_LOG_FILE_STOP_PARSE_MSG"), (Throwable)e);
            }
            return new Status(0, LogUIPlugin.getPluginId(), 0, "", null);
        }

        private void parseStatusString() {
            int startProcessed;
            int endProcessed;
            this.statusString = this.parser.getStatus();
            if (this.statusString == null) {
                return;
            }
            if (!this.statusString.startsWith("total=") || this.statusString.indexOf("processed") < 0) {
                return;
            }
            if (this.status[0] == 0) {
                int stopTotal = this.statusString.indexOf(" ");
                this.status[0] = new Integer(this.statusString.substring(6, stopTotal));
            }
            if ((endProcessed = this.statusString.indexOf(" ", startProcessed = this.statusString.indexOf("processed"))) < 0) {
                endProcessed = this.statusString.length();
            }
            this.status[1] = new Integer(this.statusString.substring(startProcessed + 10, endProcessed));
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.mon = monitor;
            if (ImportLogWizard.this.monitorThread != null) {
                ImportLogWizard.this.monitorThread.register(this);
            }
            return this.runOnLocalHost(monitor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        protected IStatus runOnLocalHost(IProgressMonitor monitor) {
            block11: {
                LocalGLALogger glaLogger = new LocalGLALogger();
                this.parserLoader.setParserLogger(glaLogger);
                this.xmlLoader.loadEvent("<CommonBaseEvents>".getBytes(), "<CommonBaseEvents>".getBytes().length);
                this.parserLoader.startParsing();
                this.xmlLoader.loadEvent("</CommonBaseEvents>".getBytes(), "</CommonBaseEvents>".getBytes().length);
                Object var6_3 = null;
                try {
                    this.xmlLoader.cleanUp();
                }
                catch (Exception e2) {}
                break block11;
                {
                    catch (Exception e) {
                        e.printStackTrace();
                        ImportLogWizard.this.errorMessage = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_RAC_ERROR_");
                        ImportLogWizard.this.reasonAction = e.getLocalizedMessage();
                        MultiStatus status = new MultiStatus(LogUIPlugin.getPluginId(), 0, ImportLogWizard.this.errorMessage, (Throwable)e);
                        if (ImportLogWizard.this.reasonAction != null) {
                            status.add((IStatus)new Status(4, LogUIPlugin.getPluginId(), 0, ImportLogWizard.this.reasonAction, (Throwable)e));
                        }
                        if (glaLogger.getLogDetails() != null) {
                            ImportLogWizard.this.detailMsg = glaLogger.getLogDetails().trim();
                            status.add((IStatus)new Status(4, LogUIPlugin.getPluginId(), 0, ImportLogWizard.this.detailMsg, (Throwable)e));
                        }
                        this.setStatus((IStatus)status);
                        this.stop();
                        Object var6_4 = null;
                        try {
                            this.xmlLoader.cleanUp();
                        }
                        catch (Exception e2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    try {
                        this.xmlLoader.cleanUp();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            if (this.jobStatus == null) {
                MultiStatus status = new MultiStatus(LogUIPlugin.getPluginId(), 0, "", null);
                status.add((IStatus)new Status(0, LogUIPlugin.getPluginId(), 0, "", null));
                this.setStatus((IStatus)status);
            }
            return this.jobStatus;
        }
    }

    class ErrorAgentListener
    implements AgentListener {
        private String errorAgentMessage = null;
        private boolean isActive = false;

        public void agentActive(Agent agent) {
            this.isActive = true;
            try {
                agent.startMonitoring(new DataProcessor(this){
                    private final /* synthetic */ ErrorAgentListener this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void incommingData(byte[] buffer, int length, InetAddress peer) {
                        ErrorAgentListener.access$602(this.this$1, new String(buffer, 0, length));
                    }

                    public void incommingData(char[] buffer, int length, InetAddress peer) {
                    }

                    public void invalidDataType(byte[] data, int length, InetAddress peer) {
                    }

                    public void waitingForData() {
                    }
                });
            }
            catch (Exception e) {
                this.errorAgentMessage = e.toString();
                Display.getDefault().asyncExec(new Runnable(this){
                    private final /* synthetic */ ErrorAgentListener this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                    }
                });
            }
        }

        public void agentInactive(Agent agent) {
            this.isActive = false;
        }

        public void error(Agent agent, String errorId, String message) {
            this.errorAgentMessage = errorId.concat(": ").concat(message);
        }

        public void handleCommand(Agent agent, CommandElement command) {
        }

        String getErrorMessage() {
            return this.errorAgentMessage;
        }

        boolean isActive() {
            return this.isActive;
        }

        static /* synthetic */ String access$602(ErrorAgentListener x0, String x1) {
            x0.errorAgentMessage = x1;
            return x0.errorAgentMessage;
        }
    }

    class LogAgentListener
    implements AgentListener {
        private RemoteLogImportJob job;
        private TRCAgentProxy aproxy;
        private TRCProcessProxy trcProcess;
        private boolean isActive = false;

        public LogAgentListener(RemoteLogImportJob job, TRCAgentProxy aproxy, TRCProcessProxy trcProcess) {
            this.job = job;
            this.aproxy = aproxy;
            this.trcProcess = trcProcess;
        }

        public void agentActive(Agent agent) {
            this.aproxy.setActive(true);
            this.job.setLogAgentActive(true);
            this.job.resetTimeOut();
            this.aproxy.setAttached(true);
            this.aproxy.setMonitored(true);
            LoadersUtils.registerAgentInstance((TRCAgentProxy)this.aproxy, (Object)agent);
            Display.getDefault().asyncExec(new Runnable(this){
                private final /* synthetic */ LogAgentListener this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                    event.setSource((Object)LogAgentListener.access$400(this.this$1));
                    event.setType(1);
                    UIPlugin.getDefault().notifyProfileEventListener(event);
                }
            });
            try {
                XMLTraceDataProcessor dataProcessor = new XMLTraceDataProcessor(this, this.aproxy){
                    private final /* synthetic */ LogAgentListener this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void dataServerExited() {
                        super.dataServerExited();
                        LoadersUtils.deregisterAgentInstance((TRCAgentProxy)LogAgentListener.access$400(this.this$1));
                        Display.getDefault().asyncExec(new Runnable(this){
                            private final /* synthetic */ 7 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public void run() {
                                ProfileEvent event = UIPlugin.getDefault().getRefreshViewEvent((Object)LogAgentListener.access$400(7.access$500(this.this$2)));
                                UIPlugin.getDefault().notifyProfileEventListener(event);
                            }
                        });
                    }

                    static /* synthetic */ LogAgentListener access$500(7 x0) {
                        return x0.this$1;
                    }
                };
                agent.startMonitoring((DataProcessor)dataProcessor);
            }
            catch (Exception e) {
                LogUIPlugin.log(e);
                ImportLogWizard.this.errorMessage = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_RAC_ERROR_");
                ImportLogWizard.this.reasonAction = e.getLocalizedMessage();
                MultiStatus status = new MultiStatus(LogUIPlugin.getPluginId(), 0, ImportLogWizard.this.errorMessage, (Throwable)e);
                if (ImportLogWizard.this.reasonAction != null) {
                    status.add((IStatus)new Status(4, LogUIPlugin.getPluginId(), 0, ImportLogWizard.this.reasonAction, (Throwable)e));
                } else {
                    status.add((IStatus)new Status(4, LogUIPlugin.getPluginId(), 0, e.getStackTrace().toString(), (Throwable)e));
                }
                this.job.setStatus((IStatus)status);
                this.job.setFinished(true);
            }
        }

        public void agentInactive(Agent agent) {
            this.job.setLogAgentActive(false);
            this.aproxy.setActive(false);
            this.aproxy.setAttached(false);
            this.aproxy.setMonitored(false);
            this.trcProcess.setActive(false);
            this.job.setFinished(true);
            Display.getDefault().asyncExec(new Runnable(this){
                private final /* synthetic */ LogAgentListener this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
                    event.setSource((Object)LogAgentListener.access$400(this.this$1));
                    event.setType(16);
                    UIPlugin.getDefault().notifyProfileEventListener(event);
                }
            });
        }

        public void error(Agent agent, String errorId, String message) {
            ImportLogWizard.this.reasonAction = errorId.concat(": ").concat(message);
            ImportLogWizard.this.errorMessage = LogUIPlugin.getResourceString("IMPORT_LOG_FILE_RAC_ERROR_");
            MultiStatus status = new MultiStatus(LogUIPlugin.getPluginId(), 0, ImportLogWizard.this.errorMessage, null);
            if (ImportLogWizard.this.reasonAction != null) {
                status.add((IStatus)new Status(4, LogUIPlugin.getPluginId(), 0, ImportLogWizard.this.reasonAction, null));
            }
            this.job.setStatus((IStatus)status);
            this.job.setFinished(true);
        }

        public void handleCommand(Agent agent, CommandElement command) {
        }

        static /* synthetic */ TRCAgentProxy access$400(LogAgentListener x0) {
            return x0.aproxy;
        }
    }

    class ProcessListenerImpl
    implements ProcessListener {
        TRCAgentProxy trcAgent;
        TRCProcessProxy trcProcess;

        public ProcessListenerImpl(TRCProcessProxy process, TRCAgentProxy agent) {
            this.trcProcess = process;
            this.trcAgent = agent;
        }

        public void processExited(Process process) {
            this.trcAgent.setActive(false);
            this.trcAgent.setAttached(false);
            this.trcAgent.setMonitored(false);
            Display.getDefault().asyncExec(new Runnable(this){
                private final /* synthetic */ ProcessListenerImpl this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    if (ImportLogWizard.access$000(ProcessListenerImpl.access$300(this.this$1))) {
                        ProcessListenerImpl.access$300((ProcessListenerImpl)this.this$1).fViewer.getViewer().refresh((Object)this.this$1.trcAgent);
                    }
                }
            });
        }

        public void processLaunched(Process process) {
            try {
                if (this.trcProcess != null) {
                    this.trcProcess.setPid(Integer.parseInt(process.getProcessId()));
                    this.trcProcess.setRuntimeId(process.getUUID());
                    this.trcProcess.setActive(true);
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }

        static /* synthetic */ ImportLogWizard access$300(ProcessListenerImpl x0) {
            return x0.ImportLogWizard.this;
        }
    }
}

