/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.log.ui.internal.wizards;

import java.util.StringTokenizer;
import org.eclipse.hyades.log.ui.internal.LogUIPlugin;
import org.eclipse.hyades.log.ui.internal.wizards.IImportWizardWidget;
import org.eclipse.hyades.log.ui.internal.wizards.ParserField;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ImportWizardComboBox
implements IImportWizardWidget {
    protected Combo comboBox;
    private ParserField _field = null;

    public ImportWizardComboBox(ParserField field) {
        this._field = field;
    }

    public String getValue() {
        return this.comboBox.getItem(this.comboBox.getSelectionIndex());
    }

    public void setValue(String newValue) {
        String[] items = this.comboBox.getItems();
        int j = 0;
        while (j < this.comboBox.getItemCount()) {
            if (this.comboBox.getItem(j).equalsIgnoreCase(newValue)) {
                this.comboBox.select(j);
                break;
            }
            ++j;
        }
    }

    public void createControl(Composite composite, String prefix) {
        Label label = new Label(composite, 64);
        GridData data = new GridData();
        data.widthHint = 400;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setText(this._field.getName());
        this.comboBox = new Combo(composite, 2056);
        this.comboBox.setToolTipText(this._field.getTooltip());
        this.comboBox.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.comboBox.setLayout((Layout)new GridLayout());
        IPreferenceStore store = LogUIPlugin.getDefault().getPreferenceStore();
        String previousValue = store.getString(prefix + this._field.getId());
        StringTokenizer st = new StringTokenizer(this._field.getDefaultValue(), ",");
        int selIndex = 0;
        int index = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            this.comboBox.add(token);
            if (previousValue != null && previousValue.trim().equals(token)) {
                selIndex = index;
            }
            ++index;
        }
        this.comboBox.select(selIndex);
    }

    public ParserField getField() {
        return this._field;
    }

    public Combo getComboBox() {
        return this.comboBox;
    }

    public void setComboBox(Combo comboBox) {
        this.comboBox = comboBox;
    }

    public boolean isValid() {
        return true;
    }
}

