/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.filters.internal.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleSearchQuery;

public class FilterQueries {
    private String _type;
    private String _name;
    private SimpleSearchQuery _standardQuery;
    private SimpleSearchQuery _advancedQuery;
    public static String STANDARD_TAB_EXT = "ST";
    public static String ADVANCED_TAB_EXT = "AD";
    public static String NAME_SEPARATOR = ":";

    public void type(String type) {
        this._type = type;
        this.setQueryNames();
    }

    public String type() {
        return this._type;
    }

    public void name(String name) {
        this._name = name;
        this.setQueryNames();
    }

    public String name() {
        return this._name;
    }

    public void standard(SimpleSearchQuery standardQuery) {
        this._standardQuery = standardQuery;
        this.setTypeAndName();
    }

    public void advanced(SimpleSearchQuery advancedQuery) {
        this._advancedQuery = advancedQuery;
        this.setTypeAndName();
    }

    private void setQueryNames() {
        if (this._type != null && this._name != null && this._standardQuery != null) {
            this._standardQuery.setName(this._type + NAME_SEPARATOR + this._name + NAME_SEPARATOR + STANDARD_TAB_EXT);
        }
        if (this._type != null && this._name != null && this._advancedQuery != null) {
            this._advancedQuery.setName(this._type + NAME_SEPARATOR + this._name + NAME_SEPARATOR + ADVANCED_TAB_EXT);
        }
    }

    private void setTypeAndName() {
        String name = null;
        String type = null;
        if (this._standardQuery != null) {
            name = this.getBaseName(this._standardQuery.getName());
            type = this.getTypeName(this._standardQuery.getName());
        } else if (this._advancedQuery != null) {
            name = this.getBaseName(this._advancedQuery.getName());
            type = this.getTypeName(this._advancedQuery.getName());
        }
        if (name != null) {
            this.name(name);
        }
        if (type != null) {
            this.type(type);
        }
        if (name == null || type == null) {
            this.setQueryNames();
        }
    }

    public SimpleSearchQuery standard() {
        return this._standardQuery;
    }

    public SimpleSearchQuery advanced() {
        return this._advancedQuery;
    }

    private String getTypeName(String queryName) {
        int idx;
        if (queryName != null && (idx = queryName.indexOf(NAME_SEPARATOR)) >= 0) {
            return queryName.substring(0, idx);
        }
        return null;
    }

    private String getBaseName(String queryName) {
        if (queryName != null) {
            int idx1 = queryName.indexOf(NAME_SEPARATOR);
            int idx2 = queryName.lastIndexOf(NAME_SEPARATOR);
            if (idx1 >= 0 && idx2 >= 0) {
                return queryName.substring(idx1 + 1, idx2);
            }
        }
        return null;
    }

    public FilterQueries copy() {
        FilterQueries result = new FilterQueries();
        result.standard((SimpleSearchQuery)EcoreUtil.copy((EObject)this.standard()));
        result.advanced((SimpleSearchQuery)EcoreUtil.copy((EObject)this.advanced()));
        return result;
    }
}

