/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.wizard.NewMonitorWizard;
import org.eclipse.hyades.trace.ui.internal.wizard.NewNodeWizard;
import org.eclipse.hyades.trace.ui.internal.wizard.OpenLogAgentWizard;
import org.eclipse.hyades.trace.ui.internal.wizard.OpenProcessWizard;
import org.eclipse.hyades.trace.ui.internal.wizard.OpenProfAgentWizard;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.SelectionProviderAction;

public class OpenWizardAction
extends SelectionProviderAction {
    private Class fWizardClass;
    private INavigator fViewer;

    public OpenWizardAction(INavigator viewer, Class wizardclass, String label) {
        super((ISelectionProvider)viewer.getViewer(), label);
        this.fWizardClass = wizardclass;
        this.fViewer = viewer;
    }

    public void run() {
        try {
            IWorkbench workbench = UIPlugin.getDefault().getWorkbench();
            Wizard wizard = (Wizard)this.fWizardClass.newInstance();
            WizardDialog dialog = new WizardDialog(this.fViewer.getViewSite().getShell(), (IWizard)wizard);
            IStructuredSelection selection = (IStructuredSelection)this.fViewer.getViewer().getSelection();
            if (wizard instanceof INewWizard) {
                ((INewWizard)wizard).init(workbench, selection);
            }
            if (wizard instanceof NewMonitorWizard) {
                ((NewMonitorWizard)wizard).setViewer((PDProjectExplorer)this.fViewer);
            } else if (wizard instanceof NewNodeWizard) {
                ((NewNodeWizard)wizard).setViewer(this.fViewer);
            } else if (wizard instanceof OpenProcessWizard) {
                ((OpenProcessWizard)wizard).setViewer((PDProjectExplorer)this.fViewer);
            } else if (wizard instanceof OpenLogAgentWizard) {
                ((OpenLogAgentWizard)wizard).setViewer(this.fViewer);
            } else if (wizard instanceof OpenProfAgentWizard) {
                ((OpenProfAgentWizard)wizard).setViewer((PDProjectExplorer)this.fViewer);
            }
            dialog.open();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
    }

    public void dispose() {
        super.dispose();
        this.fViewer = null;
        this.fWizardClass = null;
    }
}

