/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.IDeleteListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.actions.SaveAction;
import org.eclipse.hyades.trace.ui.internal.navigator.SimpleLayout;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class RefreshFromLocalAction
extends SelectionProviderAction
implements ISelectionChangedListener {
    private INavigator fViewer;

    public RefreshFromLocalAction(INavigator viewer) {
        super((ISelectionProvider)viewer.getViewer(), UIPlugin.getResourceString("UNLOAD_MEMORY"));
        this.setDescription(UIPlugin.getResourceString("RELOAD_LOCAL_FILE"));
        this.fViewer = viewer;
        WorkbenchHelp.setHelp((IAction)this, (String)(UIPlugin.getPluginId() + ".refl0000"));
        this.setToolTipText(UIPlugin.getResourceString("RELOAD_LOCAL_FILE_TOOLTIP"));
    }

    public void run() {
        List list = this.getProcessProxies(true);
        String preferenceKey = UIPlugin.getDefault().getPreferenceStore().getString("reload_no_question");
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell shell = window.getShell();
        boolean saveAndChange = false;
        if (UIPlugin.getDefault().getPreferenceStore().getBoolean("reload_no_question")) {
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)shell, (String)UIPlugin.getResourceString("RELOAD_INFORMATION_TITLE"), (String)UIPlugin.getResourceString("RELOAD_INFORMATION"), (String)UIPlugin.getResourceString("ATTACH_MESSAGE_CHECKBOX_MSG"), (boolean)false, (IPreferenceStore)UIPlugin.getDefault().getPreferenceStore(), (String)preferenceKey);
            boolean bl = saveAndChange = dialog.getReturnCode() == 0;
            if (dialog.getToggleState()) {
                UIPlugin.getDefault().getPreferenceStore().setValue("reload_no_question", Boolean.toString(!saveAndChange));
            }
            if (shell.getMinimized()) {
                shell.setMinimized(false);
            }
            if (!saveAndChange) {
                return;
            }
        }
        if (!list.isEmpty()) {
            final Object[] listArray = list.toArray();
            IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public Object[] getElements(Object inputElement) {
                    return listArray;
                }
            };
            ListSelectionDialog dlg = new ListSelectionDialog(this.fViewer.getViewSite().getShell(), (Object)listArray, contentProvider, new SimpleLayout(null).getLabelProvider(), UIPlugin.getResourceString("FREE_MEMORY_QUESTION"));
            dlg.setInitialSelections(listArray);
            dlg.setTitle(UIPlugin.getResourceString("UNLOAD_MEMORY"));
            int result = dlg.open();
            if (result == 1) {
                return;
            }
            if (!Arrays.asList(dlg.getResult()).isEmpty()) {
                try {
                    SaveAction saveLogs = new SaveAction(this.fViewer);
                    saveLogs.run(result);
                }
                catch (Exception e) {
                    HyadesUIPlugin.logError((Throwable)e);
                }
            } else {
                String title = UIPlugin.getResourceString("TRACE_MSG");
                String msg = UIPlugin.getResourceString("RELOAD_QUESTION");
                if (!MessageDialog.openQuestion((Shell)this.fViewer.getViewSite().getShell(), (String)title, (String)msg)) {
                    return;
                }
            }
        }
        ProfileEvent event = new ProfileEvent();
        event.setSource(ResourcesPlugin.getWorkspace().getRoot());
        this.handleResources();
        if (!(this.fViewer instanceof PDProjectExplorer)) {
            event.setType(4608);
            UIPlugin.getDefault().notifyProfileEventListener(event);
        }
        event.setType(5120);
        UIPlugin.getDefault().notifyProfileEventListener(event);
    }

    protected List getProcessProxies(boolean onlyModified) {
        ArrayList<TRCProcessProxy> list = new ArrayList<TRCProcessProxy>();
        Iterator iter = HierarchyResourceSetImpl.getInstance().getResources().iterator();
        while (iter.hasNext()) {
            TRCAgent agent;
            Resource element = (Resource)iter.next();
            if (!element.isLoaded() || onlyModified && !element.isModified() || element.getContents().size() <= 0 || !(element.getContents().get(0) instanceof TRCAgent) || (agent = (TRCAgent)element.getContents().get(0)).eIsProxy() || agent.getAgentProxy() == null || agent.getAgentProxy().getProcessProxy() == null || list.contains(agent.getAgentProxy().getProcessProxy())) continue;
            list.add(agent.getAgentProxy().getProcessProxy());
        }
        return list;
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.isEnabled());
    }

    public boolean isEnabled() {
        return !this.getProcessProxies(false).isEmpty();
    }

    public void dispose() {
        super.dispose();
        this.fViewer = null;
    }

    protected void handleResources() {
        PDContentProvider.resetMonitors();
        Object[] resources = HierarchyResourceSetImpl.getInstance().getResources().toArray();
        int idx = 0;
        while (idx < resources.length) {
            Resource element = (Resource)resources[idx];
            if (element != null && element.isLoaded()) {
                Object[] elements = element.getContents().toArray();
                int i = 0;
                while (i < elements.length) {
                    Object obj = elements[i];
                    ArrayList deletelist = UIPlugin.getDefault().getDeleteListeners();
                    int j = 0;
                    while (j < deletelist.size()) {
                        ((IDeleteListener)deletelist.get(j)).deregister(obj);
                        ++j;
                    }
                    element.unload();
                    ++i;
                }
            }
            ++idx;
        }
    }
}

