/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.core;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileDestinationTab;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileLimitsTab;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileOverviewTab;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileTab;
import org.eclipse.hyades.trace.ui.internal.util.AbstractChangeable;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class TraceProfileUI
extends AbstractChangeable {
    private ProfileTab parentTab;
    private ProfileLimitsTab _plt;
    private ProfileDestinationTab _pdt;
    private ProfileOverviewTab _pot;
    private Listener _listener = new Listener(){

        public void handleEvent(Event event) {
            TraceProfileUI.this.parentTab.update();
        }
    };

    public TraceProfileUI(ProfileTab par, boolean attach) {
        this.parentTab = par;
        this._pot = new ProfileOverviewTab(this.parentTab);
        this._plt = new ProfileLimitsTab(this.parentTab, attach);
        this._pdt = new ProfileDestinationTab(this.parentTab);
    }

    public Composite createControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        TabFolder folder = new TabFolder(parent, 128);
        TabItem item1 = new TabItem(folder, 128);
        item1.setText(UIPlugin.getResourceString("TAB_NAME_OVERVIEW"));
        item1.setControl((Control)this._pot.createControl((Composite)folder));
        this._pot.addListener(this._listener);
        TabItem item2 = new TabItem(folder, 128);
        item2.setText(UIPlugin.getResourceString("TAB_NAME_LIMITS"));
        item2.setImage(PDPluginImages.getImage("options_obj.gif"));
        item2.setControl((Control)this._plt.createControl((Composite)folder));
        this._plt.addListener(this._listener);
        TabItem item3 = new TabItem(folder, 128);
        item3.setText(UIPlugin.getResourceString("TAB_NAME_DESTINATION"));
        item3.setImage(PDPluginImages.getImage("folder.gif"));
        item3.setControl((Control)this._pdt.createControl((Composite)folder));
        this._pdt.addListener(this._listener);
        return folder;
    }

    public void initializeFrom(ILaunchConfiguration conf) {
        this._pot.initializeFrom(conf);
        this._plt.initializeFrom(conf);
        this._pdt.initializeFrom(conf);
    }

    public void activated(ILaunchConfigurationWorkingCopy conf) {
        this._pot.initializeFrom((ILaunchConfiguration)conf);
        this._plt.initializeFrom((ILaunchConfiguration)conf);
        this._pdt.activated(conf);
    }

    public void performApply(ILaunchConfigurationWorkingCopy wc) {
        this._pot.performApply(wc);
        this._plt.performApply(wc);
        this._pdt.performApply(wc);
    }

    public boolean isValid(ILaunchConfiguration conf) {
        return this._plt.isValid(conf) && this._pdt.isValid(conf) && this._pot.isValid(conf);
    }
}

