/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.filters;

import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.hierarchy.extensions.BinaryExpression;
import org.eclipse.hyades.models.hierarchy.extensions.ExtensionsFactory;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalExpression;
import org.eclipse.hyades.models.hierarchy.extensions.LogicalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.RelationalOperators;
import org.eclipse.hyades.models.hierarchy.extensions.SimpleOperand;
import org.eclipse.hyades.models.hierarchy.extensions.WhereExpression;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.filters.IFilterAttribute;
import org.eclipse.hyades.trace.ui.internal.filters.ModelUtils;
import org.eclipse.hyades.trace.ui.internal.util.TString;

public class BasicFeatureFilterAttribute
implements IFilterAttribute {
    public static String OR_SEPARATOR = "|";
    private String _id;
    private String _displayText;
    private RelationalOperators[] _operators;
    private EStructuralFeature _feature;
    private boolean _useNotLikeOperator;

    public BasicFeatureFilterAttribute(String id, String displayText, EStructuralFeature feature, RelationalOperators[] operators, boolean useNotLikeOperator) {
        this._id = id;
        this._displayText = displayText;
        this._operators = operators;
        this._feature = feature;
        this._useNotLikeOperator = useNotLikeOperator;
    }

    public EStructuralFeature feature() {
        return this._feature;
    }

    public String id() {
        return this._id;
    }

    public String displayText() {
        return this._displayText;
    }

    public String validate(String operator, String value) {
        String[] values = this.getValues(value);
        int i = 0;
        while (i < values.length) {
            if (this._feature instanceof EAttribute) {
                try {
                    Object valueFromString = EcoreUtil.createFromString((EDataType)((EAttribute)this._feature).getEAttributeType(), (String)values[i]);
                }
                catch (Exception e) {
                    String errorMsg = TString.change(UIPlugin.getResourceString("STR_ST_FILTER_INVALID_TYPE_FOR_ATTRIBUTE"), "%1", values[i]);
                    errorMsg = TString.change(errorMsg, "%2", this.displayText());
                    return errorMsg;
                }
            }
            ++i;
        }
        return null;
    }

    public String[] operators() {
        String[] operators = new String[this._operators.length + (this._useNotLikeOperator ? 1 : 0)];
        int j = 0;
        int i = 0;
        while (i < this._operators.length) {
            operators[j++] = BasicFeatureFilterAttribute.getOperatorString(this._operators[i]);
            if (RelationalOperators.get((int)6).equals(this._operators[i]) && this._useNotLikeOperator) {
                operators[j++] = UIPlugin.getResourceString("STR_FILTER_OPERATOR_NOT_LIKE");
            }
            ++i;
        }
        if (this._useNotLikeOperator && j < operators.length) {
            operators[j] = UIPlugin.getResourceString("STR_FILTER_OPERATOR_NOT_LIKE");
        }
        return operators;
    }

    protected String getValueFromDisplayValue(String value) {
        return value;
    }

    private WhereExpression getSubWhereExpression(EStructuralFeature feature, RelationalOperators operator, String value, boolean notExpression) {
        if (notExpression) {
            LogicalExpression logicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
            logicalExpression.setOperator(LogicalOperators.NOT_LITERAL);
            logicalExpression.getArguments().add((Object)ModelUtils.createBinaryExpression(feature, operator, this.getValueFromDisplayValue(value), false));
            return logicalExpression;
        }
        return ModelUtils.createBinaryExpression(feature, operator, this.getValueFromDisplayValue(value), false);
    }

    public WhereExpression getWhereExpression(String operator, String value) {
        String[] values = this.getValues(value);
        if (values.length == 1) {
            RelationalOperators relationOperator = BasicFeatureFilterAttribute.getOperator(operator);
            if (relationOperator != null) {
                return this.getSubWhereExpression(this._feature, relationOperator, values[0], false);
            }
            if (UIPlugin.getResourceString("STR_FILTER_OPERATOR_NOT_LIKE").equals(operator)) {
                return this.getSubWhereExpression(this._feature, RelationalOperators.get((int)6), values[0], true);
            }
            return null;
        }
        LogicalExpression logicalExpression = ExtensionsFactory.eINSTANCE.createLogicalExpression();
        logicalExpression.setOperator(LogicalOperators.OR_LITERAL);
        int j = 0;
        while (j < values.length) {
            RelationalOperators relationOperator = BasicFeatureFilterAttribute.getOperator(operator);
            if (relationOperator != null) {
                logicalExpression.getArguments().add((Object)this.getSubWhereExpression(this._feature, relationOperator, values[j], false));
            } else if (UIPlugin.getResourceString("STR_FILTER_OPERATOR_NOT_LIKE").equals(operator)) {
                logicalExpression.getArguments().add((Object)this.getSubWhereExpression(this._feature, RelationalOperators.get((int)6), values[j], true));
            }
            ++j;
        }
        if (logicalExpression.getArguments().size() > 0) {
            return logicalExpression;
        }
        return null;
    }

    protected String getDisplayValue(String value) {
        return value;
    }

    public String getValue(WhereExpression whereExpression) {
        if (whereExpression instanceof BinaryExpression) {
            BinaryExpression be = (BinaryExpression)whereExpression;
            return this.getDisplayValue(((SimpleOperand)be.getRightOperands().get(0)).getRawValue());
        }
        if (whereExpression instanceof LogicalExpression) {
            String values = "";
            EList arguments = ((LogicalExpression)whereExpression).getArguments();
            int i = 0;
            while (i < arguments.size() - 1) {
                values = values + this.getValue((WhereExpression)arguments.get(i)) + " " + OR_SEPARATOR + " ";
                ++i;
            }
            values = values + this.getValue((WhereExpression)arguments.get(arguments.size() - 1));
            return values;
        }
        return null;
    }

    public String getOperator(WhereExpression whereExpression) {
        if (whereExpression instanceof BinaryExpression) {
            BinaryExpression be = (BinaryExpression)whereExpression;
            return BasicFeatureFilterAttribute.getOperatorString(be.getOperator());
        }
        if (whereExpression instanceof LogicalExpression) {
            if (LogicalOperators.NOT_LITERAL.equals(((LogicalExpression)whereExpression).getOperator())) {
                return UIPlugin.getResourceString("STR_FILTER_OPERATOR_NOT_LIKE");
            }
            EList arguments = ((LogicalExpression)whereExpression).getArguments();
            if (arguments.size() > 0) {
                return this.getOperator((WhereExpression)arguments.get(0));
            }
            return null;
        }
        return null;
    }

    public String defaultValue() {
        return "";
    }

    protected String[] getValues(String valuesStr) {
        Vector<String> valuesV = new Vector<String>();
        int idx = valuesStr.indexOf(OR_SEPARATOR);
        while (idx >= 0) {
            valuesV.add(valuesStr.substring(0, idx).trim());
            valuesStr = valuesStr.substring(idx + 1);
            idx = valuesStr.indexOf(OR_SEPARATOR);
        }
        valuesV.add(valuesStr.trim());
        String[] values = new String[valuesV.size()];
        valuesV.toArray(values);
        return values;
    }

    public static RelationalOperators getOperator(String operator) {
        if (UIPlugin.getResourceString("STR_FILTER_OPERATOR_LIKE").equals(operator)) {
            return RelationalOperators.get((int)6);
        }
        if (UIPlugin.getResourceString("STR_FILTER_OPERATOR_EQ").equals(operator)) {
            return RelationalOperators.get((int)2);
        }
        if (UIPlugin.getResourceString("STR_FILTER_OPERATOR_NEQ").equals(operator)) {
            return RelationalOperators.get((int)5);
        }
        if (UIPlugin.getResourceString("STR_FILTER_OPERATOR_GT").equals(operator)) {
            return RelationalOperators.get((int)1);
        }
        if (UIPlugin.getResourceString("STR_FILTER_OPERATOR_LT").equals(operator)) {
            return RelationalOperators.get((int)0);
        }
        if (UIPlugin.getResourceString("STR_FILTER_OPERATOR_GE").equals(operator)) {
            return RelationalOperators.get((int)4);
        }
        if (UIPlugin.getResourceString("STR_FILTER_OPERATOR_LE").equals(operator)) {
            return RelationalOperators.get((int)3);
        }
        return null;
    }

    public static String getOperatorString(RelationalOperators operator) {
        if (RelationalOperators.get((int)6).equals(operator)) {
            return UIPlugin.getResourceString("STR_FILTER_OPERATOR_LIKE");
        }
        if (RelationalOperators.get((int)2).equals(operator)) {
            return UIPlugin.getResourceString("STR_FILTER_OPERATOR_EQ");
        }
        if (RelationalOperators.get((int)5).equals(operator)) {
            return UIPlugin.getResourceString("STR_FILTER_OPERATOR_NEQ");
        }
        if (RelationalOperators.get((int)1).equals(operator)) {
            return UIPlugin.getResourceString("STR_FILTER_OPERATOR_GT");
        }
        if (RelationalOperators.get((int)0).equals(operator)) {
            return UIPlugin.getResourceString("STR_FILTER_OPERATOR_LT");
        }
        if (RelationalOperators.get((int)4).equals(operator)) {
            return UIPlugin.getResourceString("STR_FILTER_OPERATOR_GE");
        }
        if (RelationalOperators.get((int)3).equals(operator)) {
            return UIPlugin.getResourceString("STR_FILTER_OPERATOR_LE");
        }
        return null;
    }
}

