/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.launcher.defaults;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.internal.execution.local.common.Options;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.defaults.ExecutionTimeUI;
import org.eclipse.hyades.trace.ui.launcher.IProfilingType;
import org.eclipse.hyades.trace.ui.launcher.ProfilingAttribute;
import org.eclipse.hyades.trace.ui.launcher.ProfilingSetsManagerCopy;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ExecutionTimeProfilingType
implements IProfilingType {
    private ExecutionTimeUI _optionsUI = new ExecutionTimeUI();
    private Control control;
    private boolean isInitialized = false;
    private String description;

    public Control createControl(Composite parent, ProfilingSetsManagerCopy config) {
        this.control = this._optionsUI.createControl(parent);
        this.initializeValues(config);
        return this.control;
    }

    protected void initializeValues(ProfilingSetsManagerCopy config) {
        String prefix;
        Map configAttributes = config.getDefaultSet().getAttributes();
        Object option = configAttributes.get((prefix = "SETOPTION_") + "BOUNDARY_DEPTH");
        if (option == null) {
            this._optionsUI.setCollectionDepth("1");
        } else {
            this._optionsUI.setCollectionDepth(((ProfilingAttribute)option).getValue());
            this._optionsUI.setExecutionBoundary(true);
        }
        option = configAttributes.get(prefix + "CPU_TIME");
        if (option != null) {
            String cpuTimeValue = ((ProfilingAttribute)option).getValue();
            this._optionsUI.setCPUtime("true".equalsIgnoreCase(cpuTimeValue));
        }
        if ((option = configAttributes.get(IProfileLaunchConfigurationConstants.ATTR_SHOW_EXECUTION_FLOW)) == null) {
            this._optionsUI.setExecutionFlow(false);
            this._optionsUI.setExecutionStatistic(!this._optionsUI.getExecutionFlow());
        } else {
            this._optionsUI.setExecutionFlow(((ProfilingAttribute)option).getValue().equalsIgnoreCase("true"));
            this._optionsUI.setExecutionStatistic(!this._optionsUI.getExecutionFlow());
        }
        option = configAttributes.get(IProfileLaunchConfigurationConstants.ATTR_SHOW_EXEC_INSTANCES);
        if (option != null) {
            String instanceValue = ((ProfilingAttribute)option).getValue();
            this._optionsUI.setInstance("true".equalsIgnoreCase(instanceValue));
        }
        this._optionsUI.enableButtons();
    }

    public Control getControl(String profilingSetName) {
        return this.control;
    }

    public ProfilingAttribute[] getAttributes() {
        int idx;
        String[][] optionSet;
        String prefix = "SETOPTION_";
        ArrayList<ProfilingAttribute> options = new ArrayList<ProfilingAttribute>();
        if (this._optionsUI.getExecutionBoundary()) {
            optionSet = null;
            optionSet = this._optionsUI.getInstance() ? Options.OPTIONS_EXECUTION_FLOW_BOUNDARY_INSTANCES : Options.OPTIONS_EXECUTION_FLOW_BOUNDARY;
            idx = 0;
            while (idx < optionSet.length) {
                options.add(new ProfilingAttribute(prefix + optionSet[idx][0], optionSet[idx][1]));
                ++idx;
            }
            options.add(new ProfilingAttribute(prefix + "BOUNDARY_DEPTH", String.valueOf(this._optionsUI.getCollectionDepth())));
        } else {
            optionSet = null;
            optionSet = this._optionsUI.getInstance() ? Options.OPTIONS_EXECUTION_FLOW_INSTANCES : Options.OPTIONS_EXECUTION_FLOW;
            idx = 0;
            while (idx < optionSet.length) {
                options.add(new ProfilingAttribute(prefix + optionSet[idx][0], optionSet[idx][1]));
                ++idx;
            }
        }
        String flow = String.valueOf(this._optionsUI.getExecutionFlow());
        options.add(new ProfilingAttribute(IProfileLaunchConfigurationConstants.ATTR_SHOW_EXECUTION_FLOW, flow));
        String showHeap = String.valueOf(this._optionsUI.getInstance());
        options.add(new ProfilingAttribute(IProfileLaunchConfigurationConstants.ATTR_SHOW_EXEC_INSTANCES, showHeap));
        if (this._optionsUI.getCPUtime()) {
            String[][] optionSet2 = Options.OPTIONS_COLLECT_CPU_TIME;
            int idx2 = 0;
            while (idx2 < optionSet2.length) {
                options.add(new ProfilingAttribute(prefix + optionSet2[idx2][0], optionSet2[idx2][1]));
                ++idx2;
            }
        }
        ProfilingAttribute[] pOptions = new ProfilingAttribute[options.size()];
        options.toArray(pOptions);
        return pOptions;
    }

    public String validateConfiguration(ProfilingSetsManagerCopy managerCopy) {
        return null;
    }

    public String launch(ILaunchConfiguration config) {
        return null;
    }

    public String getDescription(ProfilingSetsManagerCopy managerCopy) {
        return this.description;
    }
}

