/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.MonitorSelectionGroup;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ISelectionValidator;
import org.eclipse.ui.dialogs.SelectionDialog;

public class MonitorSelectionDialog
extends SelectionDialog
implements ISelectionValidator,
Listener {
    public static final int MONITOR = 1;
    public static final int FOLDER = 2;
    public static final int ALL = 1;
    private MonitorSelectionGroup group;
    private boolean onlyMonitorFolders = true;
    private int style;
    private int type;
    private Label statusMessage;
    private static final int SIZING_SELECTION_PANE_HEIGHT = 250;
    private static final int SIZING_SELECTION_PANE_WIDTH = 300;

    public MonitorSelectionDialog(Shell parentShell, String message) {
        this(parentShell, message, 0, 1);
    }

    public MonitorSelectionDialog(Shell parentShell, String message, int style, int type) {
        super(parentShell);
        this.setTitle(UIPlugin.getResourceString("STR_MON_SEL_TITLE"));
        this.style = style;
        this.type = type;
        this.onlyMonitorFolders = true;
        if (message != null) {
            this.setMessage(message);
        } else {
            this.setMessage(UIPlugin.getResourceString("STR_MON_SEL_TEXT"));
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control result = super.createButtonBar(parent);
        this.statusMessage.setForeground(this.statusMessage.getDisplay().getSystemColor(3));
        this.statusMessage.setText(UIPlugin.getResourceString("STR_MON_SEL_TEXT"));
        this.getOkButton().setEnabled(false);
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.group = new MonitorSelectionGroup(dialogArea, this, true);
        this.statusMessage = new Label(parent, 0);
        this.statusMessage.setLayoutData((Object)new GridData(1808));
        return dialogArea;
    }

    public void handleEvent(Event event) {
        if (this.statusMessage != null) {
            String errorMsg = this.isValid(this.group.getContainerFullPath());
            if (errorMsg == null || errorMsg.equals("")) {
                this.statusMessage.setText("");
                this.getOkButton().setEnabled(true);
            } else {
                this.statusMessage.setForeground(this.statusMessage.getDisplay().getSystemColor(3));
                this.statusMessage.setText(errorMsg);
                this.getOkButton().setEnabled(false);
            }
        }
    }

    public String isValid(Object selection) {
        IPath path = (IPath)selection;
        if (path == null) {
            return null;
        }
        IWorkspaceRoot root = UIPlugin.getPluginWorkbench().getRoot();
        IResource res = root.findMember(path);
        if (res != null && res instanceof IContainer) {
            return UIPlugin.getResourceString("STR_MON_SEL_TEXT");
        }
        if (path.segmentCount() == 1) {
            return UIPlugin.getResourceString("STR_INVALID_MON_TEXT");
        }
        return null;
    }

    protected void okPressed() {
        ArrayList<IPath> chosenContainerPathList = new ArrayList<IPath>();
        chosenContainerPathList.add(this.group.getContainerFullPath());
        this.setResult(chosenContainerPathList);
        super.okPressed();
    }

    public void setShowOnlyMonitorFolders(boolean value) {
        this.onlyMonitorFolders = value;
    }
}

