/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.util.Vector;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.trace.ui.internal.launcher.AgentAttribute;
import org.eclipse.hyades.trace.ui.internal.util.ProcessTreeItem;

public class ProfilingAgentList {
    private Vector items = new Vector();

    public void initializeFromAgents(Object[] p_items) {
        this.items.clear();
        int i = 0;
        while (i < p_items.length) {
            if (p_items[i] instanceof ProcessTreeItem) {
                this.addAgent((ProcessTreeItem)p_items[i]);
            }
            ++i;
        }
    }

    public void addAgent(ProcessTreeItem item) {
        this.items.addElement(item);
    }

    protected ProcessTreeItem agent(int i) {
        return (ProcessTreeItem)this.items.get(i);
    }

    public void removeAgent(ProcessTreeItem item) {
        this.items.removeElement(item);
    }

    public ProcessTreeItem[] getAgents() {
        ProcessTreeItem[] processTreeItems = new ProcessTreeItem[this.items.size()];
        this.items.toArray(processTreeItems);
        return processTreeItems;
    }

    public int getAgentCount() {
        return this.items.size();
    }

    public ProcessTreeItem[] getProcessList() {
        Vector<ProcessTreeItem> processV = new Vector<ProcessTreeItem>();
        int processCount = 0;
        int i = 0;
        while (i < this.getAgentCount()) {
            ProcessTreeItem pti = this.agent(i).getParent();
            if (!this.processInProcessVector(pti.getProcessId(), processV)) {
                processV.addElement(pti);
                ++processCount;
            }
            ++i;
        }
        ProcessTreeItem[] processTreeItems = new ProcessTreeItem[processCount];
        processV.toArray(processTreeItems);
        return processTreeItems;
    }

    private boolean processInProcessVector(String pid, Vector processV) {
        int i = 0;
        while (i < processV.size()) {
            if (pid.equals(((ProcessTreeItem)processV.get(i)).getProcessId())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean agentInList(ProcessTreeItem pti) {
        if (pti.getData() instanceof Agent) {
            Agent agent = (Agent)pti.getData();
            return this.getAgentForAgentAttribute(pti.getProcessId(), agent.getName(), agent.getType()) != null;
        }
        return false;
    }

    private ProcessTreeItem getAgentForAgentAttribute(String pid, String name, String type) {
        int i = 0;
        while (i < this.getAgentCount()) {
            Agent agentElem = (Agent)this.agent(i).getData();
            String elemPid = this.agent(i).getProcessId();
            if (agentElem.getName().equals(name) && agentElem.getType().equals(type) && elemPid.equals(pid)) {
                return (ProcessTreeItem)this.items.get(i);
            }
            ++i;
        }
        return null;
    }

    public ProcessTreeItem getAgentForAgentAttribute(AgentAttribute agAttr) {
        return this.getAgentForAgentAttribute(agAttr.getPID(), agAttr.getName(), agAttr.getType());
    }
}

