/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.filters.internal.util.FilterQueries;
import org.eclipse.hyades.trace.ui.filters.internal.util.FilterResourceFileHandler;
import org.eclipse.hyades.trace.ui.filters.internal.util.FilterResourceHandler;
import org.eclipse.hyades.trace.ui.internal.wizard.ExportImportFilterWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;

public class ExportFilterWizardPage
extends ExportImportFilterWizardPage {
    public ExportFilterWizardPage(IWorkbench aWorkbench, IStructuredSelection selection) {
        super("FilterExportPage", aWorkbench, selection);
        this.setTitle(UIPlugin.getResourceString("EXPORT_FILTER_PAGE_TITLE"));
        this.setDescription(UIPlugin.getResourceString("EXPORT_FILTER_PAGE_DESC"));
        this.setImageDescriptor(PDPluginImages.getImageDescriptor("filter_export_wiz.gif"));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setSize(composite.computeSize(-1, -1));
        this.createBoldLabel(composite, UIPlugin.getResourceString("STR_SELECT_FILTER_EXPORT_LABEL"));
        this.createDoubleList(composite, UIPlugin.getResourceString("EXPORT_AVAILABLE_FILTERS"), UIPlugin.getResourceString("EXPORT_SELECTED_FILTERS"));
        this.createSourceGroup(composite);
        this.createSpacer(composite);
        this.initializeValues();
        this.setControl((Control)composite);
    }

    protected List populateFilterList() {
        FilterResourceHandler resource = FilterResourceHandler.instance();
        Object[] filterQueries = resource.toArray();
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < filterQueries.length) {
            list.add(filterQueries[i]);
            ++i;
        }
        return list;
    }

    public boolean finish() {
        List filtersToExport = this.getDoubleList().getTargetItems();
        String exportFile = this.sourceNameField.getText().trim();
        if (!exportFile.endsWith(".filtxml")) {
            exportFile = exportFile + ".filtxml";
        }
        FilterResourceFileHandler exportResourceHandler = FilterResourceFileHandler.instance(URI.createFileURI((String)exportFile));
        exportResourceHandler.clear();
        int i = 0;
        while (i < filtersToExport.size()) {
            exportResourceHandler.addFilter(((FilterQueries)filtersToExport.get(i)).copy());
            ++i;
        }
        exportResourceHandler.save();
        exportResourceHandler.unload();
        return true;
    }

    protected boolean validateLists() {
        return true;
    }
}

