/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.text.DateFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceLocationUI;
import org.eclipse.hyades.trace.ui.internal.wizard.OpenLogAgentWizard;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class OpenLogAgentPage
extends WizardPage
implements ModifyListener {
    protected TraceLocationUI _locationUI;
    protected Text _name;
    protected INavigator fViewer;
    protected Text _hour;
    protected Text _min;
    protected Text _sec;
    protected Text _micsec;
    protected Group deltaTime;
    protected int hourValue = 0;
    protected int minValue = 0;
    protected int secValue = 0;
    protected int micsecValue = 0;

    public OpenLogAgentPage(String name, INavigator viewer) {
        super(name);
        this.setTitle(UIPlugin.getResourceString("LOG_AGENT_TITLE"));
        this.fViewer = viewer;
        this.setDescription("");
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 5;
        content.setLayout((Layout)layout);
        GridData gd = GridUtil.createFill();
        gd.widthHint = 500;
        gd.heightHint = 400;
        content.setLayoutData((Object)gd);
        this._locationUI = new TraceLocationUI();
        this._locationUI.createControl(content);
        this._locationUI.setEnabled(false);
        Composite nameGrp = new Composite(content, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 5;
        nameGrp.setLayout((Layout)layout);
        nameGrp.setLayoutData((Object)GridUtil.createHorizontalFill());
        Label nameLabel = new Label(nameGrp, 0);
        nameLabel.setText(UIPlugin.getResourceString("STR_AGENT_NAME"));
        this._name = new Text(nameGrp, 2048);
        this._name.setLayoutData((Object)GridUtil.createHorizontalFill());
        this._name.setEnabled(false);
        this.deltaTime = new Group(content, 0);
        layout = new GridLayout();
        layout.numColumns = 8;
        layout.verticalSpacing = 5;
        this.deltaTime.setLayout((Layout)layout);
        this.deltaTime.setLayoutData((Object)GridUtil.createHorizontalFill());
        this.deltaTime.setText(UIPlugin.getResourceString("STR_SYNCH_NODE_TIME"));
        Label label = new Label((Composite)this.deltaTime, 0);
        label.setText(UIPlugin.getResourceString("STR_DELTA_TIME"));
        this._hour = new Text((Composite)this.deltaTime, 2048);
        gd = new GridData();
        gd.widthHint = 40;
        this._hour.setLayoutData((Object)gd);
        this._hour.setTextLimit(4);
        label = new Label((Composite)this.deltaTime, 0);
        label.setText(":");
        this._min = new Text((Composite)this.deltaTime, 2048);
        gd = new GridData();
        gd.widthHint = 30;
        this._min.setLayoutData((Object)gd);
        this._min.setTextLimit(3);
        label = new Label((Composite)this.deltaTime, 0);
        label.setText(":");
        this._sec = new Text((Composite)this.deltaTime, 2048);
        gd = new GridData();
        gd.widthHint = 30;
        this._sec.setLayoutData((Object)gd);
        this._sec.setTextLimit(3);
        label.setText(":");
        this._micsec = new Text((Composite)this.deltaTime, 2048);
        gd = new GridData();
        gd.widthHint = 70;
        this._micsec.setLayoutData((Object)gd);
        this._micsec.setTextLimit(7);
        label = new Label((Composite)this.deltaTime, 0);
        label.setText(UIPlugin.getResourceString("STR_DELTA_HMS"));
        label = new Label((Composite)this.deltaTime, 0);
        label.setText(UIPlugin.getResourceString("STR_DELTA_MICROSEC_EXAMPLE"));
        gd = new GridData();
        gd.horizontalSpan = 8;
        label.setLayoutData((Object)gd);
        this._hour.addModifyListener((ModifyListener)this);
        this._min.addModifyListener((ModifyListener)this);
        this._sec.addModifyListener((ModifyListener)this);
        this._micsec.addModifyListener((ModifyListener)this);
        this.setControl((Control)content);
        this.populateData();
        WorkbenchHelp.setHelp((Control)parent, (String)(UIPlugin.getPluginId() + ".olap0000"));
    }

    public boolean finish() {
        TRCAgentProxy agent = ((OpenLogAgentWizard)this.getWizard()).getAgent();
        if (agent != null) {
            agent.setDeltaTime(this.getDeltaTime());
        }
        return true;
    }

    public double getDeltaTime() {
        int hours = 0;
        try {
            hours = Integer.parseInt(this._hour.getText());
        }
        catch (Exception exc) {
            // empty catch block
        }
        int min = 0;
        try {
            min = Integer.parseInt(this._min.getText());
        }
        catch (Exception exc) {
            // empty catch block
        }
        int sec = 0;
        try {
            sec = Integer.parseInt(this._sec.getText());
        }
        catch (Exception exc) {
            // empty catch block
        }
        int micsec = 0;
        try {
            micsec = Integer.parseInt(this._micsec.getText());
        }
        catch (Exception exc) {
            // empty catch block
        }
        if (hours < 0 || min < 0 || sec < 0 || micsec < 0) {
            return -((double)(Math.abs(hours) * 3600 + Math.abs(min) * 60 + Math.abs(sec)) * 1000000.0 + (double)Math.abs(micsec));
        }
        return ((double)hours * 3600.0 + (double)(min * 60) + (double)sec) * 1000000.0 + (double)micsec;
    }

    public void setDeltaTime(double delta) {
        DateFormat df = DateFormat.getTimeInstance();
        try {
            int micsec = (int)(Math.abs(delta) % 1000000.0);
            double absDelta = Math.abs(delta) / 1000000.0;
            int hour = (int)(absDelta / 3600.0);
            int min = (int)(absDelta % 3600.0 / 60.0);
            int sec = (int)(absDelta % 3600.0 % 60.0);
            if (delta >= 0.0) {
                this.hourValue = hour;
                this.minValue = min;
                this.secValue = sec;
                this.micsecValue = micsec;
            } else {
                int n = this.hourValue = hour > 0 ? -hour : hour;
                this.minValue = this.hourValue != 0 ? min : (min != 0 ? -min : 0);
                this.secValue = this.hourValue != 0 || this.minValue != 0 ? sec : (sec != 0 ? -sec : sec);
                this.micsecValue = this.hourValue != 0 || this.minValue != 0 || this.secValue != 0 ? micsec : (micsec != 0 ? -micsec : micsec);
            }
            this._hour.setText(this.hourValue == 0 ? "" : String.valueOf(this.hourValue));
            this._min.setText(this.minValue == 0 ? "" : String.valueOf(this.minValue));
            this._sec.setText(this.secValue == 0 ? "" : String.valueOf(this.secValue));
            this._micsec.setText(this.micsecValue == 0 ? "" : String.valueOf(this.micsecValue));
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    protected void populateData() {
        TRCAgentProxy agent;
        IResource sel = HyadesUtil.getSelectionFolder(this.fViewer);
        if (sel != null) {
            this._locationUI.setLocation(sel.getFullPath().toOSString());
        }
        if ((agent = ((OpenLogAgentWizard)this.getWizard()).getAgent()) == null) {
            return;
        }
        this._locationUI.setMonitor(agent.getProcessProxy().getNode().getMonitor().getName());
        this._name.setText(agent.getName());
        if (agent.getDeltaTime() != 0.0) {
            this.setDeltaTime(agent.getDeltaTime());
        }
    }

    public void modifyText(ModifyEvent event) {
        block13: {
            block15: {
                block14: {
                    block12: {
                        if (event.widget != this._hour) break block12;
                        try {
                            this.hourValue = Integer.parseInt(this._hour.getText().trim());
                            this.setErrorMessage(null);
                            this.setPageComplete(this.canCompletePage());
                        }
                        catch (NumberFormatException e) {
                            if (this._hour.getText().trim().equals("")) {
                                this.hourValue = 0;
                                this.setPageComplete(this.canCompletePage());
                                return;
                            }
                            String message = UIPlugin.getResourceString("INVALID_DELTA_FORMAT");
                            this.setErrorMessage(message);
                            this.setPageComplete(false);
                        }
                        break block13;
                    }
                    if (event.widget != this._min) break block14;
                    try {
                        this.minValue = Integer.parseInt(this._min.getText().trim());
                        this.setPageComplete(this.canCompletePage());
                    }
                    catch (NumberFormatException e) {
                        if (this._min.getText().trim().equals("")) {
                            this.minValue = 0;
                            this.setPageComplete(this.canCompletePage());
                            return;
                        }
                        String message = UIPlugin.getResourceString("INVALID_DELTA_FORMAT");
                        this.setErrorMessage(message);
                        this.setPageComplete(false);
                    }
                    break block13;
                }
                if (event.widget != this._sec) break block15;
                try {
                    this.secValue = Integer.parseInt(this._sec.getText().trim());
                    this.setPageComplete(this.canCompletePage());
                }
                catch (NumberFormatException e) {
                    if (this._sec.getText().trim().equals("")) {
                        this.secValue = 0;
                        this.setPageComplete(this.canCompletePage());
                        return;
                    }
                    String message = UIPlugin.getResourceString("INVALID_DELTA_FORMAT");
                    this.setErrorMessage(message);
                    this.setPageComplete(false);
                }
                break block13;
            }
            if (event.widget != this._micsec) break block13;
            try {
                this.micsecValue = Integer.parseInt(this._micsec.getText().trim());
                this.setPageComplete(this.canCompletePage());
            }
            catch (NumberFormatException e) {
                if (this._micsec.getText().trim().equals("")) {
                    this.micsecValue = 0;
                    this.setPageComplete(this.canCompletePage());
                    return;
                }
                String message = UIPlugin.getResourceString("INVALID_DELTA_FORMAT");
                this.setErrorMessage(message);
                this.setPageComplete(false);
            }
        }
    }

    protected boolean canCompletePage() {
        String hour = this._hour.getText().trim();
        String min = this._min.getText().trim();
        String sec = this._sec.getText().trim();
        String micsec = this._micsec.getText().trim();
        return this.isHourValid() && this.isMinValid() && this.isSecValid() && this.isMicsecValid();
    }

    protected boolean isHourValid() {
        block2: {
            int hourValue = 0;
            String hour = this._hour.getText().trim();
            try {
                hourValue = Integer.parseInt(hour);
            }
            catch (Exception e) {
                if (hour.equals("")) break block2;
                this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
                return false;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    protected boolean isMinValid() {
        String hour;
        int minValue;
        block3: {
            minValue = 0;
            hour = this._hour.getText().trim();
            String min = this._min.getText().trim();
            try {
                minValue = Integer.parseInt(min);
            }
            catch (Exception e) {
                if (this._min.getText().trim().equals("")) break block3;
                this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
                return false;
            }
        }
        if (!(hour.equals("") || this.hourValue == 0 || minValue >= 0 && minValue < 60)) {
            this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_TIME"));
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected boolean isSecValid() {
        String min;
        String hour;
        int secValue;
        block3: {
            secValue = 0;
            hour = this._hour.getText().trim();
            min = this._min.getText().trim();
            String sec = this._sec.getText().trim();
            try {
                secValue = Integer.parseInt(sec);
            }
            catch (Exception e) {
                if (this._sec.getText().trim().equals("")) break block3;
                this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
                return false;
            }
        }
        if ((!hour.equals("") && this.hourValue != 0 || !min.equals("") && this.minValue != 0) && (secValue < 0 || secValue >= 60)) {
            this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_TIME"));
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected boolean isMicsecValid() {
        String sec;
        String min;
        String hour;
        block3: {
            boolean microsecValue = false;
            hour = this._hour.getText().trim();
            min = this._min.getText().trim();
            sec = this._sec.getText().trim();
            String micsec = this._micsec.getText().trim();
            try {
                this.micsecValue = Integer.parseInt(micsec);
            }
            catch (Exception e) {
                if (this._micsec.getText().trim().equals("")) break block3;
                this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_FORMAT"));
                return false;
            }
        }
        if ((!hour.equals("") && this.hourValue != 0 || !min.equals("") && this.minValue != 0 || !sec.equals("") && this.secValue != 0) && (this.micsecValue < 0 || this.micsecValue >= 1000000)) {
            this.setErrorMessage(UIPlugin.getResourceString("INVALID_DELTA_TIME"));
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }
}

