/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.loaders.cbe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.XMLFragmentLoader;

public class XMLCollector
implements XMLFragmentLoader {
    private Element currentElement;
    private Element rootElement;
    private int level;

    public String getTargetFeatureName() {
        return this.rootElement.getName();
    }

    public String getTargetFeatureValue() {
        return this.printContent();
    }

    public void addAttribute(String name, String value) {
        this.currentElement.addAttribute(name, value);
    }

    public void addCharacters(char[] data, int offset, int length) {
        this.currentElement.addCharacters(data, offset, length);
    }

    public void addYourselfInContext() {
    }

    public void cleanUp() {
    }

    public boolean done() {
        return this.level == 0;
    }

    public void endChild(String name) {
        if (this.level == 0) {
            return;
        }
        this.currentElement = this.currentElement.getParent();
        --this.level;
    }

    public void initialize(HierarchyContext context, String name) {
        this.currentElement = this.rootElement = new Element(name, null);
        this.level = 0;
    }

    public void startChild(String name) {
        this.addChild(name);
        ++this.level;
    }

    private void addChild(String name) {
        List children = this.currentElement.getChildren();
        this.currentElement = new Element(name, this.currentElement);
        children.add(this.currentElement);
    }

    private void printAttributes(Attributes attributes, StringBuffer buffer) {
        if (attributes == null) {
            return;
        }
        Iterator iter = attributes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            buffer.append(' ');
            buffer.append(entry.getKey());
            buffer.append('=');
            buffer.append('\"');
            buffer.append(entry.getValue());
            buffer.append('\"');
        }
    }

    private String printContent() {
        if (this.rootElement == null) {
            return null;
        }
        if (this.rootElement.getChildren().isEmpty()) {
            if (this.rootElement.getCdata() != null && this.rootElement.getCdata().toString() != null) {
                return this.rootElement.getCdata().toString().trim();
            }
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        Iterator iter = this.rootElement.getChildren().iterator();
        while (iter.hasNext()) {
            Element childElement = (Element)iter.next();
            this.printElement(childElement, buffer);
        }
        return buffer.toString();
    }

    private void printElement(Element element, StringBuffer buffer) {
        buffer.append('<');
        buffer.append(element.getName());
        this.printAttributes(element.getAttributes(), buffer);
        if (element.getChildren() != null) {
            buffer.append(">\n");
            Iterator iter = element.getChildren().iterator();
            while (iter.hasNext()) {
                Element childElement = (Element)iter.next();
                this.printElement(childElement, buffer);
            }
            if (element.getCdata() != null) {
                buffer.append(element.getCdata().toString());
            }
            buffer.append("</");
            buffer.append(element.getName());
            buffer.append(">\n");
        } else if (element.getCdata() != null) {
            buffer.append(element.getCdata().toString());
            buffer.append("</");
            buffer.append(element.getName());
            buffer.append(">\n");
        } else {
            buffer.append("/>\n");
        }
    }

    public class Element
    extends ArrayList {
        private Attributes attributes;
        private Element parent;
        private String name;
        private StringBuffer cdata;

        public Element(String name, Element parent) {
            this.name = name;
            this.parent = parent;
        }

        public Attributes getAttributes() {
            return this.attributes;
        }

        public StringBuffer getCdata() {
            return this.cdata;
        }

        public List getChildren() {
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Element getParent() {
            return this.parent;
        }

        public void addAttribute(String name, String value) {
            if (this.attributes == null) {
                this.attributes = new Attributes(this);
            }
            this.attributes.append(name, value);
        }

        public void addCharacters(char[] data, int offset, int length) {
            if (this.cdata == null) {
                this.cdata = new StringBuffer();
            }
            this.cdata.append(data, offset, length);
        }
    }

    public class Attributes
    extends HashMap {
        private Element parent;

        public Attributes(Element parent) {
            this.parent = parent;
        }

        public void append(String name, String value) {
            String newValue = (String)this.get(name);
            newValue = newValue != null ? newValue + value : value;
            this.put(name, newValue);
        }
    }
}

