/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.trace;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class TraceSDPlugin
extends AbstractUIPlugin {
    public static final String UML2SD_TRACE_VIEW_ID = "org.eclipse.hyades.uml2sd.trace.view.TraceSDView";
    private static TraceSDPlugin plugin;
    private ResourceBundle resourceBundle;
    private static URL BASIC_URL;
    private static Hashtable images;
    public static boolean debugMatch;
    public static boolean debugLoader;
    public static boolean debugEvents;
    public static boolean debugPlugin;

    public TraceSDPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        TraceSDPlugin.debugTracePlugin("Start called");
        try {
            this.resourceBundle = Platform.getResourceBundle((Bundle)this.getBundle());
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (images != null) {
            Iterator e = images.values().iterator();
            while (e.hasNext()) {
                Object next = e.next();
                if (!(next instanceof Image) || ((Image)next).isDisposed()) continue;
                ((Image)next).dispose();
            }
            images.clear();
            images = null;
        }
        super.stop(context);
        TraceSDPlugin.debugTracePlugin("stop finished");
    }

    public static TraceSDPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault("page_size", 131072);
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = TraceSDPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static String getId() {
        return TraceSDPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static Image getResourceImage(String _name) {
        ImageDescriptor imgd;
        if (TraceSDPlugin.getDefault() == null) {
            return null;
        }
        if (images != null) {
            Image img = (Image)images.get(_name);
            if (img != null && !img.isDisposed()) {
                TraceSDPlugin.debugTracePlugin("Optimizing for image " + _name);
                return img;
            }
        } else {
            images = new Hashtable();
        }
        if ((imgd = TraceSDPlugin.getResourceImageDescriptor(_name)) == null) {
            return null;
        }
        Image img = imgd.createImage();
        images.put(_name, img);
        return img;
    }

    public static ImageDescriptor getResourceImageDescriptor(String _name) {
        ImageDescriptor imgd;
        if (BASIC_URL == null) {
            try {
                BASIC_URL = new URL("platform", "localhost", "plugin");
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return null;
            }
        }
        try {
            URL url = new URL(BASIC_URL, "plugin/org.eclipse.hyades.uml2sd.trace/icons/" + _name);
            imgd = ImageDescriptor.createFromURL((URL)url);
            TraceSDPlugin.debugTracePlugin("Getting image " + url);
        }
        catch (MalformedURLException e) {
            imgd = ImageDescriptor.getMissingImageDescriptor();
            TraceSDPlugin.debugTracePlugin("Missing image " + BASIC_URL + _name);
        }
        return imgd;
    }

    private static boolean checkForDebugTrace(String option) {
        String value = Platform.getDebugOption((String)option);
        return value != null && value.equalsIgnoreCase("true");
    }

    public static void debugTraceMatch(String msg) {
        if (debugMatch) {
            System.out.println(msg);
        }
    }

    public static void debugTraceLoader(String msg) {
        if (debugLoader) {
            System.out.println(msg);
        }
    }

    public static void debugTraceEvents(String msg) {
        if (debugEvents) {
            System.out.println(msg);
        }
    }

    public static void debugTracePlugin(String msg) {
        if (debugPlugin) {
            System.out.println(msg);
        }
    }

    static {
        BASIC_URL = null;
        images = null;
        debugMatch = TraceSDPlugin.checkForDebugTrace("org.eclipse.hyades.uml2sd.trace/match");
        debugLoader = TraceSDPlugin.checkForDebugTrace("org.eclipse.hyades.uml2sd.trace/loader");
        debugEvents = TraceSDPlugin.checkForDebugTrace("org.eclipse.hyades.uml2sd.trace/events");
        debugPlugin = TraceSDPlugin.checkForDebugTrace("org.eclipse.hyades.uml2sd.trace/plugin");
    }
}

