/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.trace.loaders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.IProfileEventListener;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.actions.internal.OpenExecutionStatisticAction;
import org.eclipse.hyades.uml2sd.trace.TraceSDPlugin;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.ContextIds;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.DateComparator;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceCallStack;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceInteractionUpdate;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceLifelineDraft;
import org.eclipse.hyades.uml2sd.trace.loaders.internal.TraceProcesses;
import org.eclipse.hyades.uml2sd.trace.selection.IDateSelection;
import org.eclipse.hyades.uml2sd.trace.util.TIUtils;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDExtendedActionBarProvider;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDFindProvider;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.Criteria;
import org.eclipse.hyades.uml2sd.ui.core.BasicExecutionOccurrence;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.GraphNode;
import org.eclipse.hyades.uml2sd.ui.load.BackgroundLoader;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.help.WorkbenchHelp;

public abstract class BaseTraceInteractions
implements ISelectionListener,
ISDFindProvider,
IProfileEventListener,
ISDExtendedActionBarProvider {
    public static final String ACTIONS_SHOWSTATTABLE = "org.eclipse.hyades.uml2sd.trace.actions.ShowStatTable";
    protected SDView view;
    protected Frame frame;
    protected TraceProcesses currentProcesses;
    protected List currentMofObjectsFromPDProjectExplorer;
    private Cursor waitCursor;
    private IProgressMonitor monitor_;
    protected HashMap traceThreadMap;
    protected ArrayList traceThreadList;
    protected ArrayList findResults;
    protected Criteria findCriteria;
    protected int currentFindIndex;

    public void setViewer(SDView view_) {
        if (TraceSDPlugin.debugEvents) {
            TraceSDPlugin.debugTraceEvents("Class " + this.getClass().getName() + " setViewer()");
        }
        this.view = view_;
        this.view.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        this.view.setEnableAction(ACTIONS_SHOWSTATTABLE, true);
        UIPlugin.getDefault().addProfileEventListener((IProfileEventListener)this);
        this.view.setSDFindProvider((ISDFindProvider)this);
        this.view.setSDExtendedActionBarProvider((ISDExtendedActionBarProvider)this);
        this.onSetViewer();
        WorkbenchHelp.setHelp((Control)this.view.getSDWidget(), (String)ContextIds.INTERACTION_VIEW);
        this.parseModelFromNavigator(false);
    }

    protected void parseModelFromNavigator(boolean optional) {
        List list = TIUtils.collectMultiSelectionInNavigator();
        if (optional && this.currentMofObjectsFromPDProjectExplorer != null && this.currentMofObjectsFromPDProjectExplorer.size() == list.size() && this.currentMofObjectsFromPDProjectExplorer.containsAll(list)) {
            return;
        }
        this.currentMofObjectsFromPDProjectExplorer = list;
        this.parseModelBackground();
    }

    public abstract void onSetViewer();

    public void aboutToBeReplaced() {
        if (this.view != null) {
            this.view.setEnableAction(ACTIONS_SHOWSTATTABLE, false);
        }
        UIPlugin.getDefault().removeSelectionListener((ISelectionListener)this);
        UIPlugin.getDefault().removeProfileEventListener((IProfileEventListener)this);
        this.clearInternals();
        this.view = null;
        if (TraceSDPlugin.debugEvents) {
            TraceSDPlugin.debugTraceEvents("Class " + this.getClass().getName() + " aboutToBeReplaced()");
        }
    }

    public SDView getView() {
        return this.view;
    }

    protected void clearInternals() {
        this.currentMofObjectsFromPDProjectExplorer = null;
        this.currentProcesses = null;
        this.frame = null;
        if (this.waitCursor != null && !this.waitCursor.isDisposed()) {
            this.waitCursor.dispose();
        }
        this.waitCursor = null;
        this.clearFindInternals();
    }

    protected void clearFindInternals() {
        this.findResults = null;
        this.findCriteria = null;
        this.currentFindIndex = 0;
    }

    protected abstract void parseModel(List var1);

    protected abstract void computeModel();

    protected abstract void updateSD(TraceInteractionUpdate var1);

    protected boolean isCurrentLoadCanceled() {
        return this.monitor_ != null && this.monitor_.isCanceled();
    }

    private void beforeLongTask(IProgressMonitor monitor, String taskName) {
        if (this.view == null || this.view.getSDWidget().isDisposed()) {
            monitor.setCanceled(true);
            return;
        }
        this.monitor_ = monitor;
        this.view.toggleWaitCursorSync(true);
        monitor.beginTask(taskName, 100);
    }

    private void afterLongTask(IProgressMonitor monitor) {
        monitor.done();
        if (this.view != null && !this.view.getSDWidget().isDisposed()) {
            this.view.toggleWaitCursorSync(false);
        }
    }

    protected void parseModelBackground() {
        BackgroundLoader.getInstance().newTask(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InterruptedException {
                BaseTraceInteractions.this.beforeLongTask(monitor, TraceSDPlugin.getResourceString("TASK_NAME_CREATING_SD"));
                if (!BaseTraceInteractions.this.isCurrentLoadCanceled()) {
                    BaseTraceInteractions.this.parseModel(BaseTraceInteractions.this.currentMofObjectsFromPDProjectExplorer);
                }
                BaseTraceInteractions.this.afterLongTask(monitor);
            }
        });
    }

    protected void updateSDBackground(final TraceInteractionUpdate update) {
        BackgroundLoader.getInstance().newTask(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InterruptedException {
                BaseTraceInteractions.this.beforeLongTask(monitor, TraceSDPlugin.getResourceString("TASK_NAME_UPDATING_SD"));
                if (!BaseTraceInteractions.this.isCurrentLoadCanceled()) {
                    BaseTraceInteractions.this.updateSD(update);
                }
                BaseTraceInteractions.this.afterLongTask(monitor);
            }
        });
    }

    protected void createFrame() {
        if (this.currentProcesses == null && this.currentMofObjectsFromPDProjectExplorer != null) {
            this.currentProcesses = new TraceProcesses();
            Iterator i = this.currentMofObjectsFromPDProjectExplorer.iterator();
            while (i.hasNext() && !this.isCurrentLoadCanceled()) {
                TraceProcesses someProcesses = TraceProcesses.getTraceProcesses((EObject)i.next(), this.monitor_);
                if (someProcesses == null) continue;
                this.currentProcesses.addAll(someProcesses);
            }
            if (this.currentProcesses.size() == 0) {
                this.currentProcesses = null;
            }
        }
        this.frame = new Frame();
        if (this.currentProcesses == null) {
            this.frame.setName(TraceSDPlugin.getResourceString("STR_NO_PROCESSES_HERE"));
        } else {
            this.frame.setTimeUnitName(TraceSDPlugin.getResourceString("STR_TIME_UNIT_IS_SECOND"));
        }
    }

    public abstract void setFrameName();

    public abstract void fillPage(TraceInteractionUpdate var1);

    protected TraceCallStack getTraceCallStack(TRCThread eThread) {
        TraceCallStack ret = (TraceCallStack)this.traceThreadMap.get(eThread);
        if (ret == null) {
            ret = new TraceCallStack(this, eThread);
            this.traceThreadMap.put(eThread, ret);
            this.traceThreadList.add(ret);
        }
        return ret;
    }

    public void sortTraceThreadList(TraceCallStack tcs) {
        this.traceThreadList.remove(tcs);
        int i = 0;
        while (i < this.traceThreadList.size()) {
            TraceCallStack tcs2 = (TraceCallStack)this.traceThreadList.get(i);
            if (tcs.getCurrentExitTime() < tcs2.getCurrentExitTime()) {
                this.traceThreadList.add(i, tcs);
                return;
            }
            ++i;
        }
        this.traceThreadList.add(tcs);
    }

    protected double getTraceThreadListFirstTime() {
        double ret = this.traceThreadList != null && this.traceThreadList.size() > 0 ? ((TraceCallStack)this.traceThreadList.get(0)).getCurrentExitTime() : Double.MAX_VALUE;
        return ret;
    }

    protected long getTraceThreadListFirstTicket() {
        long ret = this.traceThreadList != null && this.traceThreadList.size() > 0 ? ((TraceCallStack)this.traceThreadList.get(0)).getCurrentTicket() : Long.MAX_VALUE;
        return ret;
    }

    protected TRCThread getTraceThreadListFirstThread() {
        TRCThread ret = this.traceThreadList != null && this.traceThreadList.size() > 0 ? ((TraceCallStack)this.traceThreadList.get(0)).getEThread() : null;
        return ret;
    }

    protected short getTraceThreadListFirstStackDepth() {
        short ret = this.traceThreadList != null && this.traceThreadList.size() > 0 ? ((TraceCallStack)this.traceThreadList.get(0)).getCurrentStackDepth() : (short)Short.MAX_VALUE;
        return ret;
    }

    protected void setExecutionOccurence(TraceLifelineDraft draft) {
        if (draft != null) {
            if (draft.getStart() == Integer.MAX_VALUE) {
                draft.setStart(0);
            }
            BasicExecutionOccurrence occ = new BasicExecutionOccurrence();
            occ.setStartOccurrence(draft.getStart());
            occ.setEndOccurrence(draft.getEnd());
            draft.getLifeline().addExecution(occ);
        }
    }

    protected abstract EObject getLifelineEObjectFromMethodInvocation(TRCFullMethodInvocation var1);

    protected abstract String getLifeLineTitle(EObject var1, boolean var2);

    protected abstract int getLifeLineCategory(EObject var1);

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (TraceSDPlugin.debugEvents) {
            TraceSDPlugin.debugTraceEvents("selectionChanged(" + part + ")=" + selection);
        }
        if (part instanceof PDProjectExplorer) {
            if (!((PDProjectExplorer)part).isLinkingEnabled()) {
                return;
            }
            if (this.view != null && this.view.getSDWidget() != null && !this.view.getSDWidget().isDisposed()) {
                this.parseModelFromNavigator(false);
            }
        } else if (part instanceof SDView) {
            if (TraceSDPlugin.debugEvents) {
                this.showInternalSelection(selection);
            }
        } else {
            if (this.frame == null) {
                return;
            }
            TraceInteractionUpdate update = new TraceInteractionUpdate();
            this.externalSelectionChanged(part, selection, update);
            this.finishExternalExtendedSelection(update);
            if (update.needsUpdate()) {
                this.updateSDBackground(update);
            }
        }
    }

    public void handleProfileEvent(ProfileEvent event) {
        if (TraceSDPlugin.debugEvents) {
            TraceSDPlugin.debugTraceEvents("handleProfileEvent(" + event + ")=" + " " + event.getType());
        }
        if ((event.getSource() == null || event.getSource() instanceof EObject) && (event.getType() & 0x1460) != 0 && this.view != null && this.view.getSDWidget() != null && !this.view.getSDWidget().isDisposed()) {
            this.parseModelFromNavigator(event.getType() == 64);
        }
    }

    private void showInternalSelection(Object selection) {
        if (TraceSDPlugin.debugEvents) {
            TraceSDPlugin.debugTraceEvents("showInternalSelection(" + selection + ")");
        }
        if (selection instanceof IDateSelection) {
            IDateSelection ds = (IDateSelection)selection;
            if (TraceSDPlugin.debugEvents) {
                TraceSDPlugin.debugTraceEvents(Double.toString(ds.getStartDate()));
            }
        } else if (selection instanceof IStructuredSelection) {
            IStructuredSelection iss = (IStructuredSelection)selection;
            Iterator i = iss.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (TraceSDPlugin.debugEvents) {
                    TraceSDPlugin.debugTraceEvents("IStructuredSelection:showInternalSelection(" + o + ")");
                }
                this.showInternalSelection(o);
            }
        }
    }

    protected void externalSelectionChanged(IWorkbenchPart part, Object selection, TraceInteractionUpdate update) {
        if (TraceSDPlugin.debugEvents) {
            TraceSDPlugin.debugTraceEvents("External selection from " + part + " is " + selection);
        }
        if (selection instanceof IStructuredSelection) {
            if (TraceSDPlugin.debugEvents) {
                TraceSDPlugin.debugTraceEvents("IStructuredSelection");
            }
            IStructuredSelection iss = (IStructuredSelection)selection;
            Iterator i = iss.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                this.externalSelectionChanged(part, o, update);
            }
        } else if (this.externalExtendedSelectionChanged(part, selection, update)) {
            // empty if block
        }
    }

    protected abstract boolean externalExtendedSelectionChanged(IWorkbenchPart var1, Object var2, TraceInteractionUpdate var3);

    protected abstract void finishExternalExtendedSelection(TraceInteractionUpdate var1);

    public boolean isNodeSupported(int nodeType) {
        switch (nodeType) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    public abstract String getNodeName(int var1);

    public boolean find(Criteria toSearch_) {
        if (this.frame == null) {
            return false;
        }
        if (this.findResults == null || this.findCriteria == null || !this.findCriteria.equals(toSearch_)) {
            List selection;
            this.findResults = new ArrayList();
            this.findCriteria = toSearch_;
            if (this.findCriteria.isLifeLineSelected()) {
                int i = 0;
                while (i < this.frame.lifeLinesCount()) {
                    if (TIUtils.matchCriteria(this.frame.getLifeline(i).getName(), this.findCriteria)) {
                        this.findResults.add(this.frame.getLifeline(i));
                    }
                    ++i;
                }
            }
            ArrayList<Object> msgs = new ArrayList<Object>();
            if (this.findCriteria.isSyncMessageSelected()) {
                int i = 0;
                while (i < this.frame.syncMessageCount()) {
                    if (TIUtils.matchCriteria(this.frame.getSyncMessage(i).getName(), this.findCriteria)) {
                        msgs.add(this.frame.getSyncMessage(i));
                    }
                    ++i;
                }
                int i2 = 0;
                while (i2 < this.frame.syncMessageReturnCount()) {
                    if (TIUtils.matchCriteria(this.frame.getSyncMessageReturn(i2).getName(), this.findCriteria)) {
                        msgs.add(this.frame.getSyncMessageReturn(i2));
                    }
                    ++i2;
                }
            }
            if (msgs.size() > 0) {
                Object[] temp = msgs.toArray();
                Arrays.sort(temp, new DateComparator());
                this.findResults.addAll(Arrays.asList(temp));
            }
            this.currentFindIndex = (selection = this.view.getSDWidget().getSelection()) != null && selection.size() == 1 ? this.findResults.indexOf(selection.get(0)) + 1 : 0;
        } else {
            ++this.currentFindIndex;
        }
        if (this.findResults.size() > this.currentFindIndex) {
            GraphNode current = (GraphNode)this.findResults.get(this.currentFindIndex);
            this.view.getSDWidget().moveTo(current);
            return true;
        }
        return this.notFoundYet(this.findCriteria);
    }

    public void cancel() {
        this.clearFindInternals();
    }

    public void supplementCoolbarContent(IActionBars bar) {
        OpenExecutionStatisticAction openExec = new OpenExecutionStatisticAction();
        openExec.setText(TraceSDPlugin.getResourceString("SHOW_EXEC_STAT"));
        openExec.setToolTipText(TraceSDPlugin.getResourceString("SHOW_EXEC_STAT"));
        openExec.setId(ACTIONS_SHOWSTATTABLE);
        openExec.setImageDescriptor(TraceSDPlugin.getResourceImageDescriptor("exec_flow_view.gif"));
        bar.getMenuManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)openExec);
        bar.getToolBarManager().appendToGroup("UML2SD_OTHER_COMMANDS", (IAction)openExec);
    }

    public abstract boolean notFoundYet(Criteria var1);
}

