/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.internal.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import org.eclipse.hyades.logging.core.Guid;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.CompletionException;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;
import org.eclipse.hyades.logging.events.cbe.impl.TemplateContentHandlerImpl;

public class RuntimeTemplateContentHandlerImpl
extends TemplateContentHandlerImpl {
    private static String localHostIP = null;

    public void completeEvent(CommonBaseEvent event) throws CompletionException {
        if (event != null && !event.isComplete()) {
            MsgDataElement msgDataElement;
            ComponentIdentification sourceComponetId;
            super.completeEvent(event);
            if (event.getGlobalInstanceId() == null) {
                event.setGlobalInstanceId(Guid.generate());
            }
            if (!event.isSetCreationTime()) {
                event.setCreationTimeAsLong(System.currentTimeMillis());
            }
            if ((sourceComponetId = event.getSourceComponentId()) != null) {
                if (sourceComponetId.getThreadId() == null) {
                    sourceComponetId.setThreadId(Thread.currentThread().getName());
                }
                if (sourceComponetId.getLocation() == null && sourceComponetId.getLocationType() == null) {
                    sourceComponetId.setLocation(localHostIP);
                    sourceComponetId.setLocationType("IPV4");
                }
            }
            if ((msgDataElement = event.getMsgDataElement()) != null && msgDataElement.getMsgLocale() == null) {
                Locale defaultLocale = Locale.getDefault();
                msgDataElement.setMsgLocale(defaultLocale.getLanguage().concat("-").concat(defaultLocale.getCountry()));
            }
        }
    }

    static {
        try {
            localHostIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException u) {
            localHostIP = "127.0.0.1";
        }
    }
}

