/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.util.GridUtil;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class LogSelectionDialog
extends SelectionDialog {
    protected Object selection;

    public LogSelectionDialog(Shell parentShell) {
        super(parentShell);
        this.setTitle(AcadEditorPlugin.getPlugin().getString("STR_SEL_DLG_TITLE"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridData data = GridUtil.createFill();
        data.widthHint = 300;
        data.heightHint = 400;
        dialogArea.setLayoutData((Object)data);
        dialogArea.setLayout((Layout)new GridLayout());
        Tree tree = new Tree(dialogArea, 2052);
        tree.setLayoutData((Object)GridUtil.createFill());
        final TreeViewer selectionViewer = new TreeViewer(tree);
        selectionViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        selectionViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        selectionViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        selectionViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                LogSelectionDialog.this.setSelection(selection.getFirstElement());
            }
        });
        selectionViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object item = ((IStructuredSelection)selection).getFirstElement();
                    if (selectionViewer.getExpandedState(item)) {
                        selectionViewer.collapseToLevel(item, 1);
                    } else {
                        selectionViewer.expandToLevel(item, 1);
                    }
                }
            }
        });
        return dialogArea;
    }

    public Object getSelection() {
        return this.selection;
    }

    public void setSelection(Object object) {
        this.selection = object;
    }
}

