/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterConfigType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.OutputterType;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.provider.OutputterConfigTypeItemProvider;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.provider.OutputterItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.util.GridUtil;
import org.eclipse.hyades.logging.adapter.ui.internal.util.IDetails;
import org.eclipse.hyades.logging.adapter.ui.internal.util.RuleBuilderWidgetFactory;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class OutputterSection
extends Composite
implements IDetails,
ModifyListener,
SelectionListener,
INotifyChangedListener {
    protected CCombo typeCombo;
    protected Label uniqueIDText;
    protected Text descriptionText;
    protected boolean isDisplaying;
    protected OutputterConfigType currentSelection;
    protected OutputterConfigTypeItemProvider itemProvider;
    protected OutputterItemProviderAdapterFactory itemFactory = new OutputterItemProviderAdapterFactory();

    public OutputterSection(RuleBuilderWidgetFactory factory, Composite composite, int style) {
        super(composite, style);
        GridLayout detailLayout = new GridLayout();
        detailLayout.numColumns = 2;
        detailLayout.verticalSpacing = 5;
        this.setLayout((Layout)detailLayout);
        this.setLayoutData(GridUtil.createFill());
        Label label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_Outputter_Type"), 0);
        this.typeCombo = factory.createCombo(this, 8);
        this.typeCombo.setLayoutData((Object)new GridData(768));
        this.typeCombo.setToolTipText(AcadEditorPlugin.getPlugin().getString("SINCE_1_3"));
        this.initializeTypeCombo();
        label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_OUT_DESCR"), 0);
        this.descriptionText = factory.createText(this, "", 0);
        this.descriptionText.setLayoutData((Object)new GridData(768));
        label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_OUT_ID"), 0);
        this.uniqueIDText = factory.createLabel(this, "", 0);
        this.uniqueIDText.setLayoutData((Object)new GridData(768));
        label = factory.createLabel(this, "", 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.descriptionText.addModifyListener((ModifyListener)this);
        this.typeCombo.addSelectionListener((SelectionListener)this);
        this.itemProvider = (OutputterConfigTypeItemProvider)this.itemFactory.createOutputterConfigTypeAdapter();
        this.itemProvider.addListener(this);
    }

    protected void initializeTypeCombo() {
        int i = 0;
        while (i < OutputterType.VALUES.size()) {
            this.typeCombo.add(((OutputterType)OutputterType.VALUES.get(i)).getName());
            ++i;
        }
    }

    public void display(EObject object) {
        if (object != null) {
            AcadGuiModelManager.setCurrentModel((ContextInstanceType)object.eContainer());
        }
        if (this.currentSelection == object) {
            return;
        }
        if (this.uniqueIDText.isFocusControl() || this.descriptionText.isFocusControl()) {
            return;
        }
        this.currentSelection = (OutputterConfigType)object;
        this.isDisplaying = true;
        this.descriptionText.setText(this.currentSelection.getDescription() == null ? "" : this.currentSelection.getDescription());
        this.uniqueIDText.setText(this.currentSelection.getUniqueID() == null ? "" : this.currentSelection.getUniqueID());
        this.typeCombo.select(OutputterType.VALUES.indexOf(this.currentSelection.getType()));
        this.isDisplaying = false;
    }

    public boolean updateCurrentSelection(EObject currentSelection) {
        this.currentSelection = (OutputterConfigType)currentSelection;
        this.currentSelection.setUniqueID(this.uniqueIDText.getText());
        this.currentSelection.setDescription(this.descriptionText.getText());
        return false;
    }

    public void setFocusToText() {
        this.descriptionText.setFocus();
        this.descriptionText.selectAll();
    }

    public void modifyText(ModifyEvent e) {
        String text;
        if (this.isDisplaying || this.currentSelection == null) {
            return;
        }
        if (e.getSource() == this.descriptionText) {
            String text2 = this.descriptionText.getText();
            if (!text2.equals(this.currentSelection.getDescription())) {
                if (text2.length() == 0 && this.currentSelection.getDescription() == null) {
                    return;
                }
                IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, OutputterConfigTypeItemProvider.DESCRIPTION);
                if (descriptor != null) {
                    descriptor.setPropertyValue((Object)this.currentSelection, (Object)text2);
                }
            }
        } else if (e.getSource() == this.uniqueIDText && !(text = this.uniqueIDText.getText()).equals(this.currentSelection.getUniqueID())) {
            if (text.length() == 0 && this.currentSelection.getUniqueID() == null) {
                return;
            }
            IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, OutputterConfigTypeItemProvider.UNIQUE_ID);
            if (descriptor != null) {
                descriptor.setPropertyValue((Object)this.currentSelection, (Object)text);
            }
        }
    }

    public void dispose() {
        this.itemFactory = null;
        this.itemProvider = null;
    }

    public void notifyChanged(Notification notification) {
        Object obj = notification.getNotifier();
        if (obj == null || obj != this.currentSelection) {
            return;
        }
        this.display((EObject)this.currentSelection);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        String sel;
        if (e.getSource() == this.typeCombo && !(sel = this.typeCombo.getText()).equals(this.currentSelection.getType().getName())) {
            IItemPropertyDescriptor descriptor = this.itemProvider.getPropertyDescriptor(this.currentSelection, OutputterConfigTypeItemProvider.TYPE);
            if (descriptor != null) {
                descriptor.setPropertyValue((Object)this.currentSelection, (Object)OutputterType.get((String)sel));
            }
            this.currentSelection.setType(OutputterType.get((String)sel));
        }
    }
}

