/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui;

import java.net.URL;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.ui.HyadesUIImages;
import org.eclipse.hyades.ui.adapter.HyadesAdapterFactory;
import org.eclipse.hyades.ui.internal.extension.NavigatorExtensionUtil;
import org.eclipse.hyades.ui.internal.util.ResourceBundleManager;
import org.eclipse.hyades.ui.util.ILogger;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class HyadesUIPlugin
extends AbstractUIPlugin {
    public static final String EP_EDITOR_EXTENSIONS = "editorExtensions";
    public static final String EP_ANALYZER_EXTENSIONS = "analyzerExtensions";
    public static final String EP_REPORT_EXTENSIONS = "reportExtensions";
    public static final String EP_TYPE_DESCRIPTIONS = "typeDescriptions";
    public static final String EP_TYPE_VALIDATORS = "typeValidators";
    public static final String EP_SAMPLE_WIZARD = "sampleWizards";
    public static final String EP_NAVIGATOR_EXTENSIONS = "navigatorExtensions";
    public static final String PLUGIN_ID = "org.eclipse.hyades.ui";
    private static HyadesUIPlugin instance;
    private ILogger logger;
    private ResourceBundleManager resourceBundleManager;
    private ResourceBundle resourceBundle;
    static /* synthetic */ Class class$org$eclipse$hyades$ui$internal$logicalfolder$LogicalFolder;

    public HyadesUIPlugin() {
        instance = this;
    }

    public static HyadesUIPlugin getInstance() {
        return instance;
    }

    public void start(BundleContext context) throws Exception {
        this.resourceBundleManager = new ResourceBundleManager();
        this.resourceBundleManager.add(this.getResourceBundle());
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)HyadesAdapterFactory.INSTANCE, class$org$eclipse$hyades$ui$internal$logicalfolder$LogicalFolder == null ? (class$org$eclipse$hyades$ui$internal$logicalfolder$LogicalFolder = HyadesUIPlugin.class$("org.eclipse.hyades.ui.internal.logicalfolder.LogicalFolder")) : class$org$eclipse$hyades$ui$internal$logicalfolder$LogicalFolder);
        super.start(context);
        Runnable operation = new Runnable(){

            public void run() {
                try {
                    HyadesUIImages.INSTANCE.initialize(new URL(HyadesUIPlugin.this.getBundle().getEntry("/"), "icons/full/"), HyadesUIPlugin.this.getImageRegistry());
                }
                catch (Exception e) {
                    HyadesUIPlugin.logError(e);
                }
            }
        };
        if (Display.getCurrent() == Display.getDefault()) {
            operation.run();
        } else {
            Display.getDefault().asyncExec(operation);
        }
    }

    public void stop(BundleContext context) throws Exception {
        NavigatorExtensionUtil.disposeAll();
        this.resourceBundleManager.dispose();
        instance = null;
        this.savePluginPreferences();
        this.logger = null;
        Platform.getAdapterManager().unregisterAdapters((IAdapterFactory)HyadesAdapterFactory.INSTANCE);
        HyadesAdapterFactory.INSTANCE.dispose();
        super.stop(context);
    }

    public static ILogger getLogger() {
        if (HyadesUIPlugin.instance.logger == null) {
            HyadesUIPlugin.instance.logger = new ILogger(){

                public void logError(Throwable throwable) {
                    this.logError(throwable);
                }

                public void logError(String text) {
                    this.logError(text);
                }

                public void logInfo(String text) {
                    this.logInfo(text);
                }
            };
        }
        return HyadesUIPlugin.instance.logger;
    }

    public static String getID() {
        return PLUGIN_ID;
    }

    public static void logError(Throwable throwable) {
        Status status = new Status(1, HyadesUIPlugin.getID(), 0, throwable.toString(), throwable);
        HyadesUIPlugin.getInstance().getLog().log((IStatus)status);
    }

    public static void logError(String text) {
        HyadesUIPlugin.logError(new Throwable(text));
    }

    public static void logInfo(String text) {
        Status status = new Status(3, HyadesUIPlugin.getID(), 0, text, new Throwable(text));
        HyadesUIPlugin.getInstance().getLog().log((IStatus)status);
    }

    public ResourceBundle getResourceBundle() {
        block2: {
            if (this.resourceBundle != null) break block2;
            try {
                this.resourceBundle = Platform.getResourceBundle((Bundle)Platform.getBundle((String)PLUGIN_ID));
            }
            catch (Exception e) {
                this.resourceBundle = null;
            }
        }
        return this.resourceBundle;
    }

    public static String getString(String key) throws NullPointerException, MissingResourceException {
        return HyadesUIPlugin.instance.resourceBundleManager.getString(key);
    }

    public static String getString(String key, String arg) throws NullPointerException, MissingResourceException {
        return HyadesUIPlugin.instance.resourceBundleManager.getString(key, arg);
    }

    public static String getString(String key, String[] args) throws NullPointerException, MissingResourceException {
        return HyadesUIPlugin.instance.resourceBundleManager.getString(key, args);
    }

    public boolean openPerspectiveSwitchDialog(Shell shell, String perspectiveId, IPreferenceStore preferenceStore, String preferenceKey, String message) {
        if (this.isCurrentPerspective(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), perspectiveId)) {
            return false;
        }
        String perspectiveName = this.getPerspectiveLabel(perspectiveId);
        if (perspectiveName == null) {
            return false;
        }
        String preferenceValue = preferenceStore.getString(preferenceKey);
        if (preferenceValue == null || preferenceValue.length() == 0) {
            preferenceValue = "prompt";
            preferenceStore.setValue(preferenceKey, preferenceValue);
        }
        boolean saveAndChange = false;
        if ("prompt".equals(preferenceValue)) {
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)this.getResourceBundle().getString("CONFIRM_PERSP_SWITCH"), (String)MessageFormat.format(message, perspectiveName), null, (boolean)false, (IPreferenceStore)preferenceStore, (String)preferenceKey);
            boolean bl = saveAndChange = dialog.getReturnCode() == 2;
        }
        if (!this.getContributions(perspectiveId)) {
            return false;
        }
        preferenceValue = preferenceStore.getString(preferenceKey);
        if ("always".equals(preferenceValue)) {
            return true;
        }
        return saveAndChange && !"never".equals(preferenceValue);
    }

    private boolean isCurrentPerspective(IWorkbenchWindow window, String perspectiveId) {
        IPerspectiveDescriptor perspectiveDescriptor;
        IWorkbenchPage page;
        boolean isCurrent = false;
        if (window != null && (page = window.getActivePage()) != null && (perspectiveDescriptor = page.getPerspective()) != null) {
            isCurrent = perspectiveId.equals(perspectiveDescriptor.getId());
        }
        return isCurrent;
    }

    private String getPerspectiveLabel(String perspectiveId) {
        IPerspectiveDescriptor newPerspective = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(perspectiveId);
        if (newPerspective == null) {
            return null;
        }
        return newPerspective.getLabel();
    }

    private boolean getContributions(String perspectiveId) {
        IPerspectiveRegistry reg = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor finalPersp = reg.findPerspectiveWithId(perspectiveId);
        if (finalPersp != null && finalPersp instanceof IPluginContribution) {
            HashSet enabledIds;
            IWorkbenchActivitySupport workbenchActivitySupport;
            IActivityManager activityManager;
            IIdentifier identifier;
            Set idActivities;
            IPluginContribution contribution = (IPluginContribution)finalPersp;
            if (contribution.getPluginId() != null && !(idActivities = (identifier = (activityManager = (workbenchActivitySupport = PlatformUI.getWorkbench().getActivitySupport()).getActivityManager()).getIdentifier(WorkbenchActivityHelper.createUnifiedId((IPluginContribution)contribution))).getActivityIds()).isEmpty() && (enabledIds = new HashSet(activityManager.getEnabledActivityIds())).addAll(idActivities)) {
                workbenchActivitySupport.setEnabledActivityIds(enabledIds);
            }
        } else {
            HyadesUIPlugin.logError("Unable to find perspective " + perspectiveId);
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

