/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.preference;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.extension.AssociationDescriptorLabelProvider;
import org.eclipse.hyades.ui.extension.IAssociationDescriptor;
import org.eclipse.hyades.ui.extension.IAssociationMapping;
import org.eclipse.hyades.ui.internal.util.ChooseElementDialog;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public abstract class AssociationMappingPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
Listener {
    private IWorkbench workbench;
    private IAssociationMapping selectionMapping;
    private Table selectionTable;
    private TabFolder detailTabFolder;
    private Map mappingByTable = new HashMap();
    private Button addAssociationButton;
    private Button removeAssociationButton;
    private Button defaultAssociationButton;

    public AssociationMappingPreferencePage() {
        this.noDefaultAndApplyButton();
    }

    public void init(IWorkbench workbench) {
        this.workbench = workbench;
    }

    protected IWorkbench getWorkbench() {
        return this.workbench;
    }

    public abstract IAssociationMapping[] getDetailMappings();

    protected abstract IAssociationMapping getSelectionAssociationMapping();

    protected abstract String getLabel(IAssociationMapping var1);

    public abstract boolean performCancel();

    public abstract boolean performOk();

    public void dispose() {
        if (this.mappingByTable != null) {
            this.mappingByTable.clear();
        }
        this.selectionMapping = null;
        super.dispose();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.beforeIsPresented();
    }

    protected void beforeIsPresented() {
    }

    protected Control createContents(Composite parent) {
        IAssociationMapping[] mappings;
        Composite pageComponent = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        pageComponent.setLayout((Layout)gridLayout);
        pageComponent.setLayoutData((Object)GridDataUtil.createFill());
        IAssociationMapping mapping = this.getSelectionAssociationMapping();
        if (mapping != null && mapping.associationDescriptors().length > 0) {
            this.selectionMapping = mapping;
            Label label = new Label(pageComponent, 16384);
            label.setText(this.getLabel(this.selectionMapping));
            this.selectionTable = new Table(pageComponent, 67588);
            this.selectionTable.addListener(13, (Listener)this);
            this.selectionTable.addListener(14, (Listener)this);
        }
        if ((mappings = this.getDetailMappings()).length > 0) {
            if (this.selectionTable != null) {
                GridData gridData = new GridData(768);
                gridData.heightHint = this.selectionTable.getItemHeight() * (UIUtil.availableRows(parent) / 16);
                this.selectionTable.setLayoutData((Object)gridData);
                Label spacer = new Label(pageComponent, 16384);
                GridData data = new GridData();
                data.heightHint = 1;
                spacer.setLayoutData((Object)data);
            }
            this.createDetailControl(pageComponent, mappings);
        } else if (this.selectionTable != null) {
            this.selectionTable.setLayoutData((Object)GridDataUtil.createFill());
        }
        if (this.populateSelection()) {
            this.selectionTable.select(0);
            Event event = new Event();
            event.widget = this.selectionTable;
            event.type = 13;
            this.selectionTable.notifyListeners(13, event);
        } else {
            this.populateDetails();
        }
        WorkbenchHelp.setHelp((Control)parent, (String)(HyadesUIPlugin.getID() + ".asst0001"));
        WorkbenchHelp.setHelp((Control)this.selectionTable, (String)(HyadesUIPlugin.getID() + ".asst0001"));
        WorkbenchHelp.setHelp((Control)this.defaultAssociationButton, (String)(HyadesUIPlugin.getID() + ".asst0003"));
        WorkbenchHelp.setHelp((Control)this.addAssociationButton, (String)(HyadesUIPlugin.getID() + ".asst0002"));
        WorkbenchHelp.setHelp((Control)this.removeAssociationButton, (String)(HyadesUIPlugin.getID() + ".asst0004"));
        WorkbenchHelp.setHelp((Control)this.detailTabFolder, (String)(HyadesUIPlugin.getID() + ".asst0005"));
        return pageComponent;
    }

    protected void createSelectionControl(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(this.getLabel(this.selectionMapping));
        this.selectionTable = new Table(parent, 67588);
        this.selectionTable.addListener(13, (Listener)this);
        this.selectionTable.addListener(14, (Listener)this);
        GridData gridData = new GridData(768);
        gridData.heightHint = this.selectionTable.getItemHeight() * (UIUtil.availableRows(parent) / 16);
        this.selectionTable.setLayoutData((Object)gridData);
    }

    protected void createDetailControl(Composite parent, IAssociationMapping[] mappings) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)GridDataUtil.createFill());
        this.detailTabFolder = new TabFolder(composite, 128);
        this.detailTabFolder.setLayoutData((Object)GridDataUtil.createFill());
        int i = 0;
        int maxi = mappings.length;
        while (i < maxi) {
            String label = this.getLabel(mappings[i]);
            if (label == null) {
                label = "";
            }
            Table table = this.createDetailTable((Composite)this.detailTabFolder, mappings[i]);
            TableColumn column = new TableColumn(table, 16384, 0);
            this.detailTabFolder.addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent e) {
                }

                public void controlResized(ControlEvent e) {
                    Control[] children = AssociationMappingPreferencePage.this.detailTabFolder.getChildren();
                    int i = 0;
                    while (i < children.length) {
                        if (children[i] instanceof Table) {
                            Table table = (Table)children[i];
                            table.setRedraw(false);
                            TableColumn column = table.getColumn(0);
                            if (column != null) {
                                column.setWidth(((AssociationMappingPreferencePage)AssociationMappingPreferencePage.this).detailTabFolder.getClientArea().width - 5);
                            }
                            table.setRedraw(true);
                            table.update();
                        }
                        ++i;
                    }
                }
            });
            this.mappingByTable.put(table, mappings[i]);
            TabItem tabItem = new TabItem(this.detailTabFolder, 0);
            tabItem.setText(label);
            tabItem.setControl((Control)table);
            ++i;
        }
        this.detailTabFolder.setSelection(0);
        this.createDetailButtonsControl(composite);
    }

    protected Table createDetailTable(Composite parent, IAssociationMapping associationMapping) {
        Table table = new Table(parent, 67588);
        table.setLayoutData((Object)new GridData(1808));
        table.addListener(13, (Listener)this);
        table.addListener(14, (Listener)this);
        return table;
    }

    protected void createDetailButtonsControl(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        buttonComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        buttonComposite.setLayoutData((Object)gridData);
        new Label(buttonComposite, 16384);
        if (this.selectionTable != null) {
            this.addAssociationButton = new Button(buttonComposite, 8);
            this.addAssociationButton.setText(HyadesUIPlugin.getString("BTN_ADD"));
            this.addAssociationButton.addListener(13, (Listener)this);
            this.setButtonLayoutData(this.addAssociationButton);
            this.removeAssociationButton = new Button(buttonComposite, 8);
            this.removeAssociationButton.setText(HyadesUIPlugin.getString("BTN_REMOVE"));
            this.removeAssociationButton.addListener(13, (Listener)this);
            this.setButtonLayoutData(this.removeAssociationButton);
        }
        this.defaultAssociationButton = new Button(buttonComposite, 8);
        this.defaultAssociationButton.setText(HyadesUIPlugin.getString("BTN_DEFAULT"));
        this.defaultAssociationButton.addListener(13, (Listener)this);
        this.setButtonLayoutData(this.defaultAssociationButton);
    }

    protected boolean populateSelection() {
        if (this.selectionMapping == null) {
            return false;
        }
        this.populate(this.selectionTable, this.selectionMapping.associationDescriptors(), null);
        return true;
    }

    protected boolean populateDetails() {
        if (this.mappingByTable == null) {
            return false;
        }
        IAssociationDescriptor descriptor = this.getAssociationDescriptor(this.selectionTable);
        Iterator iterator = this.mappingByTable.keySet().iterator();
        while (iterator.hasNext()) {
            this.populateDetail(descriptor, (Table)iterator.next());
        }
        return true;
    }

    protected void populateDetail(IAssociationDescriptor selectionDescriptor, Table table) {
        String[] types = null;
        if (selectionDescriptor != null) {
            types = selectionDescriptor.types();
        }
        IAssociationMapping mapping = (IAssociationMapping)this.mappingByTable.get(table);
        IAssociationDescriptor[] descriptors = null;
        IAssociationDescriptor defaultDescriptor = null;
        if (types == null || types.length == 0) {
            descriptors = mapping.getAssociationDescriptors();
            defaultDescriptor = mapping.getDefaultAssociationDescriptor();
        } else {
            HashSet<IAssociationDescriptor> descriptorSet = new HashSet<IAssociationDescriptor>();
            int i = 0;
            int maxi = types.length;
            while (i < maxi) {
                descriptorSet.addAll(Arrays.asList(mapping.getAssociationDescriptors(types[i])));
                ++i;
            }
            descriptors = descriptorSet.toArray(new IAssociationDescriptor[descriptorSet.size()]);
            defaultDescriptor = mapping.getDefaultAssociationDescriptor(types[0]);
        }
        this.populate(table, descriptors, defaultDescriptor);
    }

    protected void populate(Table table, IAssociationDescriptor[] associationDescriptors, IAssociationDescriptor defaultAssociationDescriptor) {
        Arrays.sort(associationDescriptors, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 != null && o2 != null) {
                    String name1 = ((IAssociationDescriptor)o1).getName();
                    String name2 = ((IAssociationDescriptor)o2).getName();
                    if (name1 != null && name2 != null) {
                        return name1.compareTo(name2);
                    }
                    return o1.hashCode() - o2.hashCode();
                }
                return 0;
            }
        });
        table.removeAll();
        TableItem defaultItem = null;
        if (defaultAssociationDescriptor != null) {
            defaultItem = new TableItem(table, 0);
        }
        int i = 0;
        int maxi = associationDescriptors.length;
        while (i < maxi) {
            TableItem item = null;
            item = associationDescriptors[i] == defaultAssociationDescriptor ? defaultItem : new TableItem(table, 0);
            item.setData((Object)associationDescriptors[i]);
            Image image = associationDescriptors[i].getImage();
            if (image != null) {
                item.setImage(image);
            }
            String label = this.getLabel(associationDescriptors[i]);
            if (item == defaultItem) {
                label = HyadesUIPlugin.getString("DEFAULT_ASSOC", label);
            }
            item.setText(label);
            ++i;
        }
    }

    protected IAssociationDescriptor getAssociationDescriptor(Table table) {
        if (table == null || table.getSelectionCount() != 1) {
            return null;
        }
        return (IAssociationDescriptor)table.getSelection()[0].getData();
    }

    protected String getLabel(IAssociationDescriptor associationDescriptor) {
        if (associationDescriptor != null) {
            String label = associationDescriptor.getName();
            if (label != null) {
                return label;
            }
            label = associationDescriptor.getId();
            if (label != null) {
                return label;
            }
            String[] types = associationDescriptor.types();
            if (types.length == 1) {
                return types[0];
            }
        }
        return "";
    }

    public void handleEvent(Event event) {
        if (event.widget == this.selectionTable) {
            this.populateDetails();
        } else if (event.widget == this.addAssociationButton) {
            this.addAssociation((Table)this.detailTabFolder.getSelection()[0].getControl());
        } else if (event.widget == this.removeAssociationButton) {
            this.removeAssociation((Table)this.detailTabFolder.getSelection()[0].getControl());
        } else if (event.widget == this.defaultAssociationButton) {
            this.setDefaultAssociation((Table)this.detailTabFolder.getSelection()[0].getControl());
        }
        this.updateEnabledState();
    }

    protected void addAssociation(Table detailTable) {
        IAssociationDescriptor selectionDescriptor = this.getAssociationDescriptor(this.selectionTable);
        if (selectionDescriptor == null) {
            return;
        }
        HashSet<IAssociationDescriptor> descriptors = new HashSet<IAssociationDescriptor>();
        IAssociationMapping mapping = (IAssociationMapping)this.mappingByTable.get(detailTable);
        String[] types = selectionDescriptor.types();
        int i = 0;
        int maxi = types.length;
        while (i < maxi) {
            descriptors.addAll(Arrays.asList(mapping.getAvoidedAssociationDescriptors(types[i])));
            ++i;
        }
        IAssociationDescriptor descriptor = (IAssociationDescriptor)ChooseElementDialog.open(this.getShell(), HyadesUIPlugin.getString("DLG_ADD"), descriptors.toArray(), new AssociationDescriptorLabelProvider());
        if (descriptor != null) {
            int i2 = 0;
            int maxi2 = types.length;
            while (i2 < maxi2) {
                mapping.removeFromAvoidedSet(types[i2], descriptor);
                ++i2;
            }
        }
        this.populateDetail(selectionDescriptor, detailTable);
    }

    protected void removeAssociation(Table detailTable) {
        IAssociationDescriptor descriptor = this.getAssociationDescriptor(detailTable);
        if (descriptor == null) {
            return;
        }
        IAssociationDescriptor selectionDescriptor = this.getAssociationDescriptor(this.selectionTable);
        if (selectionDescriptor == null) {
            return;
        }
        int selectionIndex = detailTable.getSelectionIndex();
        IAssociationMapping mapping = (IAssociationMapping)this.mappingByTable.get(detailTable);
        String[] types = selectionDescriptor.types();
        int i = 0;
        int maxi = types.length;
        while (i < maxi) {
            mapping.addToAvoidedSet(types[i], descriptor);
            ++i;
        }
        this.populateDetail(selectionDescriptor, detailTable);
        if (selectionIndex == detailTable.getItemCount()) {
            --selectionIndex;
        }
        detailTable.select(selectionIndex);
    }

    protected void setDefaultAssociation(Table detailTable) {
        IAssociationDescriptor descriptor = this.getAssociationDescriptor(detailTable);
        if (descriptor == null) {
            return;
        }
        IAssociationMapping mapping = (IAssociationMapping)this.mappingByTable.get(detailTable);
        IAssociationDescriptor selectionDescriptor = this.getAssociationDescriptor(this.selectionTable);
        IAssociationDescriptor[] descriptors = null;
        if (selectionDescriptor == null || selectionDescriptor.types().length == 0) {
            mapping.setDefaultAssociationDescriptor(descriptor);
            descriptors = mapping.getAssociationDescriptors();
        } else {
            String[] types = selectionDescriptor.types();
            HashSet<IAssociationDescriptor> descriptorSet = new HashSet<IAssociationDescriptor>();
            int i = 0;
            int maxi = types.length;
            while (i < maxi) {
                mapping.setDefaultAssociationDescriptor(types[i], descriptor);
                descriptorSet.addAll(Arrays.asList(mapping.getAssociationDescriptors(types[i])));
                ++i;
            }
            descriptors = descriptorSet.toArray(new IAssociationDescriptor[descriptorSet.size()]);
        }
        this.populate(detailTable, descriptors, descriptor);
        detailTable.select(0);
    }

    protected void updateEnabledState() {
        IAssociationDescriptor selectionDescriptor = this.getAssociationDescriptor(this.selectionTable);
        IAssociationDescriptor detailDescriptor = null;
        Table detailTable = null;
        if (this.detailTabFolder != null && this.detailTabFolder.getSelection() != null) {
            detailTable = (Table)this.detailTabFolder.getSelection()[0].getControl();
            detailDescriptor = this.getAssociationDescriptor(detailTable);
        }
        if (this.addAssociationButton != null) {
            this.addAssociationButton.setEnabled(this.selectionMapping == null || selectionDescriptor != null);
        }
        if (this.removeAssociationButton != null) {
            this.removeAssociationButton.setEnabled(detailDescriptor != null && detailTable.getItemCount() > 1);
        }
        if (this.defaultAssociationButton != null) {
            this.defaultAssociationButton.setEnabled(detailDescriptor != null && detailTable.getSelectionIndex() != 0);
        }
    }
}

