/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.ui.internal.util;

import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.util.UIUtil;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.ui.actions.OpenAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class OpenJavaSource {
    private static final String JAVA_PERSPECTIVE_ID = "org.eclipse.jdt.ui.JavaPerspective";

    public static boolean openSource(String pattern, int javaType, IJavaSearchScope searchScope, boolean switchToJavaPerspective) {
        OpenSourceJavaSearchResultRequestor requestor = OpenJavaSource.getSearchResults(pattern, javaType, searchScope);
        if (requestor != null && requestor.getNumberOfMatches() > 0) {
            return OpenJavaSource.openWbSource(pattern, requestor, switchToJavaPerspective);
        }
        return false;
    }

    public static IFile getSourceFile(String pattern, int javaType, IJavaSearchScope searchScope) {
        OpenSourceJavaSearchResultRequestor requestor = OpenJavaSource.getSearchResults(pattern, javaType, searchScope);
        if (requestor != null) {
            return OpenSourceJavaSearchResultRequestor.getFile(requestor.getMatchForPattern(pattern));
        }
        return null;
    }

    private static String fixPatternForInnerClasses(String pattern, OpenSourceJavaSearchResultRequestor requestor, int javaType) {
        int bIdx = pattern.indexOf("(");
        int idx = bIdx >= 0 ? pattern.substring(0, bIdx).indexOf("$") : pattern.indexOf("$");
        if (idx >= 0) {
            requestor.setInnerClassType(new InnerClassType(pattern.substring(idx + 1)));
            pattern = pattern.substring(0, idx);
        }
        return pattern;
    }

    private static SearchPattern getSearchPattern(String pattern, int javaType, OpenSourceJavaSearchResultRequestor requestor) {
        if (pattern != null && !"".equals(pattern)) {
            pattern = OpenJavaSource.fixPatternForInnerClasses(pattern, requestor, javaType);
            return SearchPattern.createPattern((String)pattern, (int)(requestor.hasInnerClassType() ? 0 : javaType), (int)0, (int)8);
        }
        return null;
    }

    private static IJavaSearchScope getJavaSearchScope(IJavaSearchScope searchScope) {
        if (searchScope == null) {
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            IJavaElement[] javaElements = new IJavaElement[projects.length];
            int i = 0;
            while (i < projects.length) {
                javaElements[i] = JavaCore.create((IProject)projects[i]);
                ++i;
            }
            searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])javaElements, (boolean)false);
        }
        return searchScope;
    }

    private static OpenSourceJavaSearchResultRequestor getSearchResults(String pattern, int javaType, IJavaSearchScope searchScope) {
        OpenSourceJavaSearchResultRequestor requestor = new OpenSourceJavaSearchResultRequestor();
        SearchPattern searchPattern = OpenJavaSource.getSearchPattern(pattern, javaType, requestor);
        if (searchPattern != null) {
            SearchEngine searchEngine = new SearchEngine();
            try {
                searchEngine.search(searchPattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, OpenJavaSource.getJavaSearchScope(searchScope), (SearchRequestor)requestor, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                // empty catch block
            }
            return requestor;
        }
        return null;
    }

    private static IJavaElement getJavaElementToOpen(String pattern, OpenSourceJavaSearchResultRequestor requestor) {
        SearchMatch match = requestor.getMatchForPattern(pattern);
        Object je = (IJavaElement)match.getElement();
        if (requestor.hasInnerClassType()) {
            InnerClassType innerClassType = requestor.getInnerClassType();
            IType innerClass = OpenJavaSource.getInnerType(je, innerClassType);
            IMethod method = null;
            while (innerClassType.hasChildClass()) {
                innerClassType = innerClassType.getChildClass();
                innerClass = OpenJavaSource.getInnerType((IJavaElement)innerClass, innerClassType);
            }
            if (innerClassType.hasMethod()) {
                method = OpenJavaSource.getMethodFromType(innerClass, innerClassType.getMethod());
            }
            je = method != null ? method : (innerClass != null ? innerClass : null);
        }
        return je;
    }

    private static boolean openWbSource(String pattern, OpenSourceJavaSearchResultRequestor requestor, boolean switchToJavaPerspective) {
        IJavaElement je = OpenJavaSource.getJavaElementToOpen(pattern, requestor);
        if (je == null) {
            return false;
        }
        IWorkbenchPage page = null;
        page = switchToJavaPerspective ? OpenJavaSource.getJavaActivePage() : UIUtil.getActiveWorkbenchPage();
        if (page == null) {
            return false;
        }
        try {
            StructuredSelection ss = new StructuredSelection((Object)je);
            OpenAction openAction = new OpenAction((IWorkbenchSite)page.getActivePart().getSite());
            openAction.run((IStructuredSelection)ss);
            return true;
        }
        catch (Exception e) {
            HyadesUIPlugin.logError(e);
            return false;
        }
    }

    private static String[] getParamatersFromMethodSignature(String signature) {
        int bIdx2;
        int bIdx1 = signature.indexOf(40);
        String parms = signature.substring(bIdx1 + 1, bIdx2 = signature.indexOf(41));
        if (parms.length() == 0) {
            return new String[0];
        }
        Vector<String> pTypes = new Vector<String>();
        int cIdx = parms.indexOf(44);
        while (cIdx >= 0) {
            pTypes.addElement(parms.substring(0, cIdx).trim());
            parms = parms.substring(cIdx + 1);
            cIdx = parms.indexOf(44);
        }
        pTypes.addElement(parms.trim());
        String[] result = new String[pTypes.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = pTypes.get(i).toString();
            ++i;
        }
        return result;
    }

    private static IMethod getMethodFromType(IType type, String signature) {
        String name = signature.substring(0, signature.indexOf("("));
        String[] parameterTypes = OpenJavaSource.getParamatersFromMethodSignature(signature);
        try {
            IMethod[] methods = type.getMethods();
            int i = 0;
            while (i < methods.length) {
                if (methods[i].getElementName().equals(name) && OpenJavaSource.parametersAreEqual(methods[i].getParameterTypes(), parameterTypes)) {
                    return methods[i];
                }
                ++i;
            }
        }
        catch (Exception e) {
            HyadesUIPlugin.logError(e);
        }
        return null;
    }

    private static boolean parametersAreEqual(String[] parameters1, String[] parameters2) {
        if (parameters1.length != parameters2.length) {
            return false;
        }
        boolean parametersMatch = true;
        int i = 0;
        while (i < parameters1.length) {
            if (!Signature.toString((String)parameters1[i]).equals(parameters2[i])) {
                parametersMatch = false;
            }
            ++i;
        }
        if (parametersMatch) {
            return true;
        }
        int i2 = 0;
        while (i2 < parameters1.length) {
            if (!Signature.toString((String)parameters1[i2]).equals(Signature.getSimpleName((String)parameters2[i2]))) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    private static IType getInnerType(IJavaElement je, InnerClassType innerClassType) {
        block5: {
            try {
                SourceType type;
                if (je instanceof SourceType && (type = (SourceType)je).isAnonymous() == innerClassType.isAnonymous() && (innerClassType.isAnonymous() && innerClassType.getAnonymousNumber() == type.occurrenceCount || !innerClassType.isAnonymous() && type.getElementName().equals(innerClassType.getName()))) {
                    return type;
                }
                if (!(je instanceof IParent)) break block5;
                IParent parentElement = (IParent)je;
                IJavaElement[] children = parentElement.getChildren();
                int i = 0;
                while (i < children.length) {
                    IType result = OpenJavaSource.getInnerType(children[i], innerClassType);
                    if (result != null) {
                        return result;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                HyadesUIPlugin.logError(e);
            }
        }
        return null;
    }

    private static IWorkbenchPage getJavaActivePage() {
        IWorkbenchPage page;
        block5: {
            page = UIUtil.getActiveWorkbenchPage();
            if (page != null && page.getPerspective().getId().equals(JAVA_PERSPECTIVE_ID)) break block5;
            IWorkbenchWindow dwindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            page = null;
            try {
                IWorkbenchPage[] persps = dwindow.getPages();
                int idx = 0;
                while (idx < persps.length) {
                    if (persps[idx].getPerspective().getId().equals(JAVA_PERSPECTIVE_ID)) {
                        page = persps[idx];
                        dwindow.setActivePage(page);
                        break;
                    }
                    ++idx;
                }
                if (page != null) break block5;
                IWorkspaceRoot element = ResourcesPlugin.getWorkspace().getRoot();
                IWorkbench workBench = dwindow.getWorkbench();
                if (workBench != null && element != null) {
                    page = workBench.showPerspective(JAVA_PERSPECTIVE_ID, dwindow, (IAdaptable)element);
                }
            }
            catch (Exception exc) {
                HyadesUIPlugin.logError(exc);
            }
        }
        return page;
    }

    private static class InnerClassType {
        private String _name;
        private String _method = null;
        private int _anonymousNumber = -1;
        private InnerClassType _child = null;

        public InnerClassType(String innerClassTypeStr) {
            int idx = innerClassTypeStr.indexOf("$");
            int bidx = innerClassTypeStr.indexOf("(");
            if ((bidx < 0 || bidx > idx) && idx >= 0) {
                this._name = innerClassTypeStr.substring(0, idx);
                this._child = new InnerClassType(innerClassTypeStr.substring(idx + 1));
            } else {
                idx = innerClassTypeStr.indexOf(".");
                if ((bidx < 0 || bidx > idx) && idx >= 0) {
                    this._name = innerClassTypeStr.substring(0, idx);
                    this._method = innerClassTypeStr.substring(idx + 1);
                } else if (bidx >= 0) {
                    this._name = innerClassTypeStr.substring(0, bidx);
                    int bidx2 = innerClassTypeStr.indexOf(")");
                    String parms = innerClassTypeStr.substring(bidx + 1, bidx2);
                    int idx2 = parms.indexOf(",");
                    parms = idx2 >= 0 ? parms.substring(idx2 + 1).trim() : "";
                    this._method = this._name + "(" + parms + ")";
                } else {
                    this._name = innerClassTypeStr;
                }
            }
            try {
                int number;
                this._anonymousNumber = number = Integer.parseInt(this._name);
            }
            catch (NumberFormatException ne) {
                this._anonymousNumber = -1;
            }
        }

        public boolean isAnonymous() {
            return this._anonymousNumber > -1;
        }

        public int getAnonymousNumber() {
            return this._anonymousNumber;
        }

        public boolean hasMethod() {
            return this._method != null;
        }

        public String getMethod() {
            return this._method;
        }

        public String getName() {
            return this._name;
        }

        public boolean hasChildClass() {
            return this._child != null;
        }

        public InnerClassType getChildClass() {
            return this._child;
        }
    }

    private static class OpenSourceJavaSearchResultRequestor
    extends SearchRequestor {
        private Vector _matches = new Vector();
        private InnerClassType _innerClassType = null;

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            this._matches.addElement(match);
        }

        public int getNumberOfMatches() {
            return this._matches.size();
        }

        public SearchMatch getMatch(int i) {
            return (SearchMatch)this._matches.elementAt(i);
        }

        public SearchMatch getFirstMatch() {
            if (this.getNumberOfMatches() > 0) {
                return this.getMatch(0);
            }
            return null;
        }

        public SearchMatch getMatchForPattern(String pattern) {
            block4: {
                if (this.getNumberOfMatches() <= 1) break block4;
                try {
                    IJavaElement je = null;
                    IMethod me = null;
                    int i = 0;
                    while (i < this.getNumberOfMatches()) {
                        je = (IJavaElement)this.getMatch(i).getElement();
                        if (je instanceof IMethod && !(me = (IMethod)je).isConstructor() && pattern.indexOf(me.getDeclaringType().getFullyQualifiedName()) >= 0) {
                            return this.getMatch(i);
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    HyadesUIPlugin.logError(e);
                }
            }
            return this.getFirstMatch();
        }

        public static IFile getFile(SearchMatch match) {
            if (match != null && match.getResource() instanceof IFile) {
                return (IFile)match.getResource();
            }
            return null;
        }

        public boolean hasInnerClassType() {
            return this._innerClassType != null;
        }

        public InnerClassType setInnerClassType(InnerClassType innerClassType) {
            this._innerClassType = innerClassType;
            return this._innerClassType;
        }

        public InnerClassType getInnerClassType() {
            return this._innerClassType;
        }
    }
}

