/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.analysis;

import org.eclipse.hyades.analysis.engine.IAnalysisEngine;
import org.eclipse.hyades.analysis.engine.Incident;
import org.eclipse.hyades.analysis.engine.Solution;
import org.eclipse.hyades.sdb.analysis.XMISymptomDatabase;

public final class AnalysisEngine
implements IAnalysisEngine {
    private XMISymptomDatabase symptomDatabase = null;

    private AnalysisEngine() {
    }

    private AnalysisEngine(String symptomDbPath) {
        this.symptomDatabase = new XMISymptomDatabase();
        this.replaceSymptomDatabase(symptomDbPath);
    }

    public static AnalysisEngine getInstance() {
        return new AnalysisEngine(null);
    }

    public static AnalysisEngine getInstance(String symptomDbPath) {
        return new AnalysisEngine(symptomDbPath);
    }

    public synchronized boolean reloadSymptomDatabase() {
        return this.symptomDatabase.load();
    }

    public synchronized boolean mergeSymptomDatabase(String symptomDbPath) {
        return this.symptomDatabase.merge(symptomDbPath);
    }

    public synchronized boolean removeSymptomDatabase() {
        return this.symptomDatabase.replace(null);
    }

    public synchronized boolean replaceSymptomDatabase(String symptomDbPath) {
        if (symptomDbPath != null && !symptomDbPath.trim().equals("")) {
            return this.symptomDatabase.replace(symptomDbPath);
        }
        return false;
    }

    public synchronized String getSymptomDatabasePath() {
        if (this.symptomDatabase != null) {
            return this.symptomDatabase.getPath();
        }
        return null;
    }

    public synchronized Object[] analyze(Incident incident) {
        return this.symptomDatabase.getDirectives(incident);
    }

    public Solution[] analyzeForSolutions(Incident incident) {
        return this.symptomDatabase.getSolutions(incident);
    }
}

