/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.hyades.models.internal.sdb.impl.SDBFactoryImpl;
import org.eclipse.hyades.models.internal.sdb.impl.SDBPackageImpl;
import org.eclipse.hyades.models.internal.sdb.impl.SDBResourceSetImpl;
import org.eclipse.hyades.sdb.internal.SDbPluginImages;
import org.eclipse.hyades.ui.internal.util.StringUtil;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class SDbPlugin
extends AbstractUIPlugin {
    private static SDbPlugin inst;
    private static ResourceBundle fResourceBundle;
    private SDBFactoryImpl factory;
    private ResourceSet resourceSet;
    public static final String PLUGIN_ID = "org.eclipse.hyades.sdb";

    public SDbPlugin() {
        if (inst == null) {
            inst = this;
        }
    }

    public static SDbPlugin getDefault() {
        return inst;
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        return SDbPluginImages.getImageDescriptor(name);
    }

    public static ResourceBundle getResourceBundle() {
        block2: {
            if (fResourceBundle != null) break block2;
            try {
                fResourceBundle = Platform.getResourceBundle((Bundle)Platform.getBundle((String)PLUGIN_ID));
            }
            catch (MissingResourceException e) {
                e.printStackTrace();
                fResourceBundle = null;
            }
        }
        return fResourceBundle;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = SDbPlugin.getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public static String getResourceString(String key, String[] variables) {
        String value = SDbPlugin.getResourceString(key);
        int i = variables.length;
        while (i > 0) {
            value = StringUtil.replace((String)value, (String)("%" + i), (String)variables[i - 1]);
            --i;
        }
        return value;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.savePluginPreferences();
        SDbPluginImages.shutdown();
    }

    public void start(BundleContext context) throws Exception {
        SDBPackageImpl.init();
        this.factory = new SDBFactoryImpl();
        this.resourceSet = SDBResourceSetImpl.getInstance();
        super.start(context);
    }

    public SDBFactoryImpl getSDBFactory() {
        if (this.factory == null) {
            this.factory = new SDBFactoryImpl();
        }
        return this.factory;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        String url = SDbPlugin.getResourceString("STR_StdURL_NAME") + "\t" + "ftp://ftp.software.ibm.com/software/websphere/info/tools/loganalyzer/symptoms/std/symptomdb.xml" + "\n" + SDbPlugin.getResourceString("STR_AdvURL_NAME") + "\t" + "ftp://ftp.software.ibm.com/software/websphere/info/tools/loganalyzer/symptoms/adv/symptomdb.xml" + "\n" + SDbPlugin.getResourceString("STR_StdURL_NAME_V5") + "\t" + "ftp://ftp.software.ibm.com/software/websphere/info/tools/loganalyzer/symptoms/std/symptomdb.xml" + "\n" + SDbPlugin.getResourceString("STR_StdURL_NAME_V6") + "\t" + "ftp://ftp.software.ibm.com/software/websphere/info/tools/loganalyzer/symptoms/std/symptomdb.xml" + "\n" + SDbPlugin.getResourceString("STR_AdvURL_NAME_V5") + "\t" + "ftp://ftp.software.ibm.com/software/websphere/info/tools/loganalyzer/symptoms/adv/symptomdb.xml";
        store.setDefault("symptom_db_url", url);
        store.setDefault("symptom_db_url_3.2", url);
    }

    public void log(IStatus status) {
        this.getLog().log(status);
    }

    public void log(Throwable e) {
        this.log((IStatus)new Status(4, PLUGIN_ID, 4, "Error", e));
    }
}

