/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.sdb.internal.editors;

import java.text.DateFormat;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.editors.EditorPage;
import org.eclipse.hyades.sdb.internal.editors.SymptomDBEditor;
import org.eclipse.hyades.sdb.internal.util.GridUtil;
import org.eclipse.hyades.sdb.internal.util.RASWidgetFactory;
import org.eclipse.hyades.ui.internal.util.StringUtil;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.FilePropertySource;

public class SymptomDBEditorOverviewPage
extends EditorPage {
    Label txtPath;
    Label txtSize;
    Label txtLocation;
    Label txtTimeStamp;

    public SymptomDBEditorOverviewPage(RASWidgetFactory factory) {
        super(factory);
    }

    public void createContent(Composite parent) {
        Composite sepHeader = this.factory.createCompositeSeparator(parent);
        Composite composite = this.factory.createComposite(parent);
        GridLayout detailLayout = new GridLayout();
        detailLayout.numColumns = 2;
        composite.setLayout((Layout)detailLayout);
        composite.setLayoutData((Object)GridUtil.createFill());
        super.setTitle(SDbPlugin.getResourceString("STR_OVERVIEW_LABEL"));
        Label lblPath = this.factory.createLabel(composite, SDbPlugin.getResourceString("STR_PATH_LABEL"), 0);
        this.txtPath = this.factory.createLabel(composite, "", 0);
        this.txtPath.setLayoutData((Object)new GridData(768));
        this.txtPath.setFont(JFaceResources.getFont((String)"org.eclipse.jface.bannerfont"));
        Label lblLocation = this.factory.createLabel(composite, SDbPlugin.getResourceString("STR_LOCATION_LABEL"), 0);
        this.txtLocation = this.factory.createLabel(composite, "", 0);
        this.txtLocation.setLayoutData((Object)new GridData(768));
        this.txtLocation.setFont(JFaceResources.getFont((String)"org.eclipse.jface.bannerfont"));
        Label lblSize = this.factory.createLabel(composite, SDbPlugin.getResourceString("STR_SIZE_LABEL"), 0);
        this.txtSize = this.factory.createLabel(composite, "", 0);
        this.txtSize.setLayoutData((Object)new GridData(768));
        this.txtSize.setFont(JFaceResources.getFont((String)"org.eclipse.jface.bannerfont"));
        Label lblTimeStamp = this.factory.createLabel(composite, SDbPlugin.getResourceString("STR_TIMESTAMP_LABEL"), 0);
        this.txtTimeStamp = this.factory.createLabel(composite, "", 0);
        this.txtTimeStamp.setLayoutData((Object)new GridData(768));
        this.txtTimeStamp.setFont(JFaceResources.getFont((String)"org.eclipse.jface.bannerfont"));
        Composite dummy = this.factory.createComposite(parent);
        dummy.setLayoutData((Object)GridUtil.createFill());
        Composite sep = this.factory.createCompositeSeparator(parent);
        Label lblComment = this.factory.createLabel(parent, SDbPlugin.getResourceString("STR_INFORMATION_LABEL"), 64);
        lblComment.setFont(JFaceResources.getFont((String)"org.eclipse.jface.bannerfont"));
        this.factory.paintChildControlsFor(composite);
    }

    public void init(SymptomDBEditor editor) {
        IFile file = editor.getFile();
        if (file != null) {
            FilePropertySource property = new FilePropertySource(file);
            this.txtPath.setText((String)property.getPropertyValue((Object)"org.eclipse.ui.path"));
            this.txtLocation.setText(file.getLocation().toOSString());
            String size = StringUtil.replace((String)SDbPlugin.getResourceString("STR_SIZE_DB"), (String)"%1", (String)String.valueOf(property.getPropertyValue((Object)"org.eclipse.ui.size")));
            this.txtSize.setText(size);
            DateFormat df = DateFormat.getDateTimeInstance(1, 2);
            this.txtTimeStamp.setText(df.format(new Date(file.getLocation().toFile().lastModified())));
            Point p = this.getContent().computeSize(-1, -1);
            ((ScrolledComposite)editor.getControl(0)).setMinWidth(p.x);
            ((ScrolledComposite)editor.getControl(0)).setMinHeight(p.y);
        }
    }
}

