/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.adapter.internal;

import java.util.Vector;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.views.adapter.internal.ExecutionStatisticPage2;
import org.eclipse.hyades.trace.views.adapter.internal.MultiLevelStatisticMethodViewer;
import org.eclipse.hyades.trace.views.adapter.internal.MultiLevelStatisticPage;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.Separator;

public class ExecutionStatisticViewer2
extends MultiLevelStatisticMethodViewer {
    protected Action _percentMode;
    protected Action _deltaColumns;
    protected Action _instanceLevel;
    protected static final String _title = TraceUIPlugin.getString("STR_EXECUTION_ST_TITLE");

    public TraceViewerPage createPage(EObject mofObject) {
        return new ExecutionStatisticPage2(mofObject, (TraceViewer)this);
    }

    public String getViewTitle() {
        return _title;
    }

    protected void getLevelActions(Vector actions) {
        super.getLevelActions(actions);
        String strInstanceLevel = TraceUIPlugin.getString("STR_ST_INSTANCE_LEVEL");
        this._instanceLevel = new Action(strInstanceLevel){

            public void run() {
                MultiLevelStatisticPage page = (MultiLevelStatisticPage)ExecutionStatisticViewer2.this.getCurrentPage();
                if (page == null) {
                    ExecutionStatisticViewer2.this.revertChecked(ExecutionStatisticViewer2.this._instanceLevel);
                    return;
                }
                ExecutionStatisticViewer2.this.setCheckedLevels(page, 4);
            }

            public int getStyle() {
                return 2;
            }
        };
        this._instanceLevel.setText(strInstanceLevel);
        TracePluginImages.setImageDescriptors((IAction)this._instanceLevel, "lcl16", "objects_co.gif");
        this._instanceLevel.setDescription(strInstanceLevel);
        this._instanceLevel.setToolTipText(strInstanceLevel);
        this._instanceLevel.setEnabled(true);
        actions.addElement(new Separator());
        actions.addElement(this._instanceLevel);
    }

    public void getActions(Vector actions) {
        String strShowPercent = TraceUIPlugin.getString("SHOW_PERCENT");
        this._percentMode = new Action(strShowPercent){

            public void run() {
                ExecutionStatisticPage2 page = (ExecutionStatisticPage2)ExecutionStatisticViewer2.this.getCurrentPage();
                if (page == null) {
                    ExecutionStatisticViewer2.this.revertChecked(ExecutionStatisticViewer2.this._percentMode);
                    return;
                }
                page.getView().getShowPercentAction().run();
            }

            public int getStyle() {
                return 2;
            }
        };
        this._percentMode.setText(strShowPercent);
        TracePluginImages.setImageDescriptors((IAction)this._percentMode, "lcl16", "percentage_show.gif");
        this._percentMode.setDescription(strShowPercent);
        this._percentMode.setToolTipText(strShowPercent);
        this._percentMode.setEnabled(true);
        String strShowDelta = TraceUIPlugin.getString("STR_ST_SHOW_DELTA_COLUMNS");
        this._deltaColumns = new Action(strShowDelta){

            public void run() {
                ExecutionStatisticPage2 page = (ExecutionStatisticPage2)ExecutionStatisticViewer2.this.getCurrentPage();
                if (page == null) {
                    ExecutionStatisticViewer2.this.revertChecked(ExecutionStatisticViewer2.this._deltaColumns);
                    return;
                }
                page.getView().getDeltaColumnsAction().run();
            }

            public int getStyle() {
                return 2;
            }
        };
        this._deltaColumns.setText(strShowDelta);
        TracePluginImages.setImageDescriptors((IAction)this._deltaColumns, "lcl16", "delta_show.gif");
        this._deltaColumns.setDescription(strShowDelta);
        this._deltaColumns.setToolTipText(strShowDelta);
        this._deltaColumns.setEnabled(true);
        int actionSize = actions.size();
        super.getActions(actions);
        if (actionSize + 1 < actions.size()) {
            actions.insertElementAt(this._percentMode, actionSize + 2);
            actions.insertElementAt(this._deltaColumns, actionSize + 3);
        } else {
            actions.addElement(this._percentMode);
            actions.addElement(this._deltaColumns);
        }
    }

    public Action percentMode() {
        return this._percentMode;
    }

    public Action deltaColumns() {
        return this._deltaColumns;
    }

    public Action getInstanceLevel() {
        return this._instanceLevel;
    }

    protected void setActionsNull() {
        super.setActionsNull();
        this._instanceLevel = null;
    }
}

