/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.util.internal;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCFilter;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.TRCSourceInfo;

public class CoverageUtil {
    private static final String Path_Separator = ".";
    private static String externFilterPattern = null;

    private static String getSourceSig(TRCSourceInfo e) {
        return e != null ? e.getLocation() + ":" : "";
    }

    public static String getFullSig(TRCMethod e) {
        return CoverageUtil.getSourceSig(e.getSourceInfo()) + e.getLineNo() + ":" + CoverageUtil.getSig(e.getDefiningClass()) + Path_Separator + e.getName() + e.getSignature();
    }

    public static String getFullSig(TRCClass e) {
        return CoverageUtil.getSourceSig(e.getSourceInfo()) + e.getLineNo() + ":" + CoverageUtil.getSig(e);
    }

    public static String getFullSig(TRCPackage e) {
        return e.getName();
    }

    private static String getSig(TRCClass e) {
        return (e.getPackage().getName() == null ? "" : e.getPackage().getName() + Path_Separator) + e.getName();
    }

    public static boolean isFiltered(TRCPackage pac) {
        if (pac.getClasses() == null || pac.getClasses().size() == 0) {
            return true;
        }
        EList cllist = pac.getClasses();
        int remaining = cllist.size();
        int idx = 0;
        while (idx < remaining) {
            Object obj = cllist.get(idx);
            if (obj instanceof TRCClass && CoverageUtil.isFiltered((TRCClass)obj)) {
                --remaining;
            }
            ++idx;
        }
        if (remaining == 0) {
            return true;
        }
        Object[] conflist = pac.getProcess().getAgent().getAgentProxy().getConfigurations().toArray();
        int idxmax = conflist.length;
        int idx2 = 0;
        while (idx2 < idxmax) {
            TRCConfiguration c = (TRCConfiguration)conflist[idx2];
            if (c.isActive()) {
                Object[] filtlist = c.getFilters().toArray();
                int k = 0;
                while (k < filtlist.length) {
                    LocalBoolean exclude;
                    TRCFilter f = (TRCFilter)filtlist[k];
                    if (f.getActive().booleanValue() && CoverageUtil.isFilteredPackage(f, pac, exclude = new LocalBoolean(true))) {
                        return exclude.bool;
                    }
                    ++k;
                }
            }
            ++idx2;
        }
        return false;
    }

    public static boolean isFiltered(TRCClass cl) {
        if (cl.getMethods() == null || cl.getMethods().size() == 0) {
            return true;
        }
        Object[] conflist = cl.getPackage().getProcess().getAgent().getAgentProxy().getConfigurations().toArray();
        int idxmax = conflist.length;
        int idx = 0;
        while (idx < idxmax) {
            TRCConfiguration c = (TRCConfiguration)conflist[idx];
            if (c.isActive()) {
                Object[] filtlist = c.getFilters().toArray();
                int k = 0;
                while (k < filtlist.length) {
                    LocalBoolean exclude;
                    TRCFilter f = (TRCFilter)filtlist[k];
                    if (f.getActive().booleanValue() && CoverageUtil.isFilteredClass(f, cl, exclude = new LocalBoolean(true))) {
                        return exclude.bool;
                    }
                    ++k;
                }
            }
            ++idx;
        }
        return false;
    }

    private static boolean isFilteredPackage(TRCFilter filter, TRCPackage pack, LocalBoolean exclude) {
        String methodPattern;
        String pattern = filter.getPattern();
        String mode = filter.getMode();
        String type = filter.getType();
        if (type.equals(mode)) {
            type = CoverageUtil.parseFilterPattern(pattern);
            pattern = externFilterPattern;
        }
        if ((methodPattern = filter.getOperation()) != null && methodPattern.length() > 0 && !methodPattern.equals("*")) {
            return false;
        }
        String name = pack.getName();
        if (pattern.endsWith(Path_Separator)) {
            name = name + Path_Separator;
        }
        exclude.bool = !mode.equals("INCLUDE");
        return type.equals("NONE") ? name.equals(pattern) : (type.equals("PREFIX") ? name.endsWith(pattern) : type.equals("SUFFIX") && name.startsWith(pattern));
    }

    private static boolean isFilteredClass(TRCFilter filter, TRCClass cl, LocalBoolean exclude) {
        String methodPattern;
        String pattern = filter.getPattern();
        String mode = filter.getMode();
        String type = filter.getType();
        if (type.equals(mode)) {
            type = CoverageUtil.parseFilterPattern(pattern);
            pattern = externFilterPattern;
        }
        if ((methodPattern = filter.getOperation()) != null && methodPattern.length() > 0 && !methodPattern.equals("*")) {
            return false;
        }
        String clname = cl.getName();
        String fullname = cl.getPackage().getName() + Path_Separator + clname;
        exclude.bool = !mode.equals("INCLUDE");
        if (type.equals("NONE")) {
            if (fullname.equals(pattern)) {
                return true;
            }
            if (clname.equals(pattern)) {
                return true;
            }
        } else if (type.equals("PREFIX")) {
            if (fullname.endsWith(pattern)) {
                return true;
            }
            if (clname.endsWith(pattern)) {
                return true;
            }
        } else if (type.equals("SUFFIX")) {
            if (fullname.startsWith(pattern)) {
                return true;
            }
            if (clname.startsWith(pattern)) {
                return true;
            }
        }
        return false;
    }

    private static String parseFilterPattern(String filterPattern) {
        String genericPattern = "NONE";
        if (filterPattern.length() == 0) {
            externFilterPattern = filterPattern;
            return genericPattern;
        }
        int p = filterPattern.indexOf(42);
        if (p == 0) {
            genericPattern = "PREFIX";
            externFilterPattern = filterPattern.substring(1);
        } else if (p == filterPattern.length() - 1) {
            genericPattern = "SUFFIX";
            externFilterPattern = filterPattern.substring(0, filterPattern.length() - 1);
        } else {
            externFilterPattern = filterPattern;
        }
        return genericPattern;
    }

    private static class LocalBoolean {
        public boolean bool;

        public LocalBoolean(boolean b) {
            this.bool = b;
        }
    }
}

