/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.execution.local;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.hyades.execution.core.ExecutionComponentStateChangeEvent;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IExecutionComponentFactory;
import org.eclipse.hyades.execution.core.IExecutionComponentStateChangeListener;
import org.eclipse.hyades.execution.core.ISession;
import org.eclipse.hyades.execution.invocation.CallData;
import org.eclipse.hyades.execution.invocation.IRemoteObject;
import org.eclipse.hyades.execution.invocation.MarshalData;
import org.eclipse.hyades.execution.invocation.Marshaller;
import org.eclipse.hyades.execution.invocation.RemoteInvocationException;
import org.eclipse.hyades.execution.invocation.ReturnData;
import org.eclipse.hyades.execution.local.ClassRelationship;
import org.eclipse.hyades.execution.local.ExecutionComponentStub;
import org.eclipse.hyades.execution.local.SessionStub;
import org.eclipse.hyades.internal.execution.local.common.BinaryCustomCommand;

public class ExecutionComponentFactoryImpl
implements IExecutionComponentFactory,
IRemoteObject {
    protected static HashMap instances = new HashMap();
    protected HashMap components = new HashMap();
    protected ISession sessionContext;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;

    protected ExecutionComponentFactoryImpl(ISession session) {
        this.sessionContext = session;
        Marshaller.addInstanceToMap((Integer)this.getUniqueId(), (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IExecutionComponentFactory getInstance(final ISession session) {
        HashMap hashMap = instances;
        synchronized (hashMap) {
            IExecutionComponentFactory factory = (IExecutionComponentFactory)instances.get(session);
            if (factory == null) {
                factory = new ExecutionComponentFactoryImpl(session);
                instances.put(session, factory);
                session.addExecutionComponentStateChangeListener(new IExecutionComponentStateChangeListener(){

                    public void stateChanged(ExecutionComponentStateChangeEvent newState) {
                        if (newState.getState() == 4) {
                            ExecutionComponentFactoryImpl.removeInstance(session);
                        }
                    }
                });
            }
            return factory;
        }
    }

    public ISession getSessionContext() {
        return this.sessionContext;
    }

    public void setSessionContext(ISession session) {
        throw new UnsupportedOperationException("The session context of the factory should not be set via this method");
    }

    public Integer getUniqueId() {
        return new Integer(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeInstance(ISession session) {
        HashMap hashMap = instances;
        synchronized (hashMap) {
            if (instances.containsKey(session)) {
                ExecutionComponentFactoryImpl factory = (ExecutionComponentFactoryImpl)instances.get(session);
                factory.sessionContext = null;
                instances.remove(session);
            }
        }
    }

    public synchronized IExecutionComponent createExecutionComponentByType(String type) {
        ExecutionComponentStub stubInstance = null;
        ClassRelationship rel = (ClassRelationship)this.components.get(type);
        if (rel != null) {
            try {
                Class impl = rel.impl;
                Class stub = rel.stubClass;
                IExecutionComponent implInstance = (IExecutionComponent)impl.newInstance();
                stubInstance = (ExecutionComponentStub)stub.newInstance();
                stubInstance.setDelegate(implInstance);
                stubInstance.setSessionContext(this.sessionContext);
                Marshaller.addInstanceToMap((Integer)stubInstance.getUniqueId(), (Object)stubInstance);
                stubInstance.init();
            }
            catch (Throwable e) {
                throw new RemoteInvocationException(e);
            }
        } else {
            throw new RemoteInvocationException("Factory not configured for this type");
        }
        if (stubInstance != null) {
            ReturnData invokeRtn = this.delegateRemoteCall(new Class[]{class$java$lang$Integer == null ? (class$java$lang$Integer = ExecutionComponentFactoryImpl.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$String == null ? (class$java$lang$String = ExecutionComponentFactoryImpl.class$("java.lang.String")) : class$java$lang$String}, new Object[]{stubInstance.getUniqueId(), type}, "createExecutionComponentByType");
            Object rtnValue = invokeRtn.getReturnValue();
            if (invokeRtn.isError()) {
                throw new RemoteInvocationException((Throwable)invokeRtn.getReturnValue());
            }
            if (!(rtnValue instanceof IExecutionComponent)) {
                throw new RemoteInvocationException("Return value is incorrect type");
            }
        }
        return stubInstance;
    }

    public synchronized IRemoteObject createRemoteObjectByType(String type) {
        IRemoteObject stubInstance = null;
        ClassRelationship rel = (ClassRelationship)this.components.get(type);
        if (rel != null) {
            try {
                Class impl = rel.impl;
                Class stub = rel.stubClass;
                Object implInstance = impl.newInstance();
                stubInstance = (IRemoteObject)stub.newInstance();
                stubInstance.setDelegate(implInstance);
                stubInstance.setSessionContext(this.sessionContext);
                Marshaller.addInstanceToMap((Integer)stubInstance.getUniqueId(), (Object)stubInstance);
                stubInstance.init();
            }
            catch (Throwable e) {
                throw new RemoteInvocationException(e);
            }
        } else {
            throw new RemoteInvocationException("Factory not configured for type \"" + type + "\"");
        }
        if (stubInstance != null) {
            ReturnData invokeRtn = this.delegateRemoteCall(new Class[]{class$java$lang$Integer == null ? (class$java$lang$Integer = ExecutionComponentFactoryImpl.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$String == null ? (class$java$lang$String = ExecutionComponentFactoryImpl.class$("java.lang.String")) : class$java$lang$String}, new Object[]{stubInstance.getUniqueId(), type}, "createRemoteObjectByType");
            Object rtnValue = invokeRtn.getReturnValue();
            if (invokeRtn.isError()) {
                throw new RemoteInvocationException((Throwable)invokeRtn.getReturnValue());
            }
            if (!(rtnValue instanceof IRemoteObject)) {
                throw new RemoteInvocationException("Return value is not an instance of IRemoteObject");
            }
        }
        return stubInstance;
    }

    public void addExecutionComponent(String type, String implClass) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(implClass, true, this.getClass().getClassLoader());
        ReturnData invokeRtn = this.delegateRemoteCall(new Class[]{class$java$lang$String == null ? (class$java$lang$String = ExecutionComponentFactoryImpl.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ExecutionComponentFactoryImpl.class$("java.lang.String")) : class$java$lang$String}, new Object[]{type, implClass}, "addExecutionComponent");
        Object rtnValue = invokeRtn.getReturnValue();
        if (invokeRtn.isError()) {
            throw new RemoteInvocationException((Throwable)invokeRtn.getReturnValue());
        }
        ClassRelationship rel = new ClassRelationship();
        rel.impl = clazz;
        this.components.put(type, rel);
    }

    public void addStub(String type, String stubClass) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(stubClass, true, this.getClass().getClassLoader());
        ClassRelationship rel = (ClassRelationship)this.components.get(type);
        if (rel == null) {
            throw new ClassNotFoundException("Impl class not specified with addExecutionComponent()");
        }
        rel.stubClass = clazz;
    }

    public void addSkeleton(String type, String skeletonClass) throws ClassNotFoundException {
        ReturnData invokeRtn = this.delegateRemoteCall(new Class[]{class$java$lang$String == null ? (class$java$lang$String = ExecutionComponentFactoryImpl.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ExecutionComponentFactoryImpl.class$("java.lang.String")) : class$java$lang$String}, new Object[]{type, skeletonClass}, "addSkeleton");
        Object rtnValue = invokeRtn.getReturnValue();
        if (invokeRtn.isError()) {
            throw new RemoteInvocationException((Throwable)invokeRtn.getReturnValue());
        }
    }

    public ReturnData delegateRemoteCall(Class[] argTypes, Object[] callArgs, String call) throws RemoteInvocationException {
        ReturnData tmp;
        CallData callData = new CallData(this.getUniqueId(), argTypes, callArgs, call);
        BinaryCustomCommand command = new BinaryCustomCommand();
        try {
            command.setData(Marshaller.marshalMethodCall((CallData)callData));
        }
        catch (IOException e) {
            throw new RemoteInvocationException((Throwable)e);
        }
        try {
            ((SessionStub)this.sessionContext).invokeRemote(command);
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        ReturnData returnData = null;
        do {
            Marshaller.waitForReturnData();
        } while (!callData.isForSameCallAs((MarshalData)(tmp = Marshaller.peekReturnValue())));
        returnData = Marshaller.unqueueReturnValue();
        return returnData;
    }

    public Object getDelegate() {
        return this;
    }

    public void setDelegate(Object delegate) {
    }

    public void init() {
    }

    protected void finalize() throws Throwable {
        this.sessionContext = null;
        super.finalize();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

