/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.statistical.ui.editor.internal;

import java.util.Iterator;
import java.util.List;
import org.eclipse.hyades.model.statistical.SDContiguousObservation;
import org.eclipse.hyades.model.statistical.SDDiscreteObservation;
import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.editor.internal.ObservationSearcher;
import org.eclipse.hyades.statistical.ui.widgets.grapher.internal.GraphSource;

public class SDSnapshotObservationGraphSource
implements GraphSource {
    List times;
    List values;
    ObservationSearcher search;
    Calculation calc = new Calculation();

    public SDSnapshotObservationGraphSource(SDContiguousObservation sdc) {
        this.times = sdc.getCreationTime();
        this.values = sdc.getValue();
        this.search = new ObservationSearcher(sdc);
    }

    public SDSnapshotObservationGraphSource(SDDiscreteObservation sdc) {
        this.times = sdc.getCreationTime();
        this.values = sdc.getValue();
        this.search = new ObservationSearcher(sdc);
    }

    private Calculation getCalculationBetween(int index1, int index2) {
        this.calc.count = index2 - index1;
        this.calc.min = Double.MAX_VALUE;
        this.calc.max = Double.MIN_VALUE;
        this.calc.sum = 0.0;
        int i = index1;
        while (i < index2) {
            Number num = (Number)this.values.get(i);
            double tmp = this.validate(num.doubleValue(), this.calc.min);
            if (tmp < this.calc.min) {
                this.calc.min = tmp;
            }
            if (tmp > this.calc.max) {
                this.calc.max = tmp;
            }
            this.calc.sum += tmp;
            ++i;
        }
        this.calc.avg = this.calc.sum / this.calc.count;
        return this.calc;
    }

    public double getCountBetween(double t, double t1) {
        double tval;
        int index2;
        if (this.times == null || this.values == null) {
            return 0.0;
        }
        if (this.times.size() == 0 || this.values.size() == 0) {
            return 0.0;
        }
        int index1 = this.search.bchopGetIndex(t, 1);
        if (index1 == (index2 = this.search.bchopGetIndex(t1, 0)) && t <= (tval = ((Number)this.times.get(index1)).doubleValue()) && t1 > tval) {
            ++index2;
        }
        return index2 - index1;
    }

    public double getMinBetween(double t, double t1) {
        int index2;
        if (this.times == null || this.values == null) {
            return 0.0;
        }
        if (this.times.size() == 0 || this.values.size() == 0) {
            return 0.0;
        }
        int index1 = this.search.bchopGetIndex(t, 1);
        if (index1 == (index2 = this.search.bchopGetIndex(t1, 0))) {
            double tval = ((Number)this.times.get(index1)).doubleValue();
            if (t <= tval && t1 > tval) {
                ++index2;
            } else {
                return Double.NaN;
            }
        }
        if (this.times.size() != this.values.size()) {
            EditorPlugin.DBG.warning("Snapshot Observation times list size different to values list size - something is out of sync here - " + this.times.size() + " " + this.values.size());
        }
        double min = Double.MAX_VALUE;
        int i = index1;
        while (i < index2) {
            Number num = (Number)this.values.get(i);
            double tmp = this.validate(num.doubleValue(), min);
            if (tmp < min) {
                min = tmp;
            }
            ++i;
        }
        return min;
    }

    public double getMaxBetween(double t, double t1) {
        int index2;
        if (this.times == null || this.values == null) {
            return 0.0;
        }
        if (this.times.size() == 0 || this.values.size() == 0) {
            return 0.0;
        }
        int index1 = this.search.bchopGetIndex(t, 1);
        if (index1 == (index2 = this.search.bchopGetIndex(t1, 0))) {
            double tval = ((Number)this.times.get(index1)).doubleValue();
            if (t <= tval && t1 > tval) {
                ++index2;
            } else {
                return Double.NaN;
            }
        }
        if (this.times.size() != this.values.size()) {
            EditorPlugin.DBG.warning("Snapshot Observation times list size different to values list size - something is out of sync here - " + this.times.size() + " " + this.values.size());
        }
        double max = Double.MIN_VALUE;
        int i = index1;
        while (i < index2) {
            Number num = (Number)this.values.get(i);
            double tmp = this.validate(num.doubleValue(), max);
            if (tmp > max) {
                max = tmp;
            }
            ++i;
        }
        return max;
    }

    public double getSumBetween(double t, double t1) {
        int index2;
        if (this.times == null || this.values == null) {
            return 0.0;
        }
        if (this.times.size() == 0 || this.values.size() == 0) {
            return 0.0;
        }
        int index1 = this.search.bchopGetIndex(t, 1);
        if (index1 == (index2 = this.search.bchopGetIndex(t1, 0))) {
            double tval = ((Number)this.times.get(index1)).doubleValue();
            if (t <= tval && t1 > tval) {
                ++index2;
            } else {
                return Double.NaN;
            }
        }
        if (this.times.size() != this.values.size()) {
            EditorPlugin.DBG.warning("Snapshot Observation times list size different to values list size - something is out of sync here - " + this.times.size() + " " + this.values.size());
        }
        double sum = 0.0;
        int i = index1;
        while (i < index2) {
            Number num = (Number)this.values.get(i);
            sum += this.validate(num.doubleValue(), 0.0);
            ++i;
        }
        return sum;
    }

    public double getStandardDeviationBetween(double t, double t1) {
        int index2;
        if (this.times == null || this.values == null) {
            return 0.0;
        }
        if (this.times.size() == 0 || this.values.size() == 0) {
            return 0.0;
        }
        int index1 = this.search.bchopGetIndex(t, 1);
        if (index1 == (index2 = this.search.bchopGetIndex(t1, 0))) {
            double tval = ((Number)this.times.get(index1)).doubleValue();
            if (t <= tval && t1 > tval) {
                ++index2;
            } else {
                return Double.NaN;
            }
        }
        if (this.times.size() != this.values.size()) {
            EditorPlugin.DBG.warning("Snapshot Observation times list size different to values list size - something is out of sync here - " + this.times.size() + " " + this.values.size());
        }
        double avg = this.getAverageBetween(t, t1);
        double sumsq = 0.0;
        double tmp = 0.0;
        int i = index1;
        while (i < index2) {
            Number num = (Number)this.values.get(i);
            tmp = this.validate(num.doubleValue(), 0.0) - avg;
            tmp *= tmp;
            sumsq += tmp;
            ++i;
        }
        double div = index2 - index1;
        if (div > 1.0) {
            sumsq /= div;
        }
        return Math.sqrt(sumsq);
    }

    public double getAverageBetween(double t, double t1) {
        int index2;
        if (this.times == null || this.values == null) {
            return 0.0;
        }
        if (this.times.size() == 0 || this.values.size() == 0) {
            return 0.0;
        }
        int index1 = this.search.bchopGetIndex(t, 1);
        if (index1 == (index2 = this.search.bchopGetIndex(t1, 0))) {
            double tval = ((Number)this.times.get(index1)).doubleValue();
            if (t <= tval && t1 > tval) {
                ++index2;
            } else {
                return Double.NaN;
            }
        }
        if (this.times.size() != this.values.size()) {
            EditorPlugin.DBG.warning("Snapshot Observation times list size different to values list size - something is out of sync here - " + this.times.size() + " " + this.values.size());
        }
        double sum = 0.0;
        int i = index1;
        while (i < index2) {
            Number num = (Number)this.values.get(i);
            sum += this.validate(num.doubleValue(), 0.0);
            ++i;
        }
        double div = index2 - index1;
        if (div > 1.0) {
            return sum / div;
        }
        return sum;
    }

    private double validate(double val, double alt) {
        if (Double.isNaN(val) || Double.isInfinite(val)) {
            val = alt;
        }
        return val;
    }

    public double getValueAt(double t) {
        if (this.times == null || this.values == null) {
            return 0.0;
        }
        if (this.times.size() == 0 || this.values.size() == 0) {
            return 0.0;
        }
        int index = this.search.bchopGetIndex(t, 0);
        if (this.times.size() != this.values.size()) {
            EditorPlugin.DBG.warning("Snapshot Observation times list size different to values list size - something is out of sync here - " + this.times.size() + " " + this.values.size());
        }
        Number D = (Number)this.values.get(index);
        return this.validate(D.doubleValue(), 0.0);
    }

    public double getValueMin() {
        if (this.times == null || this.values == null) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.times.size() == 0 || this.values.size() == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        double Vmin = Double.MAX_VALUE;
        double Vmax = Double.MIN_VALUE;
        Iterator it = this.values.iterator();
        while (it.hasNext()) {
            Number V = (Number)it.next();
            double tmp = V.doubleValue();
            if (tmp > Vmax) {
                Vmax = tmp;
            }
            if (!(tmp < Vmin)) continue;
            Vmin = tmp;
        }
        return Vmin;
    }

    public double getValueMax() {
        if (this.times == null || this.values == null) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.times.size() == 0 || this.values.size() == 0) {
            return Double.POSITIVE_INFINITY;
        }
        double Vmin = Double.MAX_VALUE;
        double Vmax = Double.MIN_VALUE;
        Iterator it = this.values.iterator();
        while (it.hasNext()) {
            Number V = (Number)it.next();
            double tmp = V.doubleValue();
            if (tmp > Vmax) {
                Vmax = tmp;
            }
            if (!(tmp < Vmin)) continue;
            Vmin = tmp;
        }
        return Vmax;
    }

    public double getMin() {
        if (this.times == null || this.values == null) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.times.size() == 0 || this.values.size() == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        Number L = (Number)this.times.get(0);
        return L.doubleValue();
    }

    public double getMax() {
        if (this.times == null || this.values == null) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.times.size() == 0 || this.values.size() == 0) {
            return Double.POSITIVE_INFINITY;
        }
        Number L = (Number)this.times.get(this.times.size() - 1);
        return L.doubleValue();
    }

    class Calculation {
        double count;
        double min;
        double max;
        double sum;
        double avg;

        Calculation() {
        }
    }
}

