/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.uml2sd.util;

import java.text.MessageFormat;
import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;

public class TimeUtil {
    private static String[] normalStrings = new String[]{SDViewerPlugin.getResourceString("STR_DAYS_HOURS"), SDViewerPlugin.getResourceString("STR_DAY_HOURS"), SDViewerPlugin.getResourceString("STR_HOURS_MINUTES"), SDViewerPlugin.getResourceString("STR_MINUTES_SECONDS"), SDViewerPlugin.getResourceString("STR_SECONDS"), SDViewerPlugin.getResourceString("STR_MILLISECONDS"), SDViewerPlugin.getResourceString("STR_MICROSECONDS")};
    private static String[] accessibleStrings = new String[]{SDViewerPlugin.getResourceString("STR_FULL_WORDS_DAYS_HOURS"), SDViewerPlugin.getResourceString("STR_FULL_WORDS_DAY_HOURS"), SDViewerPlugin.getResourceString("STR_FULL_WORDS_HOURS_MINUTES"), SDViewerPlugin.getResourceString("STR_FULL_WORDS_MINUTES_SECONDS"), SDViewerPlugin.getResourceString("STR_FULL_WORDS_SECONDS"), SDViewerPlugin.getResourceString("STR_FULL_WORDS_MILLISECONDS"), SDViewerPlugin.getResourceString("STR_FULL_WORDS_MICROSECONDS")};

    public static String timeToString(double time) {
        return TimeUtil.timeToString(time, normalStrings);
    }

    public static String accessibleTimeToString(double time) {
        return TimeUtil.timeToString(time, accessibleStrings);
    }

    private static String timeToString(double time, String[] ress) {
        String ret;
        if (Math.abs(time) >= 86400.0) {
            int days = (int)(time / 86400.0);
            int hours = Math.abs((int)(time % 86400.0) / 3600);
            ret = days != 1 && days != -1 ? MessageFormat.format(ress[0], new Integer(days), new Integer(hours)) : MessageFormat.format(ress[1], new Integer(days), new Integer(hours));
        } else if (Math.abs(time) >= 3600.0) {
            int hours = (int)(time / 3600.0);
            int mins = Math.abs((int)(time % 3600.0) / 60);
            ret = MessageFormat.format(ress[2], new Integer(hours), new Integer(mins));
        } else if (Math.abs(time) >= 60.0) {
            int mins = (int)(time / 60.0);
            int s = Math.abs((int)(time % 60.0));
            ret = MessageFormat.format(ress[3], new Integer(mins), new Integer(s));
        } else {
            ret = Math.abs(time) >= 1.0 ? MessageFormat.format(ress[4], new Double(time)) : (Math.abs(time * 1000.0) >= 1.0 ? MessageFormat.format(ress[5], new Double(time * 1000.0)) : MessageFormat.format(ress[6], new Double(time * 1000000.0)));
        }
        return ret;
    }
}

