/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.threadanalyzer;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.hyades.collection.threadanalyzer.DumpData;
import org.eclipse.hyades.collection.threadanalyzer.TAUtils;
import org.eclipse.hyades.collection.threadanalyzer.Thd;

public class Monitor
implements Externalizable {
    private static int _curVersion = 1;
    private int _version = -1;
    public String _name = null;
    public int _ID = -1;
    public Thd _owner = null;
    public Vector _waiters = null;
    public int _monitor_type = -1;
    private Properties _props = null;
    public static final int WAIT_MONITOR = 1;
    public static final int SYNC_MONITOR = 2;

    public Monitor(String string, int n) {
        this._version = _curVersion;
        this._name = string;
        this._monitor_type = n;
        this._ID = DumpData.getID();
        this._waiters = new Vector();
        this._owner = null;
        this._props = new Properties();
    }

    public String getProperty(String string) {
        return this._props.getProperty(string);
    }

    public void setProperty(String string, String string2) {
        this._props.setProperty(string, string2);
    }

    public void addWaiter(Thd thd) {
        this._waiters.add(thd);
        thd.setWaitMonitor(this);
    }

    public int getId() {
        return this._ID;
    }

    public void setOwner(Thd thd) {
        this._owner = thd;
    }

    public Vector format(int n, boolean bl) {
        Vector<String> vector = new Vector<String>();
        String string = "   ";
        String string2 = "";
        int n2 = 0;
        while (n2 < n) {
            string2 = string2 + "   ";
            ++n2;
        }
        vector.add(string2 + "==" + TAUtils.getNLSValue("ta.format.MonitorDump", "Monitor dump") + "==");
        vector.add(string2 + string + this._name);
        vector.add(string2 + string + string + TAUtils.getNLSValue("ta.format.Waiters", "Waiters") + "....... " + this._waiters.size());
        ++n;
        int n3 = 0;
        while (n3 < this._waiters.size()) {
            Thd thd = (Thd)this._waiters.elementAt(n3);
            vector.addAll(thd.format(n, bl));
            ++n3;
        }
        return vector;
    }

    public void print(int n, boolean bl) {
        Vector vector = this.format(n, bl);
        int n2 = 0;
        while (n2 < vector.size()) {
            System.out.println((String)vector.elementAt(n2));
            ++n2;
        }
    }

    public String getName() {
        return this._name;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(_curVersion);
        objectOutput.writeObject(this._name);
        objectOutput.writeInt(this._ID);
        objectOutput.writeObject(this._owner);
        int n = this._waiters.size();
        objectOutput.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = ((Thd)this._waiters.elementAt(n2)).getId();
            objectOutput.writeInt(n3);
            ++n2;
        }
        objectOutput.writeInt(this._monitor_type);
        objectOutput.writeObject(this._props);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this._version = objectInput.readInt();
        this._name = (String)objectInput.readObject();
        this._ID = objectInput.readInt();
        this._owner = (Thd)objectInput.readObject();
        int n = objectInput.readInt();
        this._waiters = new Vector();
        int n2 = 0;
        while (n2 < n) {
            int n3 = objectInput.readInt();
            this._waiters.add(new Integer(n3));
            ++n2;
        }
        this._monitor_type = objectInput.readInt();
        this._props = (Properties)objectInput.readObject();
    }

    public void fixupWaiters(DumpData dumpData) {
        Vector vector = this._waiters;
        this._waiters = new Vector();
        int n = vector.size();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                int n3 = (Integer)vector.elementAt(n2);
                Thd thd = dumpData.getThreadById(n3);
                this._waiters.add(thd);
                ++n2;
            }
        }
    }

    public Monitor() {
    }
}

