/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.test.collection.framework;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.hyades.execution.core.ExecutionComponentStateChangeEvent;
import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IExecutionComponentStateChangeListener;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.execution.core.IOrderedProperty;
import org.eclipse.hyades.execution.core.impl.ExecutionEnvironmentImpl;
import org.eclipse.hyades.execution.core.impl.OrderedPropertyImpl;
import org.eclipse.hyades.execution.core.impl.ProcessExecutableObjectImpl;
import org.eclipse.hyades.execution.core.impl.ProcessExecutorImpl;
import org.eclipse.hyades.test.collection.framework.UserConsole;

public class TestLauncher
implements IExecutionComponentStateChangeListener {
    public static void main(String[] stringArray) {
        TestLauncher testLauncher = new TestLauncher();
        testLauncher.mainTest();
    }

    private void mainTest() {
        ExecutionEnvironmentImpl executionEnvironmentImpl = new ExecutionEnvironmentImpl();
        executionEnvironmentImpl.init();
        OrderedPropertyImpl orderedPropertyImpl = new OrderedPropertyImpl();
        orderedPropertyImpl.setName("CLASSPATH");
        if (System.getProperty("os.name").startsWith("Windows")) {
            orderedPropertyImpl.prependValue((Object)new String("E:\\Test"));
            orderedPropertyImpl.appendValue((Object)File.pathSeparator);
            orderedPropertyImpl.appendValue((Object)new String("E:\\Test\\hello"));
            executionEnvironmentImpl.setEnv((IOrderedProperty)orderedPropertyImpl);
            this.test01(executionEnvironmentImpl);
        } else {
            orderedPropertyImpl.prependValue((Object)new String("/home/eclipse/Test"));
            executionEnvironmentImpl.setEnv((IOrderedProperty)orderedPropertyImpl);
            this.test01Linux(executionEnvironmentImpl);
        }
    }

    private synchronized void runProcess(ExecutionEnvironmentImpl executionEnvironmentImpl, ProcessExecutableObjectImpl processExecutableObjectImpl, boolean bl) {
        UserConsole userConsole = new UserConsole();
        ProcessExecutorImpl processExecutorImpl = new ProcessExecutorImpl();
        executionEnvironmentImpl.addChild((IExecutionComponent)processExecutorImpl);
        processExecutorImpl.setExecutableObject((IExecutableObject)processExecutableObjectImpl);
        processExecutorImpl.addExecutionComponentStateChangeListener((IExecutionComponentStateChangeListener)this);
        if (bl) {
            OutputStream outputStream = processExecutorImpl.getStandardInputStream();
            InputStream inputStream = processExecutorImpl.getStandardOutputStream();
            InputStream inputStream2 = processExecutorImpl.getStandardErrorStream();
            userConsole.setStdin(outputStream);
            userConsole.setStdout(inputStream);
            userConsole.setStderr(inputStream2);
            userConsole.start();
        }
        processExecutorImpl.launch();
        int n = new Integer(processExecutorImpl.getPid());
        if (n < 0) {
            return;
        }
        if (bl) {
            while (processExecutorImpl.getProcessStatus(n) != 4) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    public void test01(ExecutionEnvironmentImpl executionEnvironmentImpl) {
        ProcessExecutableObjectImpl processExecutableObjectImpl = new ProcessExecutableObjectImpl();
        processExecutableObjectImpl.init();
        processExecutableObjectImpl.setName("Java test case #1");
        processExecutableObjectImpl.setExe("E:\\jdk1.3.1\\bin\\java.exe");
        processExecutableObjectImpl.setArgs("InOut");
        processExecutableObjectImpl.setLocation("E:\\shared");
        this.runProcess(executionEnvironmentImpl, processExecutableObjectImpl, true);
    }

    public void test02(ExecutionEnvironmentImpl executionEnvironmentImpl) {
        ProcessExecutableObjectImpl processExecutableObjectImpl = new ProcessExecutableObjectImpl();
        processExecutableObjectImpl.init();
        processExecutableObjectImpl.setName("Java test case #2");
        processExecutableObjectImpl.setExe("E:\\jdk1.3.1\\bin\\java.exe");
        processExecutableObjectImpl.setArgs("PerformanceExample");
        processExecutableObjectImpl.setLocation("E:\\shared");
        this.runProcess(executionEnvironmentImpl, processExecutableObjectImpl, false);
    }

    public void test03(ExecutionEnvironmentImpl executionEnvironmentImpl) {
        ProcessExecutableObjectImpl processExecutableObjectImpl = new ProcessExecutableObjectImpl();
        processExecutableObjectImpl.init();
        processExecutableObjectImpl.setName("Java test case #3");
        processExecutableObjectImpl.setExe("E:\\jdk1.3.1\\bin\\java.exe");
        processExecutableObjectImpl.setArgs("GetJavaProperties");
        processExecutableObjectImpl.setLocation("E:\\shared");
        this.runProcess(executionEnvironmentImpl, processExecutableObjectImpl, true);
    }

    public void test01Linux(ExecutionEnvironmentImpl executionEnvironmentImpl) {
        ProcessExecutableObjectImpl processExecutableObjectImpl = new ProcessExecutableObjectImpl();
        processExecutableObjectImpl.init();
        processExecutableObjectImpl.setName("Java test case #1 (Linux)");
        processExecutableObjectImpl.setExe("/opt/IBMJava2-131/bin/java");
        processExecutableObjectImpl.setArgs("InOut");
        processExecutableObjectImpl.setLocation("/tmp");
        this.runProcess(executionEnvironmentImpl, processExecutableObjectImpl, true);
    }

    public void stateChanged(ExecutionComponentStateChangeEvent executionComponentStateChangeEvent) {
        if (executionComponentStateChangeEvent.getState() == 4 && executionComponentStateChangeEvent.getComponent() instanceof IExecutor) {
            int n = new Integer(((ProcessExecutorImpl)executionComponentStateChangeEvent.getComponent()).getPid());
            System.out.println("Test case process completed: " + n);
        }
    }
}

