#!/bin/sh
# USAGE:  runregex.sh
# PURPOSE:  Illustrates the functional capabilities of the Generic Log Adapter (GLA)
#           run-time using an example adapter file and sample log file.
# ASSUMPTIONS:  This shell file assumes the GLA run-time and required files are 
#               stored in the following directory structure:
#      %GLA_HOME%/config - GLA adapter configuration files
#      %GLA_HOME%/lib    - GLA run-time and required jars
#      %GLA_HOME%/schema - GLA adapter configuration schema files
# INSTRUCTIONS:  
#     If the GLA run-time and required files are stored as indicated in the 
#         assumptions section above, change the value of the %GLA_HOME% 
#         environment variable to the absolute path where the GLA run-time 
#         and required files are stored.
#     If the GLA run-time files are stored in a plug-in (e.g. Eclipse) 
#         environment, perform the following instructions:
#        1) Create a temporary directory to store the GLA run-time and required files.  
#        2) Create the config, lib, and schema directories in the temporary 
#           directory creatd in step 1)
#        3) Change the value of the %GLA_HOME% environment variable to the 
#           absolute path of the temporary directory created in step 1)
#        4) Copy the Apache directory of the org.eclipse.hyades.logging.adapter.config 
#           plug-in and all of its contents to the %GLA_HOME%/config directory.  
#        5) Copy the contents of the schema directory of 
#           org.eclipse.hyades.logging.adapter plug-in to the %GLA_HOME%/schema directory.
#        6) Copy the following jar files to the %GLA_HOME%/lib directory
#                    Plug-in                 |     JAR
#        ---------------------------------------------------
#        org.eclipse.hyades.logging.adapter  |  hgla.jar
#        org.eclipse.hyades.logging.core     |  hlcbe101.jar
#        org.eclipse.hyades.logging.core     |  hlcore.jar
#        org.eclipse.hyades.execution.remote |  hexr.jar
#        org.eclipse.emf.ecore               |  ecore.jar
#        org.eclipse.emf.common              |  common.jar

GLA_HOME=/home/eclipse/GenericLogAdapter
export GLA_HOME

CONFIG_FILE="$GLA_HOME/config/Apache/error/v1.3.26/regex_example.adapter"
export CONFIG_FILE

CUR_DIR=`pwd`
export CUR_DIR

cd "$GLA_HOME/config/Apache/error/v1.3.26"

java -DGLA_HOME="$GLA_HOME" -classpath "$GLA_HOME/lib/hgla.jar:$GLA_HOME/lib/hexr.jar:$GLA_HOME/lib/hlcbe101.jar:$GLA_HOME/lib/ecore.jar:$GLA_HOME/lib/common.jar:$GLA_HOME/lib/hlcore.jar" org.eclipse.hyades.logging.adapter.Adapter -ac "$CONFIG_FILE" -cc "$CONFIG_FILE"

cd "$CUR_DIR"

