/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: EditAction.java,v 1.4 2005/02/16 22:20:36 qiyanli Exp $
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.logging.adapter.ui.internal.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class EditAction extends Action
{
	public Control getFocusControl()
	{
		return Display.getCurrent().getFocusControl();
	}

	public String getClipboardText()
	{
		Control focusControl = getFocusControl();
		if (focusControl != null)
		{
			Clipboard clipboard = new Clipboard(getFocusControl().getDisplay());
			TextTransfer textTransfer = TextTransfer.getInstance();
			String availableText = (String)clipboard.getContents(textTransfer);
			clipboard.dispose();
			return availableText;
		}
		return null;
	}

	public String getSelectionText()
	{
		Control control = getFocusControl();
		if (control instanceof Text)
		{
			return ((Text)control).getSelectionText();
		}
		if (control instanceof StyledText)
		{
			return ((StyledText)control).getSelectionText();
		}
		if (control instanceof Combo)
		{
			Combo combo = (Combo)control;
			Point selection = combo.getSelection();
			return combo.getText().substring(selection.x, selection.y);
		}
		return "";
	}

	public boolean isReadOnlyFocusControl()
	{
		Control control = getFocusControl();
		if ((control == null) || (!control.isEnabled()))
			return true;
			
		if (control instanceof Text)
			return !((Text)control).getEditable();

		if (control instanceof StyledText)
		{
			return !((StyledText)control).getEditable();
		}
		if (control instanceof Combo)
		{
			Combo combo = (Combo)control;
			return (combo.getStyle() & SWT.READ_ONLY) == SWT.READ_ONLY;
		}
		return false;
	}

	public boolean isValidFocusControl()
	{
		Control control = getFocusControl();
		return (control instanceof Text || control instanceof StyledText || control instanceof Combo);
	}
	
}
