/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ConfigurationPage.java,v 1.6 2005/02/16 22:20:36 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.ui.internal.presentation;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.WrapperItemProvider;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.provider.ConfigurationItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.ContextIds;
import org.eclipse.hyades.logging.adapter.ui.internal.util.GridUtil;
import org.eclipse.hyades.logging.adapter.ui.internal.util.RuleBuilderWidgetFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.help.WorkbenchHelp;

public class ConfigurationPage
	extends EditorPage
	implements ISelectionChangedListener {
	
	protected EditingDomain editingDomain;	
	protected ConfigurationItemProviderAdapterFactory itemFactory;
	protected DetailsContent details;	
	protected Composite result;
	protected TreeViewer treeViewer;
	
	/**
	 * 
	 */
	public ConfigurationPage(
		RuleBuilderWidgetFactory widgetFactory,
		EditingDomain editingDomain)
	{
			
		super(widgetFactory);
		
		this.editingDomain = editingDomain;
	}
		
		
	public void createContent(Composite parent){

		createHeader(parent);

		itemFactory = new ConfigurationItemProviderAdapterFactory();
        
		result =  this.factory.createComposite(parent);
		GridLayout detailLayout = new GridLayout();
		detailLayout.numColumns = 2;
		result.setLayout(detailLayout);
		result.setLayoutData(GridUtil.createFill());

        createDetail(result);
       
		Composite sepFooter = this.factory.createCompositeSeparator(result);
		GridData sepFooterGrid = GridUtil.createHorizontalFill();
		sepFooterGrid.heightHint = 3;
		sepFooterGrid.horizontalSpan = 2;
		sepFooter.setLayoutData(sepFooterGrid);

		factory.paintChildControlsFor(result);

 	}
 	
	private void createDetail(Composite composite){
			    
		Tree tree = factory.createTree(composite, RuleBuilderWidgetFactory.BORDER_STYLE | SWT.H_SCROLL | SWT.V_SCROLL | SWT.MULTI);

		treeViewer = new TreeViewer(tree);
		GridData dummy = GridUtil.createFill();
		dummy.widthHint = 200;
		treeViewer.getTree().setLayoutData(dummy);
		WorkbenchHelp.setHelp(composite, ContextIds.ACAD_EDITOR_TREEVIEW);

		details = new DetailsContent(this.factory, editingDomain, this.itemFactory, result, SWT.NONE);
		details.createContent();
			    
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.Viewer#getControl()
	 */
	public Control getControl() {
		return result;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IInputProvider#getInput()
	 */
	public Object getInput() {
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ISelectionProvider#getSelection()
	 */
	public ISelection getSelection() {
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.Viewer#refresh()
	 */
	public void refresh() {

	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.Viewer#setInput(java.lang.Object)
	 */
	public void setInput(Object input) {
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.Viewer#setSelection(org.eclipse.jface.viewers.ISelection, boolean)
	 */
	public void setSelection(ISelection selection, boolean reveal) {
	}

	/**
	 * Notifies that the selection has changed.
	 *
	 * @param event event object describing the change
	 */
	public void selectionChanged(SelectionChangedEvent event) {
		
		if (event.getSource() != null
			&& event.getSource() instanceof AdaptorEditor) {

            ISelection selection = event.getSelection();
            Object currentSelection = null;
            if(selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection)
              currentSelection = ((IStructuredSelection)selection).getFirstElement();	
            
            
            if(currentSelection instanceof EObject)   			
				details.showDetailsFor((EObject)currentSelection);
            if(currentSelection instanceof WrapperItemProvider)
            {
            	Object value = ((WrapperItemProvider)currentSelection).getValue();
            	if(value!=null && value instanceof FeatureMapUtil.EntryImpl)
            		value = ((FeatureMapUtil.EntryImpl)value).getValue();
            	if(value != null && value instanceof EObject)
            		details.showDetailsFor((EObject)value);
 //           	else
 //           		details.showDetailsFor(null);		
            }
 //		    else
 //		       details.showDetailsFor(null);			
		}
		
	}

	public void dispose() {
		
		if(factory != null)
		  factory.dispose();
		  
	    factory = null;
	    itemFactory = null;	
	    
	    if(details != null)
	      details.dispose();  
	      
	    editingDomain = null;
	}

	private void createHeader(Composite content){

		Composite sepHeader = factory.createCompositeSeparator(content);

	}
	
	/**
	 * @return
	 */
	public DetailsContent getDetails() {
		return details;
	}


	public TreeViewer getViewer(){
		return treeViewer;
	}

}
