/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: InfoSection.java,v 1.4 2005/02/16 22:20:36 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class InfoSection extends Composite
								implements IDetails
{
    protected Object currentSelection;
    protected Label infoLabel;
	
	
	public InfoSection(RuleBuilderWidgetFactory factory, Composite composite, int style){

		super(composite, style);
		
		GridLayout detailLayout = new GridLayout();
		detailLayout.numColumns = 1;

		this.setLayout(detailLayout);
		this.setLayoutData(GridUtil.createFill());
		
		infoLabel = factory.createLabel(this, "", SWT.WRAP);
		infoLabel.setLayoutData(new GridData(GridData.FILL_BOTH));		
	}
	
	/**
	 * @see IDetails#display(Object)
	 */
	public void display(EObject object) {
 
       if(object == null)
         return;
         
	}

	/**
	 * @see IDetails#updateCurrentSelection(Object)
	 */
	public boolean updateCurrentSelection(EObject currentSelection) {
		
		return false;

	}
	
	public void setFocusToText(){
	}

	public void dispose() {
		
	}

}
