/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ProcessUnitSection.java,v 1.4 2005/02/16 22:20:36 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.logging.adapter.ui.internal.util;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.ContextInstanceType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.ProcessUnitType;
import org.eclipse.hyades.logging.adapter.model.internal.unit.provider.ProcessUnitTypeItemProvider;
import org.eclipse.hyades.logging.adapter.model.internal.unit.provider.UnitItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.logging.adapter.ui.internal.views.AcadGuiModelManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ProcessUnitSection extends Composite
								implements IDetails, ModifyListener
										   , INotifyChangedListener
{
	protected Label uniqueId;		
	protected Text descriptionText;		
	
    protected boolean isDisplaying;
    protected ProcessUnitType currentSelection;
    protected ProcessUnitTypeItemProvider itemProvider;
    protected UnitItemProviderAdapterFactory itemFactory;
	
	
	public ProcessUnitSection(RuleBuilderWidgetFactory factory, Composite composite, int style){

		super(composite, style);
		
		itemFactory = new UnitItemProviderAdapterFactory();

		GridLayout detailLayout = new GridLayout();
		detailLayout.numColumns = 2;
		detailLayout.verticalSpacing = 5;

		this.setLayout(detailLayout);
		this.setLayoutData(GridUtil.createFill());
		
		Label label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_PU_DESCR"), SWT.NONE);	
		descriptionText = factory.createText(this, "", SWT.NULL);
		descriptionText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));		
		
		label = factory.createLabel(this, AcadEditorPlugin.getPlugin().getString("STR_PU_ID"), SWT.NONE);	
		uniqueId = factory.createLabel(this, "", SWT.NULL);
		uniqueId.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));		
		

		// add listeners - don't change the order in which the listeners are added
		// because of team support issues modify listeners should always be the last one added
//		uniqueId.addModifyListener(this);
		descriptionText.addModifyListener(this);
		
		itemProvider = (ProcessUnitTypeItemProvider)itemFactory.createProcessUnitTypeAdapter();
		itemProvider.addListener(this);
	}
	
	/**
	 * @see IDetails#display(Object)
	 */
	public void display(EObject object) {
  
		if(object != null)
			AcadGuiModelManager.setCurrentModel((ContextInstanceType)((ProcessUnitType)object).eContainer());

		if(currentSelection == object)
		  return;
        
		if(uniqueId.isFocusControl() || descriptionText.isFocusControl())		   
		  return;
        
		currentSelection = (ProcessUnitType)object;
		isDisplaying = true;
			
		uniqueId.setText(currentSelection.getUniqueID()==null?"":currentSelection.getUniqueID());
		descriptionText.setText(currentSelection.getDescription()==null?"":currentSelection.getDescription());
		
		isDisplaying = false;
	}

	/**
	 * @see IDetails#updateCurrentSelection(Object)
	 */
	public boolean updateCurrentSelection(EObject currentSelection) {

 		this.currentSelection = (ProcessUnitType)currentSelection;
		
		this.currentSelection.setUniqueID(uniqueId.getText());
		this.currentSelection.setDescription(descriptionText.getText());
		
		return false;

	}
	
	public void setFocusToText(){
	        descriptionText.setFocus();
	        descriptionText.selectAll();
	}

	/**
	 * Sent when the text is modified.
	 *
	 * @param e an event containing information about the modify
	 */
	public void modifyText(ModifyEvent e)
	{
		
		if(isDisplaying || currentSelection == null)
		  return;
		  
		if(e.getSource() == descriptionText)
		{
			String text = descriptionText.getText();
			if(!text.equals(currentSelection.getDescription()))
			{
				if(text.length() == 0 && currentSelection.getDescription() == null)
				  return;
				  
				IItemPropertyDescriptor descriptor = 
					itemProvider.getPropertyDescriptor(
						currentSelection,
						ProcessUnitTypeItemProvider.DESCRIPTION);
						
				if(descriptor != null)
					descriptor.setPropertyValue(currentSelection, text);				
			}
		}
	}

	public void dispose() {
		
		itemFactory = null;
		itemProvider = null;
	}

	/**
	 */
	public void notifyChanged(Notification notification)
	{
		Object obj = notification.getNotifier();
		
		if(obj == null || (obj != currentSelection))
		  return;
		  
		display(currentSelection);
	}

}
