/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ResourceSelectionDialog.java,v 1.6 2005/02/16 22:20:36 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.ui.internal.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.hyades.logging.adapter.model.internal.adapter.AdapterPackage;
import org.eclipse.hyades.logging.adapter.model.internal.adapter.provider.AdapterItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.configuration.provider.ConfigurationItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.context.provider.ContextItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.extractor.provider.ExtractorItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.formatter.provider.FormatterItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.outputter.provider.OutputterItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.parser.provider.ParserItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.sensor.provider.SensorItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.model.internal.unit.provider.UnitItemProviderAdapterFactory;
import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.SelectionDialog;

/**
 * @author popescu
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class ResourceSelectionDialog extends SelectionDialog {

   protected EditingDomain editingDomain;
   protected Object selection;
   
	/**
	 * @param parentShell
	 */
	public ResourceSelectionDialog(Shell parentShell, EditingDomain editingDomain) {
		super(parentShell);
		
		setTitle(AcadEditorPlugin.getPlugin().getString("STR_SELC_DLG_TITLE"));
		this.editingDomain = editingDomain;
	}

	protected Control createDialogArea(Composite parent) {
	  // create composite 
	  Composite dialogArea = (Composite)super.createDialogArea(parent);
	  GridData data = GridUtil.createFill();
	  data.widthHint = 300;
	  data.heightHint = 400;
	  dialogArea.setLayoutData(data);
	  dialogArea.setLayout(new GridLayout());
	  
	  Tree tree = new Tree(dialogArea, SWT.SINGLE|SWT.BORDER);
	  tree.setLayoutData(GridUtil.createFill());
	  final TreeViewer selectionViewer = new TreeViewer(tree);
	  
	  List factories = new ArrayList();
	  factories.add(new ResourceItemProviderAdapterFactory());
	  factories.add(new ConfigurationItemProviderAdapterFactory());
	  factories.add(new ExtractorItemProviderAdapterFactory());
	  factories.add(new ContextItemProviderAdapterFactory());
	  factories.add(new OutputterItemProviderAdapterFactory());
	  factories.add(new SensorItemProviderAdapterFactory());
	  factories.add(new AdapterItemProviderAdapterFactory());
	  factories.add(new ParserItemProviderAdapterFactory());
	  factories.add(new FormatterItemProviderAdapterFactory());
	  factories.add(new UnitItemProviderAdapterFactory());

	  ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(factories);
	  
	  selectionViewer.setContentProvider(new AdapterFactoryContentProvider(adapterFactory));
	  selectionViewer.setLabelProvider(new AdapterFactoryLabelProvider(adapterFactory));
	  
	  EList list = editingDomain.getResourceSet().getResources();
//	  if(list.size() > 0)
//		  selectionViewer.setInput(list.get(0));		   
//	  else
//		  selectionViewer.setInput(editingDomain.getResourceSet());
		if(list.size() > 0)
		{
			Object selected = list.get(0);
			for (Iterator iter = list.iterator(); iter.hasNext();) {
				Resource element = (Resource) iter.next();
				if(element.getURI().fileExtension().equals("adapter"))
				{
					EClass eClass = ExtendedMetaData.INSTANCE.getDocumentRoot(AdapterPackage.eINSTANCE);
					EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature("adapter");
					EObject rootObject = (EObject)element.getContents().get(0);
//					AdapterType adapter = (AdapterType)rootObject.eGet(eStructuralFeature);
					
					selected = rootObject;
					break;
				}
			}
			
			selectionViewer.setInput(selected);
		}
		else
			selectionViewer.setInput(editingDomain.getResourceSet());
	  
		selectionViewer.addSelectionChangedListener(
			new ISelectionChangedListener() {
				public void selectionChanged(SelectionChangedEvent event) {
					IStructuredSelection selection = (IStructuredSelection)event.getSelection();
					setSelection(selection.getFirstElement()); // allow null
				}
			});
		selectionViewer.addDoubleClickListener(
			new IDoubleClickListener() {
				public void doubleClick(DoubleClickEvent event) {
					ISelection selection = event.getSelection();
					if (selection instanceof IStructuredSelection) {
						Object item = ((IStructuredSelection)selection).getFirstElement();
						if (selectionViewer.getExpandedState(item))
						selectionViewer.collapseToLevel(item, 1);
						else
						selectionViewer.expandToLevel(item, 1);
					}
				}
			});
	  
	  return dialogArea;
	}

/**
 * @return
 */
public Object getSelection() {
	return selection;
}

/**
 * @param object
 */
public void setSelection(Object object) {
	selection = object;
}

}
