/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: AcadEditorPreferencePage.java,v 1.6 2005/04/06 14:25:23 popescu Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.logging.adapter.ui.preferences;

import org.eclipse.hyades.logging.adapter.ui.AcadEditorPlugin;
import org.eclipse.hyades.ui.internal.util.GridDataUtil;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AcadEditorPreferencePage extends PreferencePage
	implements IWorkbenchPreferencePage{

	public static int MAX_SIZE = 100;
	public static int DEFAULT_SIZE = 10;
	public static final String BUFFER_SIZE = "buffer_size";
	private Text sizeText;
	
	
	public static final String SWITCH_TO_PERSPECTIVE_KEY = "switch_to_perspective";
	private Button _alwaysPersp;
	private Button _neverPersp;
	private Button _promptPersp;	
	
	protected static PreferencePage INSTANCE;
	/**
	 * Constructor for PluginPreferencePage.
	 */
	public AcadEditorPreferencePage()
	{
		super();
		INSTANCE = this;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.PreferencePage#createContents(org.eclipse.swt.widgets.Composite)
	 */
	protected Control createContents(Composite parent) {
		Composite composite= new Composite(parent, SWT.NONE);	
		
		GridLayout layout= new GridLayout();
		layout.marginWidth= 5;
		layout.marginHeight= 10;	
		layout.numColumns= 1;
		layout.verticalSpacing = 20;		
		composite.setLayout(layout);
		
		Group content = new Group(composite, SWT.NONE);
		content.setText(AcadEditorPlugin.getPlugin().getString("STR_GLA_PREF_BUFFER_GRP"));
		layout = new GridLayout();
		layout.numColumns = 2;
		layout.marginWidth = 5;
		layout.verticalSpacing = 5;		
		layout.makeColumnsEqualWidth = false;
		content.setLayout(layout);
		content.setLayoutData(GridDataUtil.createHorizontalFill());

		Label prefDesc = new Label(content, SWT.WRAP);
		prefDesc.setText(AcadEditorPlugin.getPlugin().getString("STR_GLA_PREF_MESSAGE", new Object[] {String.valueOf(MAX_SIZE)}));
		GridData data = GridDataUtil.createHorizontalFill();
		data.widthHint = 400;
		data.horizontalSpan = 2;
		prefDesc.setLayoutData(data);
		
		Label textDesc = new Label(content, SWT.NULL);
		textDesc.setText(AcadEditorPlugin.getPlugin().getString("STR_GLA_PREF_BUFFER_SIZE")); //$NON-NLS-1$
		sizeText = new Text(content, SWT.BORDER);
		data = GridDataUtil.createFill();
		data.widthHint = 50;
		data.horizontalAlignment = SWT.BEGINNING;
		sizeText.setLayoutData(data);
		sizeText.setFocus();
		sizeText.addModifyListener(new ModifyListener(){

			public void modifyText(ModifyEvent e) {
				String value = sizeText.getText();
				String errorMessage = null;
				try{
					int size = Integer.parseInt(value);
					if (size > MAX_SIZE)
						errorMessage = AcadEditorPlugin.getPlugin().getString("ERROR_BUFFER_SIZE_TOO_LARGE", new Object[] {String.valueOf(MAX_SIZE)});
					else if (size < 0)
						errorMessage = AcadEditorPlugin.getPlugin().getString("ERROR_BUFFER_SIZE_NEGATIVE");
					else if (size == 0)
						errorMessage = AcadEditorPlugin.getPlugin().getString("ERROR_BUFFER_SIZE_NOT_INTEGER");
				}catch(Exception exp){
					errorMessage = AcadEditorPlugin.getPlugin().getString("ERROR_BUFFER_SIZE_NOT_INTEGER");
				}
				AcadEditorPreferencePage.INSTANCE.setErrorMessage(errorMessage);
				AcadEditorPreferencePage.INSTANCE.setValid(errorMessage==null);
			}});

		Group switchPerspGroup = new Group(composite, SWT.NONE);
		switchPerspGroup.setText(AcadEditorPlugin.getDefault().getString("GLA_SWITCH_PERSPECTIVE_GRP"));
		layout = new GridLayout();
		layout.numColumns = 3;
		switchPerspGroup.setLayout(layout);
		data = GridDataUtil.createHorizontalFill();
		data.horizontalSpan = 2;	
		switchPerspGroup.setLayoutData(data);
		
//		Label switchPerspDesc = new Label(switchPerspGroup, SWT.WRAP);
//		switchPerspDesc.setText(AcadEditorPlugin.getDefault().getString("GLA_SWITCH_PERSPECTIVE_GRP"));
//		data = GridDataUtil.createHorizontalFill();
//		//data.widthHint = 400;
//		data.horizontalSpan = 3;
//		switchPerspDesc.setLayoutData(data);
		
		_alwaysPersp = new Button(switchPerspGroup, SWT.RADIO);
		_alwaysPersp.setText(AcadEditorPlugin.getDefault().getString("GLA_SWITCH_PERSPECTIVE_ALWAYS"));

		_neverPersp = new Button(switchPerspGroup, SWT.RADIO);
		_neverPersp.setText(AcadEditorPlugin.getDefault().getString("GLA_SWITCH_PERSPECTIVE_NEVER"));

		_promptPersp = new Button(switchPerspGroup, SWT.RADIO);
		_promptPersp.setText(AcadEditorPlugin.getDefault().getString("GLA_SWITCH_PERSPECTIVE_PROMPT"));
		
		
		initializeValues();

		//WorkbenchHelp.setHelp(tableViewer.getControl(), ContextIds.LOGGING_PREF_PLUGIN_LEVEL);
		return composite;
	}
	
	public void initializeValues(){
		int size =  AcadEditorPlugin.getPlugin().getPluginPreferences().getInt(BUFFER_SIZE);
		sizeText.setText(Integer.toString(size));
		
		setSwitchPerspOption(AcadEditorPlugin.getPlugin().getPluginPreferences().getString(SWITCH_TO_PERSPECTIVE_KEY));		
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPreferencePage#init(org.eclipse.ui.IWorkbench)
	 */
	public void init(IWorkbench workbench) {
	}

	/**
	 * Do anything necessary because the OK button has been pressed.
	 *
	 * @return whether it is okay to close the preference page
	 */
	public boolean performOk() {
		storeValues();
		return true;
	}
	
	/*
	 * @see PreferencePage#performDefaults()
	 */
	protected void performDefaults()
	{
		super.performDefaults();
		AcadEditorPlugin.getPlugin().getPluginPreferences().setToDefault(BUFFER_SIZE);
		this.sizeText.setText(""+AcadEditorPlugin.getPlugin().getPluginPreferences().getDefaultInt(BUFFER_SIZE));
		
		AcadEditorPlugin.getPlugin().getPluginPreferences().setToDefault(SWITCH_TO_PERSPECTIVE_KEY);		
		setSwitchPerspOption(AcadEditorPlugin.getPlugin().getPluginPreferences().getDefaultString(SWITCH_TO_PERSPECTIVE_KEY));
	}

	private void storeValues(){
		int size = -1;
		try{
			size = Integer.parseInt(sizeText.getText());
		}catch(Exception e){}
		
		AcadEditorPlugin.getPlugin().getPluginPreferences().setValue(BUFFER_SIZE, size);
		AcadEditorPlugin.getPlugin().getPluginPreferences().setValue(SWITCH_TO_PERSPECTIVE_KEY, getSwitchPerspOption());
		
		// since there is no preferenceStore, the preferences can not be saved by preferenceStore.save()
		// have to call this Plugin.savePluginPreferences() to save the data.
		AcadEditorPlugin.getPlugin().savePluginPreferences();
	}
	
	public void setSwitchPerspOption(String value) {
		if (MessageDialogWithToggle.ALWAYS.equals(value)) {
			_alwaysPersp.setSelection(true);
			_neverPersp.setSelection(false);
			_promptPersp.setSelection(false);
		}
		else if (MessageDialogWithToggle.NEVER.equals(value)) {
			_neverPersp.setSelection(true);
			_alwaysPersp.setSelection(false);
			_promptPersp.setSelection(false);
		}
		else {
			_promptPersp.setSelection(true);
			_alwaysPersp.setSelection(false);
			_neverPersp.setSelection(false);
		}
	}	
	
	public String getSwitchPerspOption() {
		if (_alwaysPersp.getSelection()) {
			return MessageDialogWithToggle.ALWAYS;
		}
		else if (_neverPersp.getSelection()) {
			return MessageDialogWithToggle.NEVER;
		}
		else {
			return MessageDialogWithToggle.PROMPT;
		}
	}	
}
