/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: MoveSDDown.java,v 1.3 2005/02/16 22:24:05 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions;


import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.hyades.uml2sd.ui.view.SDWidget;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IViewPart;

/**
 * @author sveyrier
 *
 */
public class MoveSDDown extends Action{

	protected SDWidget viewer = null;
	protected SDView view = null;
	
	public MoveSDDown (IViewPart _view)
	{
		super();
		view = (SDView)_view;
		if (view instanceof SDView)
			viewer = ((SDView)view).getSDWidget();
	}

	public void run ()
	{
		if (viewer!=null)
			viewer.scrollBy( 0, +viewer.getVisibleHeight() );
	}
}
