/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: Zoom.java,v 1.11 2005/02/16 22:24:06 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions;


import java.net.URL;

import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.hyades.uml2sd.ui.view.SDWidget;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;

/**
 * @author sveyrier
 *
 */
public class Zoom extends Action{

	protected SDWidget viewer = null;
	protected SDView view = null;
	protected boolean lastZoomIn = false;
	protected boolean lastZoomOut = false;
	protected boolean lastZoom = true;
	
	private static Cursor zoomIn = null;
	private static Cursor zoomOut = null;

	public Zoom (IViewPart _view)
	{
		super("",AS_RADIO_BUTTON);//$NON-NLS-1$
		view = (SDView)_view;
		if (view instanceof SDView)
			viewer = ((SDView)view).getSDWidget();
		if ((zoomIn != null)&&(!zoomIn.isDisposed()))
			zoomIn.dispose();
		if ((zoomOut != null)&&(!zoomOut.isDisposed()))
			zoomOut.dispose();
		zoomIn = new Cursor(Display.getCurrent(), getImageData("zoomin_source.bmp").getImageData(), //$NON-NLS-1$
					getImageData("zoom_mask.bmp").getImageData(),0,0);  //$NON-NLS-1$
		zoomOut = new Cursor(Display.getCurrent(), getImageData("zoomout_source.bmp").getImageData(),//$NON-NLS-1$
					getImageData("zoom_mask.bmp").getImageData(),0,0);//$NON-NLS-1$
	}

	public void run ()
	{
		
		if (getId().equals("org.eclipse.hyades.uml2sd.ui.actions.ZoomOutCoolBar")) //$NON-NLS-1$
		{
			//Eclipse 3.0 M7 workaround 
			if (lastZoomOut==isChecked())
				setChecked(!isChecked());
			viewer.setZoomOutMode(isChecked());
			lastZoomOut = isChecked();
			lastZoom=false;
			if (isChecked())
			{
				viewer.setCursor(zoomOut);
				setActionChecked("org.eclipse.hyades.uml2sd.ui.actions.NoZoom",false);//$NON-NLS-1$
			}
			else 
			{
				viewer.setCursor(new Cursor(Display.getDefault(),SWT.CURSOR_ARROW));
				setActionChecked("org.eclipse.hyades.uml2sd.ui.actions.NoZoom",true);//$NON-NLS-1$
			}
		}
		else if (getId().equals("org.eclipse.hyades.uml2sd.ui.actions.ZoomInCoolBar")) //$NON-NLS-1$
		{
			//Eclipse 3.0 M7 workaround 
			if (lastZoomIn==isChecked())
				setChecked(!isChecked());
			viewer.setZoomInMode(isChecked());
			lastZoomIn = isChecked();
			lastZoom=false;
			if (isChecked())
			{
				viewer.setCursor(zoomIn);
				setActionChecked("org.eclipse.hyades.uml2sd.ui.actions.NoZoom",false);//$NON-NLS-1$
			}
			else 
			{
				viewer.setCursor(new Cursor(Display.getDefault(),SWT.CURSOR_ARROW));
				setActionChecked("org.eclipse.hyades.uml2sd.ui.actions.NoZoom",true);//$NON-NLS-1$
			}
		}
		else if (getId().equals("org.eclipse.hyades.uml2sd.ui.actions.ResetZoom")) //$NON-NLS-1$
		{
			viewer.resetZoomFactor();
			//The reset action is a radio button only to uncheck the zoomin and out button
			//when it is clicked. This avoid adding code to do it manually
			//We only have to force it to false every time
			lastZoom=false;
			setChecked(false);
			setActionChecked("org.eclipse.hyades.uml2sd.ui.actions.NoZoom",true);//$NON-NLS-1$
		}
		else if (getId().equals("org.eclipse.hyades.uml2sd.ui.actions.NoZoom")) //$NON-NLS-1$
		{
			setChecked(true);
			viewer.setZoomInMode(false);
			viewer.setZoomInMode(false);
			viewer.setCursor(new Cursor(Display.getDefault(),SWT.CURSOR_ARROW));
		}
	}
	

	public void selectionChanged(IAction action, ISelection selection)
	{		
	}
	
	private static URL BASIC_URL=null;
	static
	{
		//URL to get images from plugins
		//perhaps we can found better code to load images ...
		//but at this time I know this: 
		try {
		BASIC_URL = new URL( "platform", "localhost", "plugin");//$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		} catch( Exception E ) {
			System.err.println(E);
		}
	}
   
	public ImageDescriptor getImageData( String _name )
	{
		try {
		 URL url=new URL( BASIC_URL, "plugin/org.eclipse.hyades.uml2sd.ui/icons/"+ _name);//$NON-NLS-1$
		 ImageDescriptor img = ImageDescriptor.createFromURL( url );
		 return img;
		} catch( Exception E ) {
				System.err.println(E);
				 }
		return null;
	}
	
	public void setActionChecked(String id,boolean checked)
	{
		IActionBars bar = view.getViewSite().getActionBars();
		if (bar ==null)
			return;
		IToolBarManager barManager = bar.getToolBarManager();
		if (barManager == null)
			return;
		IContributionItem nextPage = barManager.find(id);
		if (nextPage!= null && nextPage instanceof ActionContributionItem)
		{
			IAction action = ((ActionContributionItem)nextPage).getAction();
			if (action !=null)
				action.setChecked(checked);
		}
	}
}
