/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISDCollapseProvider.java,v 1.4 2005/02/16 22:24:06 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions.provider;

import org.eclipse.hyades.uml2sd.ui.core.Lifeline;

/**
 * Sequence diagram loaders which want to support Drag and Drop collapsing in the 
 * sequence diagram must implement this interface and register this implementation using
 * SDViewer.setCollapsingProvider();
 * 
 * @author sveyrier
 */
public interface ISDCollapseProvider {
	
	/**
	 * Called back when the sequence diagram is requesting 2 lifelines collapsing
	 * @param lifeline1 - One of the lifeline to collapse
	 * @param Lifeline2 - The other lifeline to collapse with
	 */
	public void collapseTwoLifelines(Lifeline lifeline1, Lifeline lifeline2);

}
