/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: ISDFindProvider.java,v 1.5 2005/02/16 22:24:06 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions.provider;

import org.eclipse.hyades.uml2sd.ui.actions.widgets.Criteria;

/**
 * Sequence Diagram loaders which implement this class provide the
 * actions for finding the sequence diagram.
 * This interface also allow the implemententor to set wich action/feature are supported
 * 
 * Action provider are associated to a Sequence Diagram SDWidget calling 
 * SDViewer.setSDFindProvider()
 * 
 * @author sveyrier
 *
 */
public interface ISDFindProvider extends ISDGraphNodeSupporter{

	/**
	 * Called when the Find dialog box OK button is pressed
	 * @param toApply user selection made in the dialog box
	 * @return true if the find got a non empty result
	 */
	public boolean find(Criteria toapply);

	/**
	 * Called when dialog is closed
	 */
	public void cancel();

}
