/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: SortAsyncForBackward.java,v 1.5 2005/02/16 22:24:06 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.util;

import java.util.Comparator;

import org.eclipse.hyades.uml2sd.ui.core.AsyncMessage;
/**
 * Aynchrnous message comparator
 * Compare two asyncMessages only taking into account 
 * the event occurrence when their appear.<br>
 * 
 * Used to order the AsyncMessage list insuring that
 * prev node has both of his ends smaller than the current node
 * 
 * @author sveyrier
 *
 */
public class SortAsyncForBackward implements Comparator{
	
	/**
	 * Compares two asynchronous messages
	 * Returns 0 (equal) if one of the message is not asynchrnous
	 * @return 1 if arg0 is greater, 0 if equal, -1 otherwise
	 */
	public int compare(Object arg0, Object arg1) {
		if (arg0 instanceof AsyncMessage && arg1 instanceof AsyncMessage)
		{
			AsyncMessage m1 = (AsyncMessage)arg0;
			AsyncMessage m2 = (AsyncMessage)arg1;
			int m1Max,m2Max;
			//AsyncMessage has two ends which may have different event occurrences
			//Search for the greater event occurrence for each messages
			if (m1.getStartOccurrence()>m1.getEndOccurrence())
				m1Max=m1.getStartOccurrence();
			else m1Max=m1.getEndOccurrence();
			if(m2.getStartOccurrence()>m2.getEndOccurrence())
				m2Max=m2.getStartOccurrence();
			else m2Max=m2.getEndOccurrence();
			
			int m1Min,m2Min;
			//Search for the smaller event occurrence for each messages
			if (m1.getStartOccurrence()>m1.getEndOccurrence())
				m1Min=m1.getEndOccurrence();
			else m1Min=m1.getStartOccurrence();
			if(m2.getStartOccurrence()>m2.getEndOccurrence())
				m2Min=m2.getEndOccurrence();
			else m2Min=m2.getStartOccurrence();
			
			if (m1Max>m2Max)
				return 1;
			else if (m1Max == m2Max)
				if (m1Min == m2Min)
					return 0;
				else if (m1Min>m2Min)
					return -1;
				else return 1;
			else return -1;
		}
		else return 0;
	}

}
