/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: TimeUtil.java,v 1.3 2005/05/09 08:34:48 dguilbaud Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.util;

import java.text.MessageFormat;

import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;

public class TimeUtil {
	
//	private static class SDViewerPlugin {
//
//		private static HashMap map = new HashMap();
//		static {
//			map.put("STR_DAY_HOURS","{0,number} day {1,number,00} h");
//			map.put("STR_DAYS_HOURS","{0,number} days {1,number,00} h");
//			map.put("STR_HOURS_MINUTES","{0,number} h {1,number,00} min");
//			map.put("STR_MINUTES_SECONDS","{0,number} min {1,number,00} s");
//			map.put("STR_SECONDS","{0,number,0.###} s");
//			map.put("STR_MILLISECONDS","{0,number,0.###} ms");
//			map.put("STR_MICROSECONDS","{0,number,0.###} \u00B5s");
//		}
//		public static String getResourceString(String string) {
//			return (String)map.get(string);
//		}
//		
//	}
//
//	public static void main(String[] args) {
//		printIt(90000.12345);
//		printIt(3700.12345);
//		printIt(61.12345);
//		printIt(9.12345);
//		printIt(3.0000012345);
//		printIt(0.912345);
//		printIt(0.90000012345);
//		printIt(0.000912345);
//		printIt(0.000000912345);
//	}
//
//	/**
//	 * @param d
//	 */
//	private static void printIt(double d) {
//		System.out.println(d+" -> "+timeToString(d));
//		System.out.println(-d+" -> "+timeToString(-d));
//	}
	
	private static String normalStrings[] = {
		SDViewerPlugin.getResourceString("STR_DAYS_HOURS"), //$NON-NLS-1$
		SDViewerPlugin.getResourceString("STR_DAY_HOURS"), //$NON-NLS-1$
		SDViewerPlugin.getResourceString("STR_HOURS_MINUTES"), //$NON-NLS-1$
		SDViewerPlugin.getResourceString("STR_MINUTES_SECONDS"), //$NON-NLS-1$
		SDViewerPlugin.getResourceString("STR_SECONDS"), //$NON-NLS-1$
		SDViewerPlugin.getResourceString("STR_MILLISECONDS"), //$NON-NLS-1$
		SDViewerPlugin.getResourceString("STR_MICROSECONDS") //$NON-NLS-1$
	};

	private static String accessibleStrings[] = {
		SDViewerPlugin.getResourceString("STR_FULL_WORDS_DAYS_HOURS"), //$NON-NLS-1$
		SDViewerPlugin.getResourceString("STR_FULL_WORDS_DAY_HOURS"), //$NON-NLS-1$
		SDViewerPlugin.getResourceString("STR_FULL_WORDS_HOURS_MINUTES"), //$NON-NLS-1$
		SDViewerPlugin.getResourceString("STR_FULL_WORDS_MINUTES_SECONDS"), //$NON-NLS-1$
		SDViewerPlugin.getResourceString("STR_FULL_WORDS_SECONDS"), //$NON-NLS-1$
		SDViewerPlugin.getResourceString("STR_FULL_WORDS_MILLISECONDS"), //$NON-NLS-1$
		SDViewerPlugin.getResourceString("STR_FULL_WORDS_MICROSECONDS") //$NON-NLS-1$
	};

	/**
	 * Translate the given item into a localised string.
	 * @param time the time to translate
	 * @return the localised string
	 */
	public static String timeToString(double time) {
		return timeToString(time, normalStrings);
	}
	
	/**
	 * Translate the given item into an accessible localised string.
	 * @param time - the time to translate
	 * @return the localised string
	 */
	public static String accessibleTimeToString(double time) {
		return timeToString(time, accessibleStrings);
	}

	private static String timeToString(double time, String ress[]) {
		String ret;
		if (Math.abs(time) >= 24*60*60) {
			int days, hours;
			days = (int)(time / (24*60*60));
			hours = Math.abs((int)(time % (24*60*60))/(60*60));
			if ((days != 1)&&(days != -1)) {
				ret = MessageFormat.format(ress[0],
										   new Object[] { new Integer(days), new Integer(hours) } );
			} else {
				ret = MessageFormat.format(ress[1],
										   new Object[] { new Integer(days), new Integer(hours) } );
			}
		} else if (Math.abs(time) >= 60*60) {
			int hours, mins;
			hours = (int)(time / (60*60));
			mins = Math.abs((int)(time % (60*60))/(60));
			ret = MessageFormat.format(ress[2],
									   new Object[] { new Integer(hours), new Integer(mins) } );
		} else if (Math.abs(time) >= 60) {
			int mins, s;
			mins = (int)(time / 60);
			s = Math.abs((int)(time % 60));
			ret = MessageFormat.format(ress[3],
								 	   new Object[] { new Integer(mins), new Integer(s) } );
		} else if (Math.abs(time) >= 1) {
			ret = MessageFormat.format(ress[4],
								 	   new Object[] { new Double(time) } );
		} else if (Math.abs(time*1000) >= 1){
			ret = MessageFormat.format(ress[5],
									   new Object[] { new Double(time*1000) } );
		} else {
			ret = MessageFormat.format(ress[6],
									   new Object[] { new Double(time*1000000) } );
		}
		return ret;
	}

}
