/**********************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * $Id: OpenToolBox.java,v 1.3 2005/02/16 22:24:06 qiyanli Exp $
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ztest;

import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.action.Action;

/**
 * Action delegate for 'Filter' on a message
 */
public class OpenToolBox extends Action {

	private SDView view;	

	/**
	 * @param view_
	 */
	public OpenToolBox(SDView view_) {
		super("SD ToolBox");//$NON-NLS-1$
		setImageDescriptor(SDViewerPlugin.getResourceImage("sequencediagram_co.gif")); //$NON-NLS-1$
		setId("org.eclipse.hyades.uml2sd.ui.ztest"); //$NON-NLS-1$
		setToolTipText("ToolBox");//$NON-NLS-1$
		view = view_;
	}
	
	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run() {
		ToolBox toolBox=new ToolBox(view.getSDWidget().getShell(), view);
		toolBox.open();
	}
	
}
