/**********************************************************************
Copyright (c) 2005 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: AnalyzerEnv.java,v 1.5 2005/02/16 22:19:53 qiyanli Exp $

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.hyades.collection.threadanalyzer;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;

/*
WARNING:  This object is versioned.  If changes are made to object structure,
          the versioning code must be updated.
*/

public class AnalyzerEnv implements Externalizable
{
   private static int _curVersion = 1; // update when version changes (data added)
   private int _version = -1;

   public AnalyzerEnv( )
   {
      _version = _curVersion;
      _os = "unknown";
      _jdk = "unknown";
      _props = new Properties();
   }


   public void setProperty( String propName, String value )
   {
      _props.setProperty( propName, value );
   }

   public String getProperty( String propName )
   {
      return _props.getProperty( propName );
   }

   public void print( int indent )
   {

      String sIndent = "";
      for( int i = 0; i < indent; ++i )
         sIndent += "\t";
   }

   public void writeExternal( ObjectOutput out ) throws IOException
   {
      out.writeInt( _curVersion );
      out.writeObject( _os );
      out.writeObject( _jdk );
      out.writeObject( _props );
   }

   public void readExternal( ObjectInput in ) throws IOException, ClassNotFoundException
   {
      _version = in.readInt();
      _os = (String)in.readObject();
      _jdk = (String)in.readObject();
      _props = (Properties)in.readObject();

   }
   //private String dummyStreamTestVar = null;
   public String _os = null;
   public String _jdk = null;
   public Properties _props = null;
   // end of version 1 vars
   // add version 2 vars here

   // 
   // add statics and transients here
   //

}

