/**********************************************************************
Copyright (c) 2005 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: Monitor.java,v 1.5 2005/02/16 22:19:54 qiyanli Exp $

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
/*
WARNING:  This object is versioned.  If changes are made to object structure,
          the versioning code must be updated.
*/

package org.eclipse.hyades.collection.threadanalyzer;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import java.util.Vector;



public class Monitor implements Externalizable
{
   private static int _curVersion = 1; // update when version changes (data added)
   private int _version = -1;

   public Monitor( String name, int monitor_type )
   {
      _version       = _curVersion;
      _name          = name;
      _monitor_type  = monitor_type;
      _ID            = DumpData.getID();
      _waiters       = new Vector();
      _owner         = null;
      _props         = new Properties();
   }

   public String getProperty( String propName )
   {
      return _props.getProperty( propName );
   }

   public void setProperty( String propName, String propVal )
   {
      _props.setProperty( propName, propVal );
   }

   public void addWaiter( Thd waiter )
   {
      _waiters.add( waiter );
      waiter.setWaitMonitor( this );
   }
   
   public int getId()
   {
      return _ID;
   }

   public void setOwner( Thd owner )
   {
      _owner = owner;
   }

   public Vector format( int indent, boolean fHtml )
   {
      Vector v = new Vector();

      String sTab = "   ";
      String sIndent = "";
      for( int i = 0; i < indent; ++i )
         sIndent += "   ";
      v.add( sIndent + "==" + TAUtils.getNLSValue("ta.format.MonitorDump", "Monitor dump") + "==" );
      v.add( sIndent + sTab + _name );
      v.add( sIndent + sTab + sTab + TAUtils.getNLSValue("ta.format.Waiters", "Waiters") + "....... " + _waiters.size() );
      ++indent;
      //System.out.println( "monitor " + _name + " has " + _waiters.size() + " waiters " );
      for( int i = 0; i < _waiters.size(); ++i )
      {
         Thd thd = (Thd)_waiters.elementAt( i );
         //System.out.println( "\t" + "--" + thd.getName() );
         v.addAll( thd.format( indent, fHtml ));
         //System.out.println( "\t\tformatted results added to vector" );
         //thd.getTOS().print( ++indent );
      }


      return v;
   }

   public void print( int indent, boolean fHtml )
   {
      Vector v = format( indent, fHtml );
      for( int i = 0; i < v.size(); ++i )
         System.out.println( (String)v.elementAt(i) );
   }

   public String getName()
   {
      return _name;
   }

   public void writeExternal( ObjectOutput out ) throws IOException
   {
      out.writeInt( _curVersion );
      out.writeObject( _name );
      out.writeInt( _ID );
      out.writeObject( _owner );

      // write out the waiter thread ids
      //out.writeObject( _waiters );
      int waiters = _waiters.size();
      out.writeInt( waiters );
      for( int i = 0; i < waiters; ++i )
      {
         int waiterId = ((Thd)_waiters.elementAt( i )).getId();
         out.writeInt( waiterId );
         //System.out.println( "writing waiters..." + waiterId );
      }
      // end write out waiter thread ids

      out.writeInt( _monitor_type );
      out.writeObject( _props );
   }

   public void readExternal( ObjectInput in ) throws IOException, ClassNotFoundException
   {
      _version       = in.readInt();
      _name          = (String)in.readObject();
      _ID            = in.readInt();
      _owner         = (Thd)in.readObject();

      // read the waiter ids into the vector.  They will be 
      // fixed up to thread object references after all objects are read.
      //_waiters       = (Vector)in.readObject();

      int waiterCount = in.readInt();
      _waiters = new Vector();
      for( int i = 0; i < waiterCount; ++i )
      {
         int waiterId = in.readInt();
         _waiters.add( new Integer( waiterId ));
      }
      // end of read waiter ids

      _monitor_type  = in.readInt();
      _props         = (Properties)in.readObject();

   }

   public void fixupWaiters( DumpData d )
   {
      Vector tv = _waiters;
      //System.out.println( "Monitor = " + getName() );
      _waiters = new Vector();
      int waiters = tv.size();
      if( waiters > 0 )
      {
         for( int i = 0; i < waiters; ++i )
         {
            int thdID = ((Integer)tv.elementAt( i )).intValue();
            Thd thd = d.getThreadById( thdID );
            _waiters.add( thd );
            //System.out.println( "\tfixing up for thd=" + thd.getName() );
         }
      }
      else
      {
         //System.out.println( "\tdidn't fix up since there were no waiters." );
      }
   }

   public Monitor() // for externalization
   {
   }

   //private String dummyStreamTestVar = null;
   public String _name        = null;
   public int _ID             = -1;
   public Thd _owner          = null;
   public Vector _waiters     = null;
   public int _monitor_type   = -1;
   private Properties _props  = null;
   // End of version 1 variables
   // Add version 2 variables here - in sequence!


   // 
   // STATIC and Transients below here....
   //

   public static final int WAIT_MONITOR = 1;
   public static final int SYNC_MONITOR = 2;

}

