/**********************************************************************
Copyright (c) 2005 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: ParseIdents.java,v 1.5 2005/02/16 22:19:54 qiyanli Exp $

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.hyades.collection.threadanalyzer;
import java.util.Hashtable;
import java.util.Vector;

public class ParseIdents {
	private static int _curVersion = 1;	// update when version changes (data added)
	private int _version = -1;
	
	public ParseIdents(ThreadDump td, Hashtable t)
	{
		_idents = new Hashtable();
		_threadDump = td;
		_threads = t;
	}
	
	public void populate(int identIndex)
	{
	/*	Vector tdVector = _threadDump.getThreadDumpVector();
		int index = 0;
		int size = tdVector.size();
		for(; index <= size; index++)
		{
			if(((String)tdVector.elementAt(index)).indexOf("Thread identifiers (as used in flat monitors):") >= 0)
			{
				break;
			}
				
		}*/
		Vector tdVector = _threadDump.getThreadDumpVector();
		//int index = getLocation(tdVector,0,"Thread identifiers (as used in flat monitors):");
		int size = tdVector.size();
		
		String ident;
		String sys_thread_t;
		int sysIndex = 0;
		String line = null;
		int sIndex = -1;
		//line.indexOf("indent ");
		while (true) 
		{
			if(size < ++identIndex)
				break;
			line = ((String)tdVector.elementAt(identIndex));
			sIndex = line.indexOf("ident ");
			if(sIndex < 0)
				break;
			//ident would be grabbed from "ident ".length to the next space.
			//ident = line.substring(sIndex+6, sIndex+10);
			ident = line.substring(sIndex+6,line.indexOf(" ",sIndex+7));
			
			sysIndex = line.indexOf('(',sIndex+10);
			sys_thread_t = line.substring( sysIndex+1, line.indexOf(')', sysIndex+3) );
			addIdent(ident, sys_thread_t);
		}
	}
	
	public void addIdent(String ident, String sys_thread_t)
 	{
 		_idents.put(ident, sys_thread_t);
	}
	
/*	
	public String getSysThreadT(String ident) 
	{
		return (String)_idents.get(ident);
	}
*/	
	public Hashtable getIdents() 
	{
		return _idents;
	}
	
	public Hashtable _idents = null;
	protected ThreadDump _threadDump = null; // the original thread dump text.
	protected Hashtable _threads = null;
}
