/**********************************************************************
Copyright (c) 2005 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: TOSEntryPointCaller.java,v 1.5 2005/02/16 22:19:54 qiyanli Exp $

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.hyades.collection.threadanalyzer;

import java.util.Enumeration;
import java.util.Vector;

public class TOSEntryPointCaller
{

   public TOSEntryPointCaller( StkEntry stkEntry )
   {
      _stkEntry = stkEntry;
   }

   public void addThread( Thd thd )
   {
      _threads.add( thd );
   }

   public Enumeration getThreadEnum()
   {
      Enumeration e = _threads.elements();
      return e;
   }

   public Thd getNextThread( Enumeration e )
   {
      Thd tRet = null;
      if( e.hasMoreElements() )
      {        
         tRet = (Thd)e.nextElement();
      }
      return tRet;
   }

   public String getName()
   {
      return _stkEntry.getFQName();
   }

   
   private TOSEntryPointCaller() {}
   protected StkEntry _stkEntry = null;
   protected Vector _threads = null;

}

