/**********************************************************************
Copyright (c) 2005 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/epl-v10.html
$Id: TaTosPctPoolGridElement.java,v 1.5 2005/02/16 22:19:54 qiyanli Exp $

Contributors:
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.hyades.collection.threadanalyzer;



public class TaTosPctPoolGridElement implements TaGridElement
{
   public TaTosPctPoolGridElement( int pctOfPool, Object additionalInfo )
   {
      _pctOfPool = pctOfPool;
      _additional = additionalInfo;
   }
   private TaTosPctPoolGridElement()
   {
   }


   public String toString()
   {
      return ""+_pctOfPool;
   }

   public void setPctOfPool( int percentage )
   {
      _pctOfPool = percentage;
   }

   public int getPctOfPool( )
   {
      return _pctOfPool;
   }

   public int compareTo( TaGridElement g )
   {
      TaTosPctPoolGridElement e = (TaTosPctPoolGridElement)g;

      int iRet = 1;
      if( e._pctOfPool == _pctOfPool )
         iRet = 0;
      else if( e._pctOfPool < _pctOfPool )
         iRet = -1;
      return iRet;
   }
   
   public Object getAdditionalInfo()
   {
      return _additional;
   }

   private Object _additional = null;
   private int _pctOfPool = 0;
}
